/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class HtmlSource {
    private CharSequence sourceCode;
    private Snapshot snapshot;
    private FileObject sourceFileObject;

    public HtmlSource(CharSequence sourceCode) {
        this.sourceCode = sourceCode;
    }

    public HtmlSource(FileObject sourceFileObject) {
        this.sourceFileObject = sourceFileObject;
    }

    public HtmlSource(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public HtmlSource(CharSequence sourceCode, Snapshot snapshot, FileObject sourceFileObject) {
        this.sourceCode = sourceCode;
        this.snapshot = snapshot;
        this.sourceFileObject = sourceFileObject;
    }

    public synchronized CharSequence getSourceCode() {
        if (this.sourceCode == null) {
            if (this.snapshot != null) {
                this.loadContentFromSnapshot();
            } else if (this.sourceFileObject != null) {
                this.loadContentFromFileObject();
            }
        }
        return this.sourceCode;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public synchronized FileObject getSourceFileObject() {
        if (this.sourceFileObject == null && this.snapshot != null) {
            this.sourceFileObject = this.snapshot.getSource().getFileObject();
        }
        return this.sourceFileObject;
    }

    private void loadContentFromFileObject() {
        try {
            DataObject dobj = DataObject.find((FileObject)this.sourceFileObject);
            if (dobj != null) {
                EditorCookie cake = (EditorCookie)dobj.getCookie(EditorCookie.class);
                final StyledDocument doc = cake.openDocument();
                doc.render(new Runnable(){
                    final /* synthetic */ HtmlSource this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            this.this$0.sourceCode = doc.getText(0, doc.getLength());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void loadContentFromSnapshot() {
        this.sourceCode = this.snapshot.getText();
    }
}

