/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressFrame;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CaptureSchema {
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private final String defaultName = this.bundle.getString("DefaultSchemaName");
    private DBSchemaWizardData data;

    public CaptureSchema(DBSchemaWizardData data) {
        this.data = data;
    }

    protected void start() {
        String target = this.data.getName();
        DataFolder folder = this.data.getDestinationPackage();
        final LinkedList tables = this.data.getTables();
        final LinkedList views = this.data.getViews();
        final boolean allTables = this.data.isAllTables();
        ConnectionProvider cp = this.data.getConnectionProvider();
        try {
            final ConnectionProvider c = cp;
            final FileObject fo = folder.getPrimaryFile();
            if (target == null || target.equals("")) {
                target = FileUtil.findFreeFileName((FileObject)fo, (String)this.defaultName, (String)"dbschema");
            }
            final boolean conned = this.data.isConnected();
            final boolean ec = this.data.isExistingConn();
            final DatabaseConnection dbconn = this.data.getDatabaseConnection();
            final String target1 = target;
            this.data = null;
            RequestProcessor.getDefault().post(new Runnable(){
                final /* synthetic */ CaptureSchema this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        StatusDisplayer.getDefault().setStatusText(this.this$0.bundle.getString("CreatingDatabaseSchema"));
                        final ProgressFrame pf = new ProgressFrame();
                        final SchemaElementImpl sei = new SchemaElementImpl(c);
                        PropertyChangeListener listener = new PropertyChangeListener(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void propertyChange(PropertyChangeEvent event) {
                                if (event.getPropertyName().equals("totalCount")) {
                                    pf.setMaximum((Integer)event.getNewValue());
                                    return;
                                }
                                if (event.getPropertyName().equals("progress")) {
                                    pf.setValue((Integer)event.getNewValue());
                                    return;
                                }
                                if (event.getPropertyName().equals("tableName")) {
                                    String message = MessageFormat.format(this.this$1.this$0.bundle.getString("CapturingTable"), ((String)event.getNewValue()).toUpperCase());
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("FKt")) {
                                    String message = MessageFormat.format(this.this$1.this$0.bundle.getString("CaptureFK"), ((String)event.getNewValue()).toUpperCase(), this.this$1.this$0.bundle.getString("CaptureFKtable"));
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("FKv")) {
                                    String message = MessageFormat.format(this.this$1.this$0.bundle.getString("CaptureFK"), ((String)event.getNewValue()).toUpperCase(), this.this$1.this$0.bundle.getString("CaptureFKview"));
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("viewName")) {
                                    String message = MessageFormat.format(this.this$1.this$0.bundle.getString("CapturingView"), ((String)event.getNewValue()).toUpperCase());
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("cancel")) {
                                    sei.setStop(true);
                                    StatusDisplayer.getDefault().setStatusText("");
                                    return;
                                }
                            }
                        };
                        pf.propertySupport.addPropertyChangeListener(listener);
                        pf.setVisible(true);
                        sei.propertySupport.addPropertyChangeListener(listener);
                        final SchemaElement se = new SchemaElement(sei);
                        se.setName(DBIdentifier.create(target1));
                        if (allTables) {
                            sei.initTables(c, tables, views, true);
                        } else {
                            sei.initTables(c, tables, views, false);
                        }
                        pf.finishProgress();
                        if (!sei.isStop()) {
                            fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() throws IOException {
                                    FileLock fl;
                                    FileObject fo1 = fo.createData(target1, "dbschema");
                                    OutputStream out = fo1.getOutputStream(fl = fo1.lock());
                                    if (out == null) {
                                        throw new IOException("Unable to open output stream");
                                    }
                                    pf.setMessage(this.this$1.this$0.bundle.getString("SavingDatabaseSchema"));
                                    StatusDisplayer.getDefault().setStatusText(this.this$1.this$0.bundle.getString("SavingDatabaseSchema"));
                                    se.save(out);
                                    fl.releaseLock();
                                }
                            });
                            pf.setMessage(this.this$0.bundle.getString("SchemaSaved"));
                            StatusDisplayer.getDefault().setStatusText(this.this$0.bundle.getString("SchemaSaved"));
                            pf.setVisible(false);
                            pf.dispose();
                        }
                        if (conned) {
                            if (ec) {
                                ConnectionManager.getDefault().disconnect(dbconn);
                            } else {
                                c.closeConnection();
                            }
                        }
                    }
                    catch (Exception exc) {
                        Exceptions.printStackTrace((Throwable)exc);
                    }
                }
            }, 0);
        }
        catch (Exception exc) {
            String message = MessageFormat.format(this.bundle.getString("UnableToCreateSchema"), exc.getMessage());
            StatusDisplayer.getDefault().setStatusText(message);
            try {
                if (cp != null && this.data.isConnected()) {
                    if (this.data.isExistingConn()) {
                        ConnectionManager.getDefault().disconnect(this.data.getDatabaseConnection());
                    } else {
                        cp.closeConnection();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

