/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseStandbySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lagTimeInSeconds")
    private final Integer lagTimeInSeconds;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeDataGuardRoleChanged")
    private final Date timeDataGuardRoleChanged;
    @JsonProperty(value="timeDisasterRecoveryRoleChanged")
    private final Date timeDisasterRecoveryRoleChanged;

    @Deprecated
    @ConstructorProperties(value={"lagTimeInSeconds", "lifecycleState", "lifecycleDetails", "timeDataGuardRoleChanged", "timeDisasterRecoveryRoleChanged"})
    public AutonomousDatabaseStandbySummary(Integer lagTimeInSeconds, LifecycleState lifecycleState, String lifecycleDetails, Date timeDataGuardRoleChanged, Date timeDisasterRecoveryRoleChanged) {
        this.lagTimeInSeconds = lagTimeInSeconds;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeDataGuardRoleChanged = timeDataGuardRoleChanged;
        this.timeDisasterRecoveryRoleChanged = timeDisasterRecoveryRoleChanged;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getLagTimeInSeconds() {
        return this.lagTimeInSeconds;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeDataGuardRoleChanged() {
        return this.timeDataGuardRoleChanged;
    }

    public Date getTimeDisasterRecoveryRoleChanged() {
        return this.timeDisasterRecoveryRoleChanged;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseStandbySummary(");
        sb.append("super=").append(super.toString());
        sb.append("lagTimeInSeconds=").append(String.valueOf(this.lagTimeInSeconds));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeDataGuardRoleChanged=").append(String.valueOf(this.timeDataGuardRoleChanged));
        sb.append(", timeDisasterRecoveryRoleChanged=").append(String.valueOf(this.timeDisasterRecoveryRoleChanged));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseStandbySummary)) {
            return false;
        }
        AutonomousDatabaseStandbySummary other = (AutonomousDatabaseStandbySummary)((Object)o);
        return Objects.equals(this.lagTimeInSeconds, other.lagTimeInSeconds) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeDataGuardRoleChanged, other.timeDataGuardRoleChanged) && Objects.equals(this.timeDisasterRecoveryRoleChanged, other.timeDisasterRecoveryRoleChanged) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lagTimeInSeconds == null ? 43 : this.lagTimeInSeconds.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeDataGuardRoleChanged == null ? 43 : this.timeDataGuardRoleChanged.hashCode());
        result = result * 59 + (this.timeDisasterRecoveryRoleChanged == null ? 43 : this.timeDisasterRecoveryRoleChanged.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Stopping("STOPPING"),
        Stopped("STOPPED"),
        Starting("STARTING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Unavailable("UNAVAILABLE"),
        RestoreInProgress("RESTORE_IN_PROGRESS"),
        RestoreFailed("RESTORE_FAILED"),
        BackupInProgress("BACKUP_IN_PROGRESS"),
        ScaleInProgress("SCALE_IN_PROGRESS"),
        AvailableNeedsAttention("AVAILABLE_NEEDS_ATTENTION"),
        Updating("UPDATING"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        Restarting("RESTARTING"),
        Recreating("RECREATING"),
        RoleChangeInProgress("ROLE_CHANGE_IN_PROGRESS"),
        Upgrading("UPGRADING"),
        Inaccessible("INACCESSIBLE"),
        Standby("STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lagTimeInSeconds")
        private Integer lagTimeInSeconds;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeDataGuardRoleChanged")
        private Date timeDataGuardRoleChanged;
        @JsonProperty(value="timeDisasterRecoveryRoleChanged")
        private Date timeDisasterRecoveryRoleChanged;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lagTimeInSeconds(Integer lagTimeInSeconds) {
            this.lagTimeInSeconds = lagTimeInSeconds;
            this.__explicitlySet__.add("lagTimeInSeconds");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeDataGuardRoleChanged(Date timeDataGuardRoleChanged) {
            this.timeDataGuardRoleChanged = timeDataGuardRoleChanged;
            this.__explicitlySet__.add("timeDataGuardRoleChanged");
            return this;
        }

        public Builder timeDisasterRecoveryRoleChanged(Date timeDisasterRecoveryRoleChanged) {
            this.timeDisasterRecoveryRoleChanged = timeDisasterRecoveryRoleChanged;
            this.__explicitlySet__.add("timeDisasterRecoveryRoleChanged");
            return this;
        }

        public AutonomousDatabaseStandbySummary build() {
            AutonomousDatabaseStandbySummary model = new AutonomousDatabaseStandbySummary(this.lagTimeInSeconds, this.lifecycleState, this.lifecycleDetails, this.timeDataGuardRoleChanged, this.timeDisasterRecoveryRoleChanged);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseStandbySummary model) {
            if (model.wasPropertyExplicitlySet("lagTimeInSeconds")) {
                this.lagTimeInSeconds(model.getLagTimeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeDataGuardRoleChanged")) {
                this.timeDataGuardRoleChanged(model.getTimeDataGuardRoleChanged());
            }
            if (model.wasPropertyExplicitlySet("timeDisasterRecoveryRoleChanged")) {
                this.timeDisasterRecoveryRoleChanged(model.getTimeDisasterRecoveryRoleChanged());
            }
            return this;
        }
    }
}

