/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DbIormConfigUpdateDetail;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadataIormConfigUpdateDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="objective")
    private final Objective objective;
    @JsonProperty(value="dbPlans")
    private final List<DbIormConfigUpdateDetail> dbPlans;

    @Deprecated
    @ConstructorProperties(value={"objective", "dbPlans"})
    public ExadataIormConfigUpdateDetails(Objective objective, List<DbIormConfigUpdateDetail> dbPlans) {
        this.objective = objective;
        this.dbPlans = dbPlans;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Objective getObjective() {
        return this.objective;
    }

    public List<DbIormConfigUpdateDetail> getDbPlans() {
        return this.dbPlans;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataIormConfigUpdateDetails(");
        sb.append("super=").append(super.toString());
        sb.append("objective=").append(String.valueOf((Object)this.objective));
        sb.append(", dbPlans=").append(String.valueOf(this.dbPlans));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataIormConfigUpdateDetails)) {
            return false;
        }
        ExadataIormConfigUpdateDetails other = (ExadataIormConfigUpdateDetails)((Object)o);
        return Objects.equals((Object)this.objective, (Object)other.objective) && Objects.equals(this.dbPlans, other.dbPlans) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.objective == null ? 43 : this.objective.hashCode());
        result = result * 59 + (this.dbPlans == null ? 43 : this.dbPlans.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Objective implements BmcEnum
    {
        LowLatency("LOW_LATENCY"),
        HighThroughput("HIGH_THROUGHPUT"),
        Balanced("BALANCED"),
        Auto("AUTO"),
        Basic("BASIC");

        private final String value;
        private static Map<String, Objective> map;

        private Objective(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Objective create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Objective: " + key);
        }

        static {
            map = new HashMap<String, Objective>();
            for (Objective v : Objective.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objective")
        private Objective objective;
        @JsonProperty(value="dbPlans")
        private List<DbIormConfigUpdateDetail> dbPlans;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objective(Objective objective) {
            this.objective = objective;
            this.__explicitlySet__.add("objective");
            return this;
        }

        public Builder dbPlans(List<DbIormConfigUpdateDetail> dbPlans) {
            this.dbPlans = dbPlans;
            this.__explicitlySet__.add("dbPlans");
            return this;
        }

        public ExadataIormConfigUpdateDetails build() {
            ExadataIormConfigUpdateDetails model = new ExadataIormConfigUpdateDetails(this.objective, this.dbPlans);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataIormConfigUpdateDetails model) {
            if (model.wasPropertyExplicitlySet("objective")) {
                this.objective(model.getObjective());
            }
            if (model.wasPropertyExplicitlySet("dbPlans")) {
                this.dbPlans(model.getDbPlans());
            }
            return this;
        }
    }
}

