/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.NodeDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VmNetworkDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vlanId")
    private final String vlanId;
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="netmask")
    private final String netmask;
    @JsonProperty(value="gateway")
    private final String gateway;
    @JsonProperty(value="domainName")
    private final String domainName;
    @JsonProperty(value="nodes")
    private final List<NodeDetails> nodes;

    @Deprecated
    @ConstructorProperties(value={"vlanId", "networkType", "netmask", "gateway", "domainName", "nodes"})
    public VmNetworkDetails(String vlanId, NetworkType networkType, String netmask, String gateway, String domainName, List<NodeDetails> nodes) {
        this.vlanId = vlanId;
        this.networkType = networkType;
        this.netmask = netmask;
        this.gateway = gateway;
        this.domainName = domainName;
        this.nodes = nodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<NodeDetails> getNodes() {
        return this.nodes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmNetworkDetails(");
        sb.append("super=").append(super.toString());
        sb.append("vlanId=").append(String.valueOf(this.vlanId));
        sb.append(", networkType=").append(String.valueOf((Object)this.networkType));
        sb.append(", netmask=").append(String.valueOf(this.netmask));
        sb.append(", gateway=").append(String.valueOf(this.gateway));
        sb.append(", domainName=").append(String.valueOf(this.domainName));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmNetworkDetails)) {
            return false;
        }
        VmNetworkDetails other = (VmNetworkDetails)((Object)o);
        return Objects.equals(this.vlanId, other.vlanId) && Objects.equals((Object)this.networkType, (Object)other.networkType) && Objects.equals(this.netmask, other.netmask) && Objects.equals(this.gateway, other.gateway) && Objects.equals(this.domainName, other.domainName) && Objects.equals(this.nodes, other.nodes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vlanId == null ? 43 : this.vlanId.hashCode());
        result = result * 59 + (this.networkType == null ? 43 : this.networkType.hashCode());
        result = result * 59 + (this.netmask == null ? 43 : this.netmask.hashCode());
        result = result * 59 + (this.gateway == null ? 43 : this.gateway.hashCode());
        result = result * 59 + (this.domainName == null ? 43 : this.domainName.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NetworkType implements BmcEnum
    {
        Client("CLIENT"),
        Backup("BACKUP"),
        DisasterRecovery("DISASTER_RECOVERY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NetworkType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NetworkType.class);
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vlanId")
        private String vlanId;
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="netmask")
        private String netmask;
        @JsonProperty(value="gateway")
        private String gateway;
        @JsonProperty(value="domainName")
        private String domainName;
        @JsonProperty(value="nodes")
        private List<NodeDetails> nodes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            this.__explicitlySet__.add("vlanId");
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            this.__explicitlySet__.add("netmask");
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            this.__explicitlySet__.add("gateway");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.__explicitlySet__.add("domainName");
            return this;
        }

        public Builder nodes(List<NodeDetails> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public VmNetworkDetails build() {
            VmNetworkDetails model = new VmNetworkDetails(this.vlanId, this.networkType, this.netmask, this.gateway, this.domainName, this.nodes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmNetworkDetails model) {
            if (model.wasPropertyExplicitlySet("vlanId")) {
                this.vlanId(model.getVlanId());
            }
            if (model.wasPropertyExplicitlySet("networkType")) {
                this.networkType(model.getNetworkType());
            }
            if (model.wasPropertyExplicitlySet("netmask")) {
                this.netmask(model.getNetmask());
            }
            if (model.wasPropertyExplicitlySet("gateway")) {
                this.gateway(model.getGateway());
            }
            if (model.wasPropertyExplicitlySet("domainName")) {
                this.domainName(model.getDomainName());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            return this;
        }
    }
}

