/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.web.jsf.hints.JsfHintsContext;
import org.netbeans.modules.web.jsf.hints.JsfHintsUtils;
import org.netbeans.modules.web.jsf.hints.rules.Bundle;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class JakartaFacesBeanIsGonnaBeDeprecated {
    private static final Logger LOG = Logger.getLogger(JakartaFacesBeanIsGonnaBeDeprecated.class.getName());
    private static final String JAKARTA_FACES_BEAN = "jakarta.faces.bean";
    private static final String MANAGED_BEAN = "jakarta.faces.bean.ManagedBean";
    private static final Map<String, String> DEPRECATED_TO_FIX = new HashMap<String, String>();

    public static Collection<ErrorDescription> run(HintContext hintContext) {
        ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
        JsfHintsContext ctx = JsfHintsUtils.getOrCacheContext(hintContext);
        if (ctx.getJsfVersion() == null || !ctx.getJsfVersion().isAtLeast(JsfVersion.JSF_2_2)) {
            return problems;
        }
        CompilationInfo info = hintContext.getInfo();
        for (TypeElement typeElement : info.getTopLevelElements()) {
            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().startsWith(JAKARTA_FACES_BEAN)) continue;
                Tree tree = info.getTrees().getTree(typeElement, annotationMirror);
                List<Fix> fixes = JakartaFacesBeanIsGonnaBeDeprecated.getFixesForType(info, typeElement, annotationMirror);
                problems.add(JsfHintsUtils.createProblem(tree, info, Bundle.JakartaFacesBeanIsGonnaBeDeprecated_display_name(), Severity.HINT, fixes));
            }
        }
        return problems;
    }

    private static List<Fix> getFixesForType(CompilationInfo info, TypeElement typeElement, AnnotationMirror am) {
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        String annotationType = am.getAnnotationType().toString();
        if (DEPRECATED_TO_FIX.containsKey(annotationType)) {
            TreePath path = info.getTrees().getPath(typeElement, am);
            fixes.add(new ChangeClassFix(info, path, typeElement, am, annotationType, DEPRECATED_TO_FIX.get(annotationType)).toEditorFix());
        }
        return fixes;
    }

    static {
        DEPRECATED_TO_FIX.put("jakarta.faces.bean.RequestScoped", "jakarta.enterprise.context.RequestScoped");
        DEPRECATED_TO_FIX.put("jakarta.faces.bean.SessionScoped", "jakarta.enterprise.context.SessionScoped");
        DEPRECATED_TO_FIX.put("jakarta.faces.bean.ApplicationScoped", "jakarta.enterprise.context.ApplicationScoped");
        DEPRECATED_TO_FIX.put("jakarta.faces.bean.ViewScoped", "jakarta.faces.view.ViewScoped");
        DEPRECATED_TO_FIX.put(MANAGED_BEAN, "jakarta.inject.Named");
    }

    private static final class ChangeClassFix
    extends JavaFix {
        private final TypeElement element;
        private final AnnotationMirror annotation;
        private final String deprecatedClass;
        private final String replacingClass;

        public ChangeClassFix(CompilationInfo info, TreePath path, TypeElement element, AnnotationMirror annotation, String deprecatedClass, String replacingClass) {
            super(info, path);
            this.element = element;
            this.annotation = annotation;
            this.deprecatedClass = deprecatedClass;
            this.replacingClass = replacingClass;
        }

        public String getText() {
            return Bundle.JakartaChangeClassFix_lbl_change_class_fix(this.deprecatedClass, this.replacingClass);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreeMaker make = wc.getTreeMaker();
            if (JakartaFacesBeanIsGonnaBeDeprecated.MANAGED_BEAN.equals(this.annotation.getAnnotationType().toString())) {
                ModifiersTree modifiers = wc.getTrees().getTree(this.element).getModifiers();
                AnnotationTree annotationTree = (AnnotationTree)wc.getTrees().getTree(this.element, this.annotation);
                ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
                for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                    AssignmentTree at;
                    String varName;
                    if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT || !(varName = ((IdentifierTree)(at = (AssignmentTree)expressionTree).getVariable()).getName().toString()).equals("name")) continue;
                    IdentifierTree valueTree = make.Identifier((CharSequence)at.getExpression().toString());
                    arguments.add(valueTree);
                }
                ModifiersTree modifiersTree = make.removeModifiersAnnotation(modifiers, (AnnotationTree)wc.getTrees().getTree(this.element, this.annotation));
                AnnotationTree annotationTree2 = GenerationUtils.newInstance((WorkingCopy)wc).createAnnotation(this.replacingClass, arguments);
                ModifiersTree modifiersTree2 = make.addModifiersAnnotation(modifiersTree, annotationTree2);
                wc.rewrite((Tree)modifiers, (Tree)modifiersTree2);
            }
            List<? extends ImportTree> imports = wc.getCompilationUnit().getImports();
            ImportTree newImportTree = make.Import((Tree)make.QualIdent(this.replacingClass), false);
            for (ImportTree importTree : imports) {
                if (!this.deprecatedClass.equals(importTree.getQualifiedIdentifier().toString())) continue;
                wc.rewrite((Tree)importTree, (Tree)newImportTree);
            }
        }
    }
}

