/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2OptionalFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class AntDeploymentProviderImpl
implements AntDeploymentProvider {
    private static String PROPERTIES_PATH = "/GlassFishEE6/Properties";
    private final File propFile;
    private final Properties props;

    private static File getPropertiesDir() {
        FileObject dir = FileUtil.getConfigFile((String)PROPERTIES_PATH);
        if (dir == null) {
            try {
                dir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)PROPERTIES_PATH);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
        }
        return FileUtil.toFile((FileObject)dir);
    }

    AntDeploymentProviderImpl(Hk2DeploymentManager dm, Hk2OptionalFactory aThis) {
        GlassfishModule commonSupport = dm.getCommonServerSupport();
        this.propFile = this.computeFile(commonSupport);
        this.props = this.computeProps(commonSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeploymentScript(OutputStream os, Object moduleType) throws IOException {
        try (InputStream is = AntDeploymentProviderImpl.class.getResourceAsStream("ant-deploy.xml");){
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDeploymentPropertiesFile() {
        if (!this.propFile.exists()) {
            try {
                FileObject fo = FileUtil.createData((File)this.propFile);
                FileLock lock = null;
                try {
                    lock = fo.lock();
                    OutputStream os = fo.getOutputStream(lock);
                    try {
                        this.props.store(os, "");
                    }
                    finally {
                        if (null != os) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (null != lock) {
                        lock.releaseLock();
                    }
                }
            }
            catch (IOException ioe) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, null, ioe);
            }
        }
        return this.propFile;
    }

    private File computeFile(GlassfishModule commonSupport) {
        String url = (String)commonSupport.getInstanceProperties().get("url");
        String domainDir = (String)commonSupport.getInstanceProperties().get("domainsfolder");
        String domain = (String)commonSupport.getInstanceProperties().get("domainname");
        String user = (String)commonSupport.getInstanceProperties().get("username");
        String name = "gfv3" + (url + domainDir + domain + user).hashCode();
        return new File(AntDeploymentProviderImpl.getPropertiesDir(), name + ".properties");
    }

    private Properties computeProps(GlassfishModule commonSupport) {
        Properties retVal = new Properties();
        retVal.setProperty("gfv3.root", (String)commonSupport.getInstanceProperties().get("homefolder"));
        String webUrl = "http://" + (String)commonSupport.getInstanceProperties().get("host") + ":" + (String)commonSupport.getInstanceProperties().get("httpportnumber");
        retVal.setProperty("gfv3.url", webUrl);
        webUrl = "http://" + (String)commonSupport.getInstanceProperties().get("host") + ":" + (String)commonSupport.getInstanceProperties().get("adminPort");
        retVal.setProperty("gfv3.admin.url", webUrl);
        retVal.setProperty("gfv3.username", (String)commonSupport.getInstanceProperties().get("username"));
        retVal.setProperty("gfv3.host", (String)commonSupport.getInstanceProperties().get("host"));
        retVal.setProperty("gfv3.port", (String)commonSupport.getInstanceProperties().get("adminPort"));
        return retVal;
    }
}

