/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class Hk2Logger {
    private static final int delay = 1000;
    private static Map<String, Hk2Logger> instances = new HashMap<String, Hk2Logger>();
    private InputOutput io;

    private Hk2Logger(String uri) {
        this.io = UISupport.getServerIO((String)uri);
        if (this.io == null) {
            return;
        }
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.io.select();
    }

    public static Hk2Logger getInstance(String uri) {
        if (!instances.containsKey(uri)) {
            instances.put(uri, new Hk2Logger(uri));
        }
        return instances.get(uri);
    }

    public void readInputStreams(InputStream[] inputStreams) {
        for (InputStream inputStream : inputStreams) {
            RequestProcessor.getDefault().post((Runnable)new LoggerRunnable(inputStream));
        }
    }

    public void readFiles(File[] files) {
        for (InputStream inputStream : Hk2Logger.getInputStreamsFromFiles(files)) {
            RequestProcessor.getDefault().post((Runnable)new LoggerRunnable(inputStream));
        }
    }

    public synchronized void write(String s) {
        this.io.getOut().print(s);
    }

    public synchronized void selectIO() {
        this.io.select();
    }

    private static InputStream[] getInputStreamsFromFiles(File[] files) {
        InputStream[] inputStreams = new InputStream[files.length];
        int i = 0;
        try {
            for (i = 0; i < files.length; ++i) {
                inputStreams[i] = new FileInputStream(files[i]);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, files[i].getAbsolutePath(), ex);
            return new InputStream[0];
        }
        return inputStreams;
    }

    private class LoggerRunnable
    implements Runnable {
        private InputStream inputStream;

        public LoggerRunnable(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    InputStreamReader reader = new InputStreamReader(this.inputStream);
                    char[] chars = new char[1024];
                    while (true) {
                        if (reader.ready()) {
                            Hk2Logger.this.write(new String(chars, 0, reader.read(chars)));
                            Hk2Logger.this.selectIO();
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e2) {
                        ErrorManager.getDefault().notify(4096, (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
                throw throwable;
            }
        }
    }
}

