/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.ApiAccessor;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class EditList {
    private static final Logger LOG = Logger.getLogger(EditList.class.getName());
    private Document doc;
    private List<Edit> edits;
    private boolean formatAll;
    private List<DelegatedPosition> positions = new ArrayList<DelegatedPosition>();

    public EditList(BaseDocument doc) {
        this.doc = doc;
        this.edits = new ArrayList<Edit>();
    }

    public EditList(Document doc) {
        this.doc = doc;
        this.edits = new ArrayList<Edit>();
    }

    public String toString() {
        return "EditList(" + String.valueOf(this.edits) + ")";
    }

    public Position createPosition(int offset) {
        return this.createPosition(offset, Position.Bias.Forward);
    }

    public Position createPosition(int offset, Position.Bias bias) {
        DelegatedPosition pos = new DelegatedPosition(offset, bias);
        this.positions.add(pos);
        return pos;
    }

    public EditList replace(int offset, int removeLen, String insertText, boolean format, int offsetOrdinal) {
        this.edits.add(new Edit(offset, removeLen, insertText, format, offsetOrdinal));
        return this;
    }

    @Deprecated
    public void applyToDocument(BaseDocument otherDoc) {
        this.applyTo((Document)otherDoc);
    }

    public void applyTo(Document otherDoc) {
        EditList newList = new EditList(otherDoc);
        newList.formatAll = this.formatAll;
        newList.edits = this.edits;
        newList.apply();
    }

    public void setFormatAll(boolean formatAll) {
        this.formatAll = formatAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        if (this.edits.size() == 0) {
            return;
        }
        Collections.sort(this.edits);
        Collections.reverse(this.edits);
        Position[] lastPos = new Position[]{null};
        Reformat r = Reformat.get((Document)this.doc);
        r.lock();
        try {
            LineDocument ld = (LineDocument)LineDocumentUtils.asRequired((Document)this.doc, LineDocument.class);
            AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.doc, AtomicLockDocument.class);
            ald.runAtomic(() -> {
                int lastOffset;
                int firstOffset;
                Iterator<Edit> i$ = this.edits.iterator();
                while (i$.hasNext()) {
                    Edit edit;
                    Edit fEdit = edit = i$.next();
                    int[] fEnd = new int[]{-1};
                    try {
                        if (lastPos[0] == null) {
                            lastPos[0] = ld.createPosition(this.edits.get((int)0).offset, Position.Bias.Forward);
                        }
                        if (fEdit.removeLen > 0) {
                            this.doc.remove(fEdit.offset, fEdit.removeLen);
                            LOG.log(Level.FINE, "Remove text: <{0}, {1}>", new Object[]{fEdit.offset, fEdit.offset + fEdit.removeLen});
                        }
                        if (fEdit.getInsertText() != null) {
                            this.doc.insertString(fEdit.offset, fEdit.insertText, null);
                            LOG.log(Level.FINE, "Insert text: offset={0}, text=''{1}''\n", new Object[]{fEdit.offset, fEdit.insertText});
                            fEnd[0] = fEdit.offset + fEdit.insertText.length();
                            for (int i = 0; i < this.positions.size(); ++i) {
                                DelegatedPosition pos = this.positions.get(i);
                                int positionOffset = pos.originalOffset;
                                if (fEdit.getOffset() > positionOffset || fEnd[0] < positionOffset) continue;
                                pos.delegate = ld.createPosition(positionOffset, pos.bias);
                            }
                        }
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                    if (!edit.format || edit.offset > fEnd[0]) continue;
                    try {
                        r.reformat(fEdit.offset, fEnd[0]);
                        LOG.log(Level.FINE, "Formatting: <{0}, {1}>", new Object[]{fEdit.offset, fEnd[0]});
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
                if (this.formatAll && (firstOffset = this.edits.get((int)(this.edits.size() - 1)).offset) <= (lastOffset = lastPos[0].getOffset())) {
                    try {
                        r.reformat(firstOffset, lastOffset);
                        LOG.log(Level.FINE, "Formatting all: <{0}, {1}>", new Object[]{firstOffset, lastOffset});
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
            });
        }
        finally {
            r.unlock();
        }
    }

    public OffsetRange getRange() {
        int minOffset;
        int maxOffset = minOffset = this.edits.get((int)0).offset;
        for (Edit edit : this.edits) {
            if (edit.offset < minOffset) {
                minOffset = edit.offset;
            }
            if (edit.offset <= maxOffset) continue;
            maxOffset = edit.offset;
        }
        return new OffsetRange(minOffset, maxOffset);
    }

    @Deprecated
    public int firstLine(BaseDocument doc) {
        return this.firstEditLine((Document)doc);
    }

    public int firstEditLine(Document doc) {
        OffsetRange range = this.getRange();
        if (doc instanceof StyledDocument) {
            return NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)range.getStart());
        }
        LineDocument ld = (LineDocument)LineDocumentUtils.asRequired((Document)doc, LineDocument.class);
        try {
            return LineDocumentUtils.getLineIndex((LineDocument)ld, (int)range.getStart());
        }
        catch (BadLocationException ex) {
            return 0;
        }
    }

    static {
        ApiAccessor.setInstance(new ApiAccessor(){

            @Override
            public List<Edit> getEdits(@NonNull EditList editList) {
                return Collections.unmodifiableList(editList.edits);
            }
        });
    }

    private class DelegatedPosition
    implements Position {
        private int originalOffset;
        private Position delegate;
        private Position.Bias bias;

        private DelegatedPosition(int offset, Position.Bias bias) {
            this.originalOffset = offset;
            this.bias = bias;
        }

        @Override
        public int getOffset() {
            if (this.delegate != null) {
                return this.delegate.getOffset();
            }
            return -1;
        }
    }

    public static final class Edit
    implements Comparable<Edit> {
        int offset;
        int removeLen;
        String insertText;
        boolean format;
        int offsetOrdinal;

        private Edit(int offset, int removeLen, String insertText, boolean format) {
            this.offset = offset;
            this.removeLen = removeLen;
            this.insertText = insertText;
            this.format = format;
        }

        private Edit(int offset, int removeLen, String insertText, boolean format, int offsetOrdinal) {
            this(offset, removeLen, insertText, format);
            this.offsetOrdinal = offsetOrdinal;
        }

        @Override
        public int compareTo(Edit other) {
            if (this.offset == other.offset) {
                return other.offsetOrdinal - this.offsetOrdinal;
            }
            return this.offset - other.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getRemoveLen() {
            return this.removeLen;
        }

        public String getInsertText() {
            return this.insertText;
        }

        public String toString() {
            return "Edit(pos=" + this.offset + ",delete=" + this.removeLen + ",insert=" + this.insertText + ")";
        }
    }
}

