/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.awt.Image;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RefreshAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RestartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StopAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class UISupport {
    private static final WeakHashMap ioWeakMap = new WeakHashMap();

    private UISupport() {
    }

    public static Image getIcon(ServerIcon serverIcon) {
        switch (serverIcon.ordinal()) {
            case 0: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ejb.png");
            }
            case 1: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/war.png");
            }
            case 2: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ear.png");
            }
        }
        return UISupport.computeIcon(serverIcon);
    }

    private static Image computeIcon(ServerIcon serverIcon) {
        Image badge;
        Node folderNode = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        Image folder = serverIcon == ServerIcon.EJB_OPENED_FOLDER || serverIcon == ServerIcon.WAR_OPENED_FOLDER || serverIcon == ServerIcon.EAR_OPENED_FOLDER ? folderNode.getOpenedIcon(1) : folderNode.getIcon(1);
        if (serverIcon == ServerIcon.EJB_FOLDER || serverIcon == ServerIcon.EJB_OPENED_FOLDER) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/ejbBadge.png");
        } else if (serverIcon == ServerIcon.WAR_FOLDER || serverIcon == ServerIcon.WAR_OPENED_FOLDER) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/warBadge.png");
        } else if (serverIcon == ServerIcon.EAR_FOLDER || serverIcon == ServerIcon.EAR_OPENED_FOLDER) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/deployment/impl/ui/resources/earBadge.png");
        } else {
            return null;
        }
        return ImageUtilities.mergeImages((Image)folder, (Image)badge, (int)7, (int)7);
    }

    public static InputOutput getServerIO(String url) {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(url);
        if (si == null) {
            return null;
        }
        InputOutput io = (InputOutput)ioWeakMap.get(si);
        if (io != null) {
            return io;
        }
        if (si.getDisplayName() == null) {
            Logger.getLogger(UISupport.class.getName()).log(Level.INFO, "Server without display name requested IO tab: {0}", si);
            return null;
        }
        Action[] actions = new Action[]{new StartAction.OutputAction(si), new DebugAction.OutputAction(si), new RestartAction.OutputAction(si), new StopAction.OutputAction(si), new RefreshAction.OutputAction(si)};
        InputOutput newIO = IOProvider.getDefault().getIO(si.getDisplayName(), actions);
        ioWeakMap.put(si, newIO);
        return newIO;
    }

    public static enum ServerIcon {
        EJB_ARCHIVE,
        WAR_ARCHIVE,
        EAR_ARCHIVE,
        EJB_FOLDER,
        EAR_FOLDER,
        WAR_FOLDER,
        EJB_OPENED_FOLDER,
        EAR_OPENED_FOLDER,
        WAR_OPENED_FOLDER;

    }
}

