/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SettingsRecognizer
extends DefaultHandler {
    public static final String INSTANCE_DTD_ID = "-//NetBeans//DTD Session settings 1.0//EN";
    static final ErrorManager err = ErrorManager.getDefault().getInstance(SettingsRecognizer.class.getName());
    private static final String ELM_SETTING = "settings";
    private static final String ATR_SETTING_VERSION = "version";
    private static final String ELM_MODULE = "module";
    private static final String ATR_MODULE_NAME = "name";
    private static final String ATR_MODULE_SPEC = "spec";
    private static final String ATR_MODULE_IMPL = "impl";
    private static final String ELM_INSTANCE = "instance";
    private static final String ATR_INSTANCE_CLASS = "class";
    private static final String ATR_INSTANCE_METHOD = "method";
    private static final String ELM_INSTANCEOF = "instanceof";
    private static final String ATR_INSTANCEOF_CLASS = "class";
    private static final String ELM_SERIALDATA = "serialdata";
    private static final String ATR_SERIALDATA_CLASS = "class";
    private boolean header;
    private Deque<String> stack;
    private String version;
    private String instanceClass;
    private String instanceMethod;
    private Set<String> instanceOf = new HashSet<String>();
    private byte[] serialdata;
    private CharArrayWriter chaos = null;
    private String codeName;
    private String codeNameBase;
    private int codeNameRelease;
    private String moduleImpl;
    private final FileObject source;
    private static final byte[] MODULE_SETTINGS_INTRO = "<?xml version=\"1.0\"?> <!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\"> <settings version=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_INTRO_END = "> <".getBytes();
    private static final byte[] MODULE_SETTINGS_MODULE_NAME = "odule name=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_MODULE_SPEC = "spec=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_MODULE_IMPL = "impl=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_TAG_END = "> <".getBytes();
    private static final byte[] MODULE_SETTINGS_INSTANCE = "nstance".getBytes();
    private static final byte[] MODULE_SETTINGS_INSTANCE_CLZ = "class=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_INSTANCE_MTD = "method=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_OF = "f class=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_SERIAL = "erialdata class=\"".getBytes();
    private static final byte[] MODULE_SETTINGS_END = "settings>".getBytes();

    public SettingsRecognizer(boolean header, FileObject source) {
        this.header = header;
        this.source = source;
    }

    public boolean isAllRead() {
        return !this.header;
    }

    public void setAllRead(boolean all) {
        if (!this.header) {
            return;
        }
        this.header = all;
    }

    public String getSettingsVerison() {
        return this.version;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public String getModuleImpl() {
        return this.moduleImpl;
    }

    public Set getInstanceOf() {
        return this.instanceOf;
    }

    public String getMethodName() {
        return this.instanceMethod;
    }

    public InputStream getSerializedInstance() {
        if (this.serialdata == null) {
            return null;
        }
        return new ByteArrayInputStream(this.serialdata);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (INSTANCE_DTD_ID.equals(publicId)) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    @Override
    public void characters(char[] values, int start, int length) throws SAXException {
        if (this.header) {
            return;
        }
        String element = this.stack.peek();
        if (ELM_SERIALDATA.equals(element)) {
            if (this.chaos == null) {
                this.chaos = new CharArrayWriter(length);
            }
            this.chaos.write(values, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        this.stack.push(qName);
        if (ELM_SETTING.equals(qName)) {
            this.version = attribs.getValue(ATR_SETTING_VERSION);
        } else if (ELM_MODULE.equals(qName)) {
            this.codeName = attribs.getValue(ATR_MODULE_NAME);
            this.resolveModuleElm(this.codeName);
            this.moduleImpl = attribs.getValue(ATR_MODULE_IMPL);
            try {
                String string = attribs.getValue(ATR_MODULE_SPEC);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
        } else if (ELM_INSTANCEOF.equals(qName)) {
            this.instanceOf.add(Utilities.translate((String)attribs.getValue("class")));
        } else if (ELM_INSTANCE.equals(qName)) {
            this.instanceClass = attribs.getValue("class");
            if (this.instanceClass == null) {
                System.err.println("Hint: NPE is caused by broken settings file: " + String.valueOf(this.source));
            }
            this.instanceClass = Utilities.translate((String)this.instanceClass);
            this.instanceMethod = attribs.getValue(ATR_INSTANCE_METHOD);
        } else if (ELM_SERIALDATA.equals(qName)) {
            this.instanceClass = attribs.getValue("class");
            this.instanceClass = Utilities.translate((String)this.instanceClass);
            if (this.header) {
                throw new StopSAXException();
            }
        }
    }

    private void resolveModuleElm(String codeName) {
        if (codeName != null) {
            int slash = codeName.indexOf("/");
            if (slash == -1) {
                this.codeNameBase = codeName;
                this.codeNameRelease = -1;
            } else {
                this.codeNameBase = codeName.substring(0, slash);
                try {
                    this.codeNameRelease = Integer.parseInt(codeName.substring(slash + 1));
                }
                catch (NumberFormatException ex) {
                    ErrorManager emgr = ErrorManager.getDefault();
                    emgr.annotate((Throwable)ex, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                    emgr.annotate((Throwable)ex, "Source: " + String.valueOf(this.source));
                    emgr.notify(1, (Throwable)ex);
                    this.codeNameRelease = -1;
                }
            }
        } else {
            this.codeNameBase = null;
            this.codeNameRelease = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String element = this.stack.pop();
        if (ELM_SERIALDATA.equals(element) && this.chaos != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.chaos.size() >> 1);
            try {
                this.chars2Bytes(baos, this.chaos.toCharArray(), 0, this.chaos.size());
                this.serialdata = baos.toByteArray();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
            }
            finally {
                this.chaos = null;
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Object readSerial(InputStream is) throws IOException, ClassNotFoundException {
        Object object;
        if (is == null) {
            return null;
        }
        ObjectInputStream oi = new ObjectInputStream(is);
        try {
            Object o;
            object = o = oi.readObject();
        }
        catch (Throwable o) {
            try {
                try {
                    oi.close();
                }
                catch (Throwable throwable) {
                    o.addSuppressed(throwable);
                }
                throw o;
            }
            catch (IOException ex) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ex, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                emgr.annotate((Throwable)ex, "Source: " + String.valueOf(this.source));
                emgr.annotate((Throwable)ex, "Cannot read class: " + this.instanceClass);
                throw ex;
            }
            catch (ClassNotFoundException ex) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ex, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                emgr.annotate((Throwable)ex, "Source: " + String.valueOf(this.source));
                throw ex;
            }
        }
        oi.close();
        return object;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object inst = null;
        inst = this.readSerial(this.getSerializedInstance());
        if (inst == null) {
            if (this.instanceMethod != null) {
                inst = this.createFromMethod(this.instanceClass, this.instanceMethod);
            } else {
                Class clazz = this.instanceClass();
                if (SharedClassObject.class.isAssignableFrom(clazz)) {
                    inst = SharedClassObject.findObject(clazz.asSubclass(SharedClassObject.class), (boolean)false);
                    if (null != inst) {
                        try {
                            Method method = SharedClassObject.class.getDeclaredMethod("reset", new Class[0]);
                            method.setAccessible(true);
                            method.invoke(inst, new Object[0]);
                        }
                        catch (Exception e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    } else {
                        inst = SharedClassObject.findObject(clazz.asSubclass(SharedClassObject.class), (boolean)true);
                    }
                } else {
                    try {
                        inst = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception ex) {
                        IOException ioe = new IOException();
                        ErrorManager emgr = ErrorManager.getDefault();
                        emgr.annotate((Throwable)ioe, (Throwable)ex);
                        emgr.annotate((Throwable)ioe, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        emgr.annotate((Throwable)ioe, "Class: " + String.valueOf(clazz));
                        emgr.annotate((Throwable)ioe, "Source: " + String.valueOf(this.source));
                        throw ioe;
                    }
                }
            }
        }
        return inst;
    }

    private static String getFileContent(FileObject fo) {
        try {
            int length;
            InputStreamReader isr = new InputStreamReader(fo.getInputStream());
            char[] cbuf = new char[1024];
            StringBuilder sbuf = new StringBuilder(1024);
            while ((length = isr.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, length);
            }
            return sbuf.toString();
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }

    private Object createFromMethod(String srcClazz, String srcMethod) throws ClassNotFoundException, IOException {
        String targetMethod;
        String targetClass;
        int dotIndex = this.instanceMethod.lastIndexOf(46);
        if (dotIndex > 0) {
            targetClass = srcMethod.substring(0, dotIndex);
            targetMethod = srcMethod.substring(dotIndex + 1);
        } else {
            targetClass = srcClazz;
            targetMethod = srcMethod;
        }
        Class clazz = this.loadClass(targetClass);
        try {
            Object instance;
            try {
                Method method = clazz.getMethod(targetMethod, FileObject.class);
                method.setAccessible(true);
                instance = method.invoke(null, this.source);
            }
            catch (NoSuchMethodException ex) {
                Method method = clazz.getMethod(targetMethod, new Class[0]);
                method.setAccessible(true);
                instance = method.invoke(null, new Object[0]);
            }
            if (instance == null) {
                throw new IOException("Null return not permitted from " + targetClass + "." + targetMethod);
            }
            return instance;
        }
        catch (Exception ex) {
            IOException ioe = new IOException("Error reading " + String.valueOf(this.source) + ": " + String.valueOf(ex));
            ErrorManager emgr = ErrorManager.getDefault();
            emgr.annotate((Throwable)ioe, "Class: " + String.valueOf(clazz));
            emgr.annotate((Throwable)ioe, "Method: " + srcMethod);
            emgr.annotate((Throwable)ioe, (Throwable)ex);
            emgr.annotate((Throwable)ioe, "Content:\n" + SettingsRecognizer.getFileContent(this.source));
            throw ioe;
        }
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        if (this.instanceClass == null) {
            throw new ClassNotFoundException(String.valueOf(this.source) + ": missing 'class' attribute in 'instance' element");
        }
        return this.loadClass(this.instanceClass);
    }

    private Class loadClass(String clazz) throws ClassNotFoundException {
        return ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(clazz);
    }

    public String instanceName() {
        if (this.instanceClass == null) {
            return "";
        }
        return this.instanceClass;
    }

    private int tr(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private void chars2Bytes(OutputStream os, char[] chars, int off, int length) throws IOException {
        int i = off;
        block0: while (i < length) {
            int read;
            if ((read = this.tr(chars[i++])) < 0) continue;
            byte rbyte = (byte)(read << 4);
            while (i < length) {
                if ((read = this.tr(chars[i++])) < 0) continue;
                rbyte = (byte)(rbyte + (byte)read);
                os.write(rbyte);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        InputStream in;
        block29: {
            in = null;
            try {
                if (!this.header) break block29;
                if (err.isLoggable(1) && this.source.getSize() < 12000L) {
                    byte[] arr = new byte[(int)this.source.getSize()];
                    try (InputStream temp = this.source.getInputStream();){
                        int len = temp.read(arr);
                        if (len != arr.length) {
                            throw new IOException("Could not read " + arr.length + " bytes from " + String.valueOf(this.source) + " just " + len);
                        }
                        err.log("Parsing:" + new String(arr));
                    }
                    in = new ByteArrayInputStream(arr);
                } else {
                    in = new BufferedInputStream(this.source.getInputStream());
                }
                Set<String> iofs = this.quickParse(new BufferedInputStream(in));
                if (iofs != null) {
                    this.instanceOf = iofs;
                    return;
                }
            }
            catch (IOException iofs) {
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        this.stack = new ArrayDeque<String>();
        try {
            in = this.source.getInputStream();
            XMLReader reader = XMLUtil.createXMLReader();
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            reader.setEntityResolver(this);
            reader.parse(new InputSource(new BufferedInputStream(in)));
        }
        catch (StopSAXException reader) {
        }
        catch (SAXException ex) {
            IOException ioe = new IOException(this.source.toString());
            ErrorManager emgr = ErrorManager.getDefault();
            emgr.annotate((Throwable)ioe, (Throwable)ex);
            if (ex.getException() != null) {
                emgr.annotate((Throwable)ioe, (Throwable)ex.getException());
            }
            emgr.annotate((Throwable)ioe, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
            emgr.annotate((Throwable)ioe, "Source: " + String.valueOf(this.source));
            throw ioe;
        }
        finally {
            this.stack = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(Reader source) throws IOException {
        this.stack = new ArrayDeque<String>();
        try {
            XMLReader reader = XMLUtil.createXMLReader();
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            reader.setEntityResolver(this);
            reader.parse(new InputSource(source));
        }
        catch (StopSAXException reader) {
        }
        catch (SAXException ex) {
            IOException ioe = new IOException(source.toString());
            ErrorManager emgr = ErrorManager.getDefault();
            emgr.annotate((Throwable)ioe, (Throwable)ex);
            if (ex.getException() != null) {
                emgr.annotate((Throwable)ioe, (Throwable)ex.getException());
            }
            throw ioe;
        }
        finally {
            this.stack = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Set<String> quickParse(InputStream is) throws IOException {
        iofs = new HashSet<String>();
        if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_INTRO)) {
            SettingsRecognizer.err.log("Could not read intro " + String.valueOf(this.source));
            return null;
        }
        this.version = this.readTo(is, '\"');
        if (this.version == null) {
            SettingsRecognizer.err.log("Could not read version " + String.valueOf(this.source));
            return null;
        }
        if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_INTRO_END)) {
            SettingsRecognizer.err.log("Could not read stuff after cnb " + String.valueOf(this.source));
            return null;
        }
        block6: while (true) lbl-1000:
        // 7 sources

        {
            c = is.read();
            switch (c) {
                case 109: {
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_MODULE_NAME)) {
                        SettingsRecognizer.err.log("Could not read up to <module name=\" " + String.valueOf(this.source));
                        return null;
                    }
                    codeName = this.readTo(is, '\"');
                    if (codeName == null) {
                        SettingsRecognizer.err.log("Could not read module name value " + String.valueOf(this.source));
                        return null;
                    }
                    codeName = codeName.intern();
                    this.resolveModuleElm(codeName);
                    c = is.read();
                    if (c != 47) ** GOTO lbl30
                    if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to end of module tag " + String.valueOf(this.source));
                    return null;
lbl30:
                    // 1 sources

                    if (c != 32) {
                        SettingsRecognizer.err.log("Could not space after module name " + String.valueOf(this.source));
                        return null;
                    }
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_MODULE_SPEC)) {
                        SettingsRecognizer.err.log("Could not read up to spec=\" " + String.valueOf(this.source));
                        return null;
                    }
                    mspec = this.readTo(is, '\"');
                    if (mspec == null) {
                        SettingsRecognizer.err.log("Could not read module spec value " + String.valueOf(this.source));
                        return null;
                    }
                    c = is.read();
                    if (c != 47) ** GOTO lbl45
                    if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to end of <module name spec/> tag " + String.valueOf(this.source));
                    return null;
lbl45:
                    // 1 sources

                    if (c != 32) {
                        SettingsRecognizer.err.log("Could not read space after module name " + String.valueOf(this.source));
                        return null;
                    }
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_MODULE_IMPL)) {
                        SettingsRecognizer.err.log("Could not read up to impl=\" " + String.valueOf(this.source));
                        return null;
                    }
                    this.moduleImpl = this.readTo(is, '\"');
                    if (this.moduleImpl == null) {
                        SettingsRecognizer.err.log("Could not read module impl value " + String.valueOf(this.source));
                        return null;
                    }
                    this.moduleImpl = this.moduleImpl.intern();
                    if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to /> < " + String.valueOf(this.source));
                    return null;
                }
                case 105: {
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_INSTANCE)) {
                        SettingsRecognizer.err.log("Could not read up to instance " + String.valueOf(this.source));
                        return null;
                    }
                    c = is.read();
                    if (c != 111) ** GOTO lbl81
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_OF)) {
                        SettingsRecognizer.err.log("Could not read up to instance");
                        return null;
                    }
                    iof = this.readTo(is, '\"');
                    if (iof == null) {
                        SettingsRecognizer.err.log("Could not read instanceof value " + String.valueOf(this.source));
                        return null;
                    }
                    iof = Utilities.translate((String)iof).intern();
                    iofs.add(iof);
                    if (is.read() != 47) {
                        SettingsRecognizer.err.log("No / at end of <instanceof> " + iof + " " + String.valueOf(this.source));
                        return null;
                    }
                    if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to next tag after <instanceof> " + iof + " " + String.valueOf(this.source));
                    return null;
lbl81:
                    // 1 sources

                    if (c != 32) ** GOTO lbl113
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_INSTANCE_CLZ)) {
                        SettingsRecognizer.err.log("Could not read up to class=\" " + String.valueOf(this.source));
                        return null;
                    }
                    this.instanceClass = this.readTo(is, '\"');
                    if (this.instanceClass == null) {
                        SettingsRecognizer.err.log("Could not read instance class value " + String.valueOf(this.source));
                        return null;
                    }
                    this.instanceClass = Utilities.translate((String)this.instanceClass).intern();
                    c = is.read();
                    if (c != 47) ** GOTO lbl95
                    if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) ** GOTO lbl-1000
                    SettingsRecognizer.err.log("Could not read up to end of instance tag " + String.valueOf(this.source));
                    return null;
lbl95:
                    // 1 sources

                    if (c != 32) {
                        SettingsRecognizer.err.log("Could not space after instance class " + String.valueOf(this.source));
                        return null;
                    }
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_INSTANCE_MTD)) {
                        SettingsRecognizer.err.log("Could not read up to method=\" " + String.valueOf(this.source));
                        return null;
                    }
                    this.instanceMethod = this.readTo(is, '\"');
                    if (this.instanceMethod == null) {
                        SettingsRecognizer.err.log("Could not read method value " + String.valueOf(this.source));
                        return null;
                    }
                    this.instanceMethod = this.instanceMethod.intern();
                    c = is.read();
                    if (c == 47) {
                        if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_TAG_END)) continue block6;
                        SettingsRecognizer.err.log("Could not read up to end of instance tag " + String.valueOf(this.source));
                        return null;
                    }
                    SettingsRecognizer.err.log("Strange stuff after method attribute " + String.valueOf(this.source));
                    return null;
lbl113:
                    // 1 sources

                    SettingsRecognizer.err.log("Could not read after to instance " + String.valueOf(this.source));
                    return null;
                }
                case 115: {
                    if (!this.expect(is, SettingsRecognizer.MODULE_SETTINGS_SERIAL)) {
                        SettingsRecognizer.err.log("Could not read up to <serialdata class=\" " + String.valueOf(this.source));
                        return null;
                    }
                    this.instanceClass = this.readTo(is, '\"');
                    if (this.instanceClass == null) {
                        SettingsRecognizer.err.log("Could not read serialdata class value " + String.valueOf(this.source));
                        return null;
                    }
                    this.instanceClass = Utilities.translate((String)this.instanceClass).intern();
                    c = is.read();
                    if (c == 62) break block6;
                    SettingsRecognizer.err.log("Could not read up to end of serialdata tag " + String.valueOf(this.source));
                    return null;
                }
                case 47: {
                    if (this.expect(is, SettingsRecognizer.MODULE_SETTINGS_END)) break block6;
                    SettingsRecognizer.err.log("Could not read up to end of settings tag " + String.valueOf(this.source));
                    return null;
                }
                default: {
                    SettingsRecognizer.err.log("Strange stuff after <" + (char)c + " " + String.valueOf(this.source));
                    return null;
                }
            }
            break;
        }
        if (this.instanceClass != null && !iofs.isEmpty()) {
            return iofs;
        }
        return null;
    }

    private boolean expect(InputStream is, byte[] stuff) throws IOException {
        int len = stuff.length;
        boolean inWhitespace = false;
        int i = 0;
        while (i < len) {
            int c = is.read();
            if (c == 10 || c == 13 || c == 32 || c == 9) {
                if (inWhitespace) continue;
                inWhitespace = true;
                c = 32;
            } else {
                inWhitespace = false;
            }
            if (c == stuff[i++]) continue;
            return false;
        }
        if (stuff[len - 1] == 10) {
            if (!is.markSupported()) {
                throw new IOException("Mark not supported");
            }
            is.mark(1);
            int c = is.read();
            if (c != -1 && c != 10 && c != 13) {
                is.reset();
            }
        }
        return true;
    }

    private String readTo(InputStream is, char delim) throws IOException {
        if (delim == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter caw = new CharArrayWriter(100);
        boolean inNewline = false;
        int c;
        while ((c = is.read()) != -1) {
            if (c > 126) {
                return null;
            }
            if (c == 10 || c == 13) {
                if (inNewline) continue;
                inNewline = true;
                c = 10;
            } else {
                if (c < 32 && c != 9) {
                    return null;
                }
                inNewline = false;
            }
            if (c == delim) {
                return caw.toString();
            }
            caw.write(c);
        }
        return null;
    }

    static final class StopSAXException
    extends SAXException {
        public StopSAXException() {
            super("Parser stopped");
        }
    }
}

