/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.beans;

import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinition;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;

public final class FxEvent
extends FxDefinition {
    private String eventClassName;
    private ElementHandle<TypeElement> eventType;
    private boolean propertyChange;

    public String getEventClassName() {
        return this.eventClassName;
    }

    @CheckForNull
    public ElementHandle<TypeElement> getEventType() {
        return this.eventType;
    }

    FxEvent(String name) {
        super(name);
    }

    void setPropertyChange(boolean change) {
        this.propertyChange = change;
    }

    void setEventClassName(String eventClassName) {
        this.eventClassName = eventClassName;
    }

    void setEventType(ElementHandle<TypeElement> eventType) {
        this.eventType = eventType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event[");
        sb.append("name: ").append(this.getName()).append("; type: ").append(this.getEventType());
        sb.append("]");
        return sb.toString();
    }

    public boolean isPropertyChange() {
        return this.propertyChange;
    }

    public String getPropertyName() {
        if (!this.propertyChange) {
            return null;
        }
        String s = this.getName();
        return s.substring(0, s.length() - 6);
    }

    public String getSymbol() {
        String s = this.getName();
        return "on" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    @Override
    public FxDefinitionKind getKind() {
        return FxDefinitionKind.EVENT;
    }
}

