/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VolumeBackupSchedule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="backupType")
    private final BackupType backupType;
    @JsonProperty(value="offsetSeconds")
    private final Integer offsetSeconds;
    @JsonProperty(value="period")
    private final Period period;
    @JsonProperty(value="offsetType")
    private final OffsetType offsetType;
    @JsonProperty(value="hourOfDay")
    private final Integer hourOfDay;
    @JsonProperty(value="dayOfWeek")
    private final DayOfWeek dayOfWeek;
    @JsonProperty(value="dayOfMonth")
    private final Integer dayOfMonth;
    @JsonProperty(value="month")
    private final Month month;
    @JsonProperty(value="retentionSeconds")
    private final Integer retentionSeconds;
    @JsonProperty(value="timeZone")
    private final TimeZone timeZone;

    @Deprecated
    @ConstructorProperties(value={"backupType", "offsetSeconds", "period", "offsetType", "hourOfDay", "dayOfWeek", "dayOfMonth", "month", "retentionSeconds", "timeZone"})
    public VolumeBackupSchedule(BackupType backupType, Integer offsetSeconds, Period period, OffsetType offsetType, Integer hourOfDay, DayOfWeek dayOfWeek, Integer dayOfMonth, Month month, Integer retentionSeconds, TimeZone timeZone) {
        this.backupType = backupType;
        this.offsetSeconds = offsetSeconds;
        this.period = period;
        this.offsetType = offsetType;
        this.hourOfDay = hourOfDay;
        this.dayOfWeek = dayOfWeek;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.retentionSeconds = retentionSeconds;
        this.timeZone = timeZone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BackupType getBackupType() {
        return this.backupType;
    }

    public Integer getOffsetSeconds() {
        return this.offsetSeconds;
    }

    public Period getPeriod() {
        return this.period;
    }

    public OffsetType getOffsetType() {
        return this.offsetType;
    }

    public Integer getHourOfDay() {
        return this.hourOfDay;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Month getMonth() {
        return this.month;
    }

    public Integer getRetentionSeconds() {
        return this.retentionSeconds;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VolumeBackupSchedule(");
        sb.append("super=").append(super.toString());
        sb.append("backupType=").append(String.valueOf((Object)this.backupType));
        sb.append(", offsetSeconds=").append(String.valueOf(this.offsetSeconds));
        sb.append(", period=").append(String.valueOf((Object)this.period));
        sb.append(", offsetType=").append(String.valueOf((Object)this.offsetType));
        sb.append(", hourOfDay=").append(String.valueOf(this.hourOfDay));
        sb.append(", dayOfWeek=").append(String.valueOf((Object)this.dayOfWeek));
        sb.append(", dayOfMonth=").append(String.valueOf(this.dayOfMonth));
        sb.append(", month=").append(String.valueOf((Object)this.month));
        sb.append(", retentionSeconds=").append(String.valueOf(this.retentionSeconds));
        sb.append(", timeZone=").append(String.valueOf((Object)this.timeZone));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VolumeBackupSchedule)) {
            return false;
        }
        VolumeBackupSchedule other = (VolumeBackupSchedule)((Object)o);
        return Objects.equals((Object)this.backupType, (Object)other.backupType) && Objects.equals(this.offsetSeconds, other.offsetSeconds) && Objects.equals((Object)this.period, (Object)other.period) && Objects.equals((Object)this.offsetType, (Object)other.offsetType) && Objects.equals(this.hourOfDay, other.hourOfDay) && Objects.equals((Object)this.dayOfWeek, (Object)other.dayOfWeek) && Objects.equals(this.dayOfMonth, other.dayOfMonth) && Objects.equals((Object)this.month, (Object)other.month) && Objects.equals(this.retentionSeconds, other.retentionSeconds) && Objects.equals((Object)this.timeZone, (Object)other.timeZone) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.backupType == null ? 43 : this.backupType.hashCode());
        result = result * 59 + (this.offsetSeconds == null ? 43 : this.offsetSeconds.hashCode());
        result = result * 59 + (this.period == null ? 43 : this.period.hashCode());
        result = result * 59 + (this.offsetType == null ? 43 : this.offsetType.hashCode());
        result = result * 59 + (this.hourOfDay == null ? 43 : this.hourOfDay.hashCode());
        result = result * 59 + (this.dayOfWeek == null ? 43 : this.dayOfWeek.hashCode());
        result = result * 59 + (this.dayOfMonth == null ? 43 : this.dayOfMonth.hashCode());
        result = result * 59 + (this.month == null ? 43 : this.month.hashCode());
        result = result * 59 + (this.retentionSeconds == null ? 43 : this.retentionSeconds.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TimeZone implements BmcEnum
    {
        Utc("UTC"),
        RegionalDataCenterTime("REGIONAL_DATA_CENTER_TIME"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TimeZone> map;

        private TimeZone(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TimeZone create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TimeZone', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TimeZone.class);
            map = new HashMap<String, TimeZone>();
            for (TimeZone v : TimeZone.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Month implements BmcEnum
    {
        January("JANUARY"),
        February("FEBRUARY"),
        March("MARCH"),
        April("APRIL"),
        May("MAY"),
        June("JUNE"),
        July("JULY"),
        August("AUGUST"),
        September("SEPTEMBER"),
        October("OCTOBER"),
        November("NOVEMBER"),
        December("DECEMBER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Month> map;

        private Month(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Month create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Month', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Month.class);
            map = new HashMap<String, Month>();
            for (Month v : Month.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DayOfWeek implements BmcEnum
    {
        Monday("MONDAY"),
        Tuesday("TUESDAY"),
        Wednesday("WEDNESDAY"),
        Thursday("THURSDAY"),
        Friday("FRIDAY"),
        Saturday("SATURDAY"),
        Sunday("SUNDAY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DayOfWeek> map;

        private DayOfWeek(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DayOfWeek create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DayOfWeek', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DayOfWeek.class);
            map = new HashMap<String, DayOfWeek>();
            for (DayOfWeek v : DayOfWeek.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OffsetType implements BmcEnum
    {
        Structured("STRUCTURED"),
        NumericSeconds("NUMERIC_SECONDS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OffsetType> map;

        private OffsetType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OffsetType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OffsetType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OffsetType.class);
            map = new HashMap<String, OffsetType>();
            for (OffsetType v : OffsetType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Period implements BmcEnum
    {
        OneHour("ONE_HOUR"),
        OneDay("ONE_DAY"),
        OneWeek("ONE_WEEK"),
        OneMonth("ONE_MONTH"),
        OneYear("ONE_YEAR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Period> map;

        private Period(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Period create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Period', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Period.class);
            map = new HashMap<String, Period>();
            for (Period v : Period.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BackupType implements BmcEnum
    {
        Full("FULL"),
        Incremental("INCREMENTAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BackupType> map;

        private BackupType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BackupType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BackupType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BackupType.class);
            map = new HashMap<String, BackupType>();
            for (BackupType v : BackupType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="backupType")
        private BackupType backupType;
        @JsonProperty(value="offsetSeconds")
        private Integer offsetSeconds;
        @JsonProperty(value="period")
        private Period period;
        @JsonProperty(value="offsetType")
        private OffsetType offsetType;
        @JsonProperty(value="hourOfDay")
        private Integer hourOfDay;
        @JsonProperty(value="dayOfWeek")
        private DayOfWeek dayOfWeek;
        @JsonProperty(value="dayOfMonth")
        private Integer dayOfMonth;
        @JsonProperty(value="month")
        private Month month;
        @JsonProperty(value="retentionSeconds")
        private Integer retentionSeconds;
        @JsonProperty(value="timeZone")
        private TimeZone timeZone;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder backupType(BackupType backupType) {
            this.backupType = backupType;
            this.__explicitlySet__.add("backupType");
            return this;
        }

        public Builder offsetSeconds(Integer offsetSeconds) {
            this.offsetSeconds = offsetSeconds;
            this.__explicitlySet__.add("offsetSeconds");
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            this.__explicitlySet__.add("period");
            return this;
        }

        public Builder offsetType(OffsetType offsetType) {
            this.offsetType = offsetType;
            this.__explicitlySet__.add("offsetType");
            return this;
        }

        public Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            this.__explicitlySet__.add("hourOfDay");
            return this;
        }

        public Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.__explicitlySet__.add("dayOfWeek");
            return this;
        }

        public Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            this.__explicitlySet__.add("dayOfMonth");
            return this;
        }

        public Builder month(Month month) {
            this.month = month;
            this.__explicitlySet__.add("month");
            return this;
        }

        public Builder retentionSeconds(Integer retentionSeconds) {
            this.retentionSeconds = retentionSeconds;
            this.__explicitlySet__.add("retentionSeconds");
            return this;
        }

        public Builder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public VolumeBackupSchedule build() {
            VolumeBackupSchedule model = new VolumeBackupSchedule(this.backupType, this.offsetSeconds, this.period, this.offsetType, this.hourOfDay, this.dayOfWeek, this.dayOfMonth, this.month, this.retentionSeconds, this.timeZone);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VolumeBackupSchedule model) {
            if (model.wasPropertyExplicitlySet("backupType")) {
                this.backupType(model.getBackupType());
            }
            if (model.wasPropertyExplicitlySet("offsetSeconds")) {
                this.offsetSeconds(model.getOffsetSeconds());
            }
            if (model.wasPropertyExplicitlySet("period")) {
                this.period(model.getPeriod());
            }
            if (model.wasPropertyExplicitlySet("offsetType")) {
                this.offsetType(model.getOffsetType());
            }
            if (model.wasPropertyExplicitlySet("hourOfDay")) {
                this.hourOfDay(model.getHourOfDay());
            }
            if (model.wasPropertyExplicitlySet("dayOfWeek")) {
                this.dayOfWeek(model.getDayOfWeek());
            }
            if (model.wasPropertyExplicitlySet("dayOfMonth")) {
                this.dayOfMonth(model.getDayOfMonth());
            }
            if (model.wasPropertyExplicitlySet("month")) {
                this.month(model.getMonth());
            }
            if (model.wasPropertyExplicitlySet("retentionSeconds")) {
                this.retentionSeconds(model.getRetentionSeconds());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            return this;
        }
    }
}

