/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteVolumeGroupBackupRequest
extends BmcRequest<Void> {
    private String volumeGroupBackupId;
    private String ifMatch;

    public String getVolumeGroupBackupId() {
        return this.volumeGroupBackupId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().volumeGroupBackupId(this.volumeGroupBackupId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeGroupBackupId=").append(String.valueOf(this.volumeGroupBackupId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteVolumeGroupBackupRequest)) {
            return false;
        }
        DeleteVolumeGroupBackupRequest other = (DeleteVolumeGroupBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeGroupBackupId, other.volumeGroupBackupId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeGroupBackupId == null ? 43 : this.volumeGroupBackupId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteVolumeGroupBackupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeGroupBackupId = null;
        private String ifMatch = null;

        public Builder volumeGroupBackupId(String volumeGroupBackupId) {
            this.volumeGroupBackupId = volumeGroupBackupId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteVolumeGroupBackupRequest o) {
            this.volumeGroupBackupId(o.getVolumeGroupBackupId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteVolumeGroupBackupRequest build() {
            DeleteVolumeGroupBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteVolumeGroupBackupRequest buildWithoutInvocationCallback() {
            DeleteVolumeGroupBackupRequest request = new DeleteVolumeGroupBackupRequest();
            request.volumeGroupBackupId = this.volumeGroupBackupId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

