/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.htmlui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.modules.maven.htmlui.Bundle;
import org.netbeans.modules.maven.htmlui.Device;
import org.netbeans.modules.maven.htmlui.DeviceType;

final class MacUtilities {
    private static final String ID_UNKNOWN = "0000-0000-0000";

    private MacUtilities() {
    }

    static void listDevices(List<Device> collectTo) {
        Process p;
        collectTo.clear();
        Device loading = new Device().assignId(ID_UNKNOWN).assignName(Bundle.MSG_Loading()).assignInfo(Bundle.MSG_Loading());
        collectTo.add(loading);
        ProcessBuilder pb = ProcessBuilder.getLocal();
        pb.setExecutable("instruments");
        pb.setArguments(Arrays.asList("-s", "devices"));
        pb.setRedirectErrorStream(true);
        try {
            p = pb.call();
        }
        catch (IOException ex) {
            collectTo.clear();
            collectTo.add(new Device().assignId(ID_UNKNOWN).assignName("unknown").assignInfo(Bundle.ERR_CannotExecute(ex.getLocalizedMessage())));
            return;
        }
        InputStream is = p.getInputStream();
        MacUtilities.parseDevices(collectTo, is);
        p.destroy();
        collectTo.remove(loading);
    }

    static List<Device> parseDevices(List<Device> collectTo, InputStream is) {
        Pattern pattern = Pattern.compile("\\[([0-9A-Fa-f\\-]+)\\]");
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        int at = collectTo.size();
        while (true) {
            String l;
            try {
                l = r.readLine();
            }
            catch (IOException ex) {
                collectTo.add(new Device().assignId(ID_UNKNOWN).assignName("unknown").assignInfo(Bundle.ERR_CannotExecute(ex.getLocalizedMessage())));
                break;
            }
            if (l == null) break;
            if (l.indexOf(91) == -1 || l.indexOf(93) == -1) continue;
            Matcher m = pattern.matcher(l);
            if (m.find()) {
                String id = m.group(1);
                String nameVersion = l.substring(0, m.start()).trim();
                String rest = l.substring(m.end());
                Device d = new Device().assignName(nameVersion).assignId(id);
                if (rest.contains("imulator")) {
                    d.assignType(DeviceType.SIMULATOR);
                } else {
                    d.assignType(DeviceType.DEVICE);
                }
                collectTo.add(at++, d);
                continue;
            }
            Device notRecognized = new Device().assignId(ID_UNKNOWN).assignName("broken").assignInfo(Bundle.ERR_CannotParse(l));
            collectTo.add(collectTo.size(), notRecognized);
        }
        return collectTo;
    }
}

