/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class FindLocalUsagesQuery
extends CancellableTreePathScanner<Void, Void> {
    private CompilationInfo info;
    private SourcePositions sp;
    private TreeUtilities treeUtils;
    private Set<MutablePositionRegion> usages;
    private Set<MutablePositionRegion> comments;
    private Element toFind;
    private Document doc;
    private DocTreePathScanner docScanner;
    private boolean searchComment;

    public void findUsages(Element element, CompilationInfo info, Document doc, boolean searchComment) {
        this.info = info;
        this.usages = new HashSet<MutablePositionRegion>();
        this.comments = new HashSet<MutablePositionRegion>();
        this.toFind = element;
        this.doc = doc;
        this.searchComment = searchComment;
        this.treeUtils = info.getTreeUtilities();
        this.sp = info.getTrees().getSourcePositions();
        this.docScanner = new DocTreePathScannerImpl();
        this.scan(info.getCompilationUnit(), null);
    }

    public Set<MutablePositionRegion> getUsages() {
        return this.usages;
    }

    public Set<MutablePositionRegion> getComments() {
        return this.comments;
    }

    private void handleJavadoc(TreePath el) {
        if (el != null) {
            switch (el.getLeaf().getKind()) {
                case METHOD: 
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case VARIABLE: {
                    DocCommentTree docCommentTree = this.info.getDocTrees().getDocCommentTree(el);
                    if (docCommentTree == null) break;
                    DocTreePath docTreePath = new DocTreePath(el, docCommentTree);
                    this.docScanner.scan(docTreePath, null);
                }
            }
        }
    }

    public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
        if (!this.searchComment) {
            return (Void)super.visitCompilationUnit(node, (Object)p);
        }
        if (this.toFind.getKind() == ElementKind.PARAMETER) {
            this.renameParameterInMethodComments(this.toFind);
        } else {
            String originalName = this.toFind.getSimpleName().toString();
            if (originalName != null) {
                TokenSequence ts = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (!this.isComment((Token<JavaTokenId>)t)) continue;
                    this.findAllInComment(t.text().toString(), ts.offset(), originalName);
                }
            }
        }
        return (Void)super.visitCompilationUnit(node, (Object)p);
    }

    private void renameParameterInMethodComments(Element parameter) {
        Tree method = this.info.getTrees().getPath(parameter).getParentPath().getLeaf();
        String originalName = parameter.getSimpleName().toString();
        int methodStart = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), method);
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(methodStart);
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (this.isComment((Token<JavaTokenId>)token)) {
                this.findAllInComment(token.text().toString(), tokenSequence.offset(), originalName);
                continue;
            }
            if (token.id() == JavaTokenId.WHITESPACE) continue;
            break;
        }
        int methodEnd = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), method);
        tokenSequence.move(methodStart);
        while (tokenSequence.moveNext() && tokenSequence.offset() < methodEnd) {
            Token token = tokenSequence.token();
            if (!this.isComment((Token<JavaTokenId>)token)) continue;
            this.findAllInComment(token.text().toString(), tokenSequence.offset(), originalName);
        }
    }

    private void findAllInComment(String text, int offset, String originalName) {
        int index = text.indexOf(originalName);
        while (index != -1) {
            if (!(index > 0 && Character.isJavaIdentifierPart(text.charAt(index - 1)) || index + originalName.length() < text.length() && Character.isJavaIdentifierPart(text.charAt(index + originalName.length())) || text.charAt(index - 1) == '<' || text.charAt(index - 1) == '/')) {
                try {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, offset + index, offset + index + originalName.length());
                    this.comments.add(region);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            index = text.indexOf(originalName, index + 1);
        }
    }

    private boolean isComment(Token<JavaTokenId> token) {
        switch ((JavaTokenId)token.id()) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    public Void visitIdentifier(com.sun.source.tree.IdentifierTree tree, Void d) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                long start = this.sp.getStartPosition(this.info.getCompilationUnit(), tree);
                long end = this.sp.getEndPosition(this.info.getCompilationUnit(), tree);
                if (start != -1L) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, (int)start, (int)end);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (Void)super.visitIdentifier(tree, (Object)d);
    }

    public Void visitMemberReference(MemberReferenceTree node, Void p) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                int[] span = this.treeUtils.findNameSpan(node);
                if (span != null) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (Void)super.visitMemberReference(node, (Object)p);
    }

    public Void visitMethod(MethodTree node, Void d) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                int[] span = this.treeUtils.findNameSpan(node);
                if (span != null) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.handleJavadoc(this.getCurrentPath());
        return (Void)super.visitMethod(node, (Object)d);
    }

    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                int[] span = this.treeUtils.findNameSpan(node);
                if (span != null) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (Void)super.visitMemberSelect(node, (Object)p);
    }

    public Void visitVariable(VariableTree tree, Void d) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                int[] span = this.treeUtils.findNameSpan(tree);
                if (span != null) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (el != null && el.getKind().isField()) {
            this.handleJavadoc(this.getCurrentPath());
        }
        return (Void)super.visitVariable(tree, (Object)d);
    }

    public Void visitClass(ClassTree tree, Void d) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                int[] span = this.treeUtils.findNameSpan(tree);
                if (span != null) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.handleJavadoc(this.getCurrentPath());
        return (Void)super.visitClass(tree, (Object)d);
    }

    public Void visitTypeParameter(TypeParameterTree node, Void p) {
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (this.toFind.equals(el)) {
            try {
                int[] span = this.treeUtils.findNameSpan(node);
                if (span != null) {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                    this.usages.add(region);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (Void)super.visitTypeParameter(node, (Object)p);
    }

    public Void visitImport(ImportTree node, Void p) {
        Tree qualIdent;
        if (node.isStatic() && this.toFind.getModifiers().contains((Object)Modifier.STATIC) && (qualIdent = node.getQualifiedIdentifier()).getKind() == Tree.Kind.MEMBER_SELECT) {
            Element el;
            MemberSelectTree mst = (MemberSelectTree)qualIdent;
            if (this.toFind.getSimpleName().contentEquals(mst.getIdentifier()) && (el = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), mst.getExpression()))) != null && el.equals(this.toFind.getEnclosingElement())) {
                try {
                    int[] span = this.treeUtils.findNameSpan(mst);
                    if (span != null) {
                        MutablePositionRegion region = FindLocalUsagesQuery.createRegion(this.doc, span[0], span[1]);
                        this.usages.add(region);
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return (Void)super.visitImport(node, (Object)p);
    }

    public static MutablePositionRegion createRegion(Document doc, int start, int end) throws BadLocationException {
        Position startPos = NbDocument.createPosition((Document)doc, (int)start, (Position.Bias)Position.Bias.Backward);
        Position endPos = NbDocument.createPosition((Document)doc, (int)end, (Position.Bias)Position.Bias.Forward);
        MutablePositionRegion current = new MutablePositionRegion(startPos, endPos);
        return current;
    }

    private class DocTreePathScannerImpl
    extends DocTreePathScanner<DocTree, Element> {
        private DocTreePathScannerImpl() {
        }

        @Override
        public DocTree visitReference(ReferenceTree node, Element p) {
            int[] span;
            DocTrees trees = FindLocalUsagesQuery.this.info.getDocTrees();
            Element el = trees.getElement(this.getCurrentPath());
            if (el != null && el.equals(FindLocalUsagesQuery.this.toFind) && (span = FindLocalUsagesQuery.this.treeUtils.findNameSpan(this.getCurrentPath().getDocComment(), node)) != null) {
                try {
                    MutablePositionRegion region = FindLocalUsagesQuery.createRegion(FindLocalUsagesQuery.this.doc, span[0], span[1]);
                    FindLocalUsagesQuery.this.usages.add(region);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return (DocTree)super.visitReference(node, p);
        }

        @Override
        public DocTree visitText(TextTree node, Element p) {
            if (FindLocalUsagesQuery.this.searchComment) {
                String name;
                String text;
                DocTrees trees = FindLocalUsagesQuery.this.info.getDocTrees();
                DocSourcePositions sourcePositions = trees.getSourcePositions();
                DocTreePath currentDocPath = this.getCurrentPath();
                if (FindLocalUsagesQuery.this.toFind.getKind() == ElementKind.PARAMETER) {
                    VariableElement var = (VariableElement)FindLocalUsagesQuery.this.toFind;
                    Element method = trees.getElement(currentDocPath);
                    if (!var.getEnclosingElement().equals(method)) {
                        return (DocTree)super.visitText(node, p);
                    }
                }
                if ((text = node.getBody()).contains(name = FindLocalUsagesQuery.this.toFind.getSimpleName().toString())) {
                    int start = (int)sourcePositions.getStartPosition(FindLocalUsagesQuery.this.info.getCompilationUnit(), currentDocPath.getDocComment(), node);
                    int length = name.length();
                    int offset = -1;
                    do {
                        ++offset;
                        if ((offset = text.indexOf(name, offset)) == -1) continue;
                        try {
                            MutablePositionRegion region = FindLocalUsagesQuery.createRegion(FindLocalUsagesQuery.this.doc, start + offset, start + offset + length);
                            FindLocalUsagesQuery.this.comments.add(region);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } while (offset != -1);
                }
            }
            return (DocTree)super.visitText(node, p);
        }

        @Override
        public DocTree visitIdentifier(IdentifierTree node, Element p) {
            DocTrees trees = FindLocalUsagesQuery.this.info.getDocTrees();
            Element el = trees.getElement(this.getCurrentPath());
            if (el != null && el.equals(FindLocalUsagesQuery.this.toFind)) {
                DocSourcePositions sp = trees.getSourcePositions();
                CompilationUnitTree cut = FindLocalUsagesQuery.this.info.getCompilationUnit();
                DocCommentTree docComment = this.getCurrentPath().getDocComment();
                long start = sp.getStartPosition(cut, docComment, node);
                long end = sp.getEndPosition(cut, docComment, node);
                if (start != -1L && end != -1L) {
                    try {
                        MutablePositionRegion region = FindLocalUsagesQuery.createRegion(FindLocalUsagesQuery.this.doc, (int)start, (int)end);
                        FindLocalUsagesQuery.this.usages.add(region);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return (DocTree)super.visitIdentifier(node, p);
        }
    }
}

