/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformFilter;
import org.netbeans.spi.java.project.support.PreferredProjectPlatform;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlRenderer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PlatformUiSupport {
    private static final SpecificationVersion JDK_1_5 = new SpecificationVersion("1.5");
    private static final Logger LOGGER = Logger.getLogger(PlatformUiSupport.class.getName());

    private PlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String activePlatform) {
        return PlatformUiSupport.createPlatformComboBoxModel(activePlatform, null);
    }

    public static ComboBoxModel createPlatformComboBoxModel(String activePlatform, Collection<? extends PlatformFilter> filters) {
        return new PlatformComboBoxModel(activePlatform, null, null, filters);
    }

    @NonNull
    public static ComboBoxModel createPlatformComboBoxModel(@NonNull Project owner, @NonNull PropertyEvaluator eval, @NullAllowed String activePlatform, @NullAllowed Collection<? extends PlatformFilter> filters) {
        Parameters.notNull((CharSequence)"owner", (Object)owner);
        Parameters.notNull((CharSequence)"eval", (Object)eval);
        return new PlatformComboBoxModel(activePlatform, owner, eval, filters);
    }

    public static ListCellRenderer createPlatformListCellRenderer() {
        return new PlatformListCellRenderer();
    }

    public static void storePlatform(EditableProperties props, UpdateHelper helper, String projectConfigurationNamespace, String platformName, SpecificationVersion sourceLevel) {
        JavaPlatform platform;
        Parameters.notNull((CharSequence)"props", (Object)props);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)projectConfigurationNamespace);
        Parameters.notNull((CharSequence)"sourceLevel", (Object)sourceLevel);
        PlatformKey platformKey = null;
        if (platformName != null && (platform = PlatformUiSupport.findPlatform(platformName)) != null) {
            platformKey = new PlatformKey(platform);
        }
        if (platformKey == null) {
            platformKey = new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
        }
        PlatformUiSupport.storePlatform(props, helper, projectConfigurationNamespace, platformKey, new SourceLevelKey(sourceLevel));
    }

    public static void storePlatform(@NonNull EditableProperties props, @NonNull UpdateHelper helper, @NonNull String projectConfigurationNamespace, @NonNull Object platformKey, @NullAllowed Object sourceLevelKey) {
        PlatformUiSupport.storePlatform(props, helper, projectConfigurationNamespace, platformKey, sourceLevelKey, null, true);
    }

    public static void storePlatform(@NonNull EditableProperties props, @NonNull UpdateHelper helper, @NonNull String projectConfigurationNamespace, @NonNull Object platformKey, @NullAllowed Object sourceLevelKey, boolean updatePreferredPlatform) {
        PlatformUiSupport.storePlatform(props, helper, projectConfigurationNamespace, platformKey, sourceLevelKey, null, updatePreferredPlatform);
    }

    public static void storePlatform(@NonNull EditableProperties props, @NonNull UpdateHelper helper, @NonNull String projectConfigurationNamespace, @NonNull Object platformKey, @NullAllowed Object sourceLevelKey, @NullAllowed Object profileKey, boolean updatePreferredPlatform) {
        String javacSource;
        Parameters.notNull((CharSequence)"props", (Object)props);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)projectConfigurationNamespace);
        Parameters.notNull((CharSequence)"platformKey", (Object)platformKey);
        if (!(platformKey instanceof PlatformKey)) {
            throw new IllegalArgumentException(String.format("Unsupported platform key: %s of type: %s", platformKey, platformKey.getClass()));
        }
        if (sourceLevelKey != null && !(sourceLevelKey instanceof SourceLevelKey)) {
            throw new IllegalArgumentException(String.format("Unsupported source level key: %s of type: %s", sourceLevelKey, sourceLevelKey.getClass()));
        }
        if (profileKey != null && !(profileKey instanceof Union2)) {
            throw new IllegalArgumentException(String.format("Unsupported profile key: %s of type: %s", profileKey, profileKey.getClass()));
        }
        String javaPlatformKey = "platform.active";
        String javacSourceKey = "javac.source";
        String javacTargetKey = "javac.target";
        String javacProfileKey = "javac.profile";
        PlatformKey pk = (PlatformKey)platformKey;
        JavaPlatform platform = PlatformUiSupport.getPlatform(pk);
        if (platform == null) {
            return;
        }
        if (updatePreferredPlatform && !PlatformUiSupport.isProjectLocalPlatform(platform)) {
            PreferredProjectPlatform.setPreferredPlatform((JavaPlatform)platform);
        }
        SpecificationVersion jdk13 = new SpecificationVersion("1.3");
        String platformAntName = (String)platform.getProperties().get("platform.ant.name");
        assert (platformAntName != null);
        props.put("platform.active", platformAntName);
        Element root = helper.getPrimaryConfigurationData(true);
        boolean changed = false;
        NodeList explicitPlatformNodes = root.getElementsByTagNameNS(projectConfigurationNamespace, "explicit-platform");
        if (pk.isDefaultPlatform()) {
            if (explicitPlatformNodes.getLength() == 1) {
                root.removeChild(explicitPlatformNodes.item(0));
                changed = true;
            }
        } else {
            Element explicitPlatform;
            switch (explicitPlatformNodes.getLength()) {
                case 0: {
                    explicitPlatform = root.getOwnerDocument().createElementNS(projectConfigurationNamespace, "explicit-platform");
                    NodeList nodes = root.getChildNodes();
                    Node insertBeforeMe = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (n.getNodeType() != 1 || n.getNodeName().equals("name") || n.getNodeName().equals("minimum-ant-version")) continue;
                        insertBeforeMe = n;
                        break;
                    }
                    if (insertBeforeMe != null) {
                        root.insertBefore(explicitPlatform, insertBeforeMe);
                    } else {
                        root.appendChild(explicitPlatform);
                    }
                    changed = true;
                    break;
                }
                case 1: {
                    explicitPlatform = (Element)explicitPlatformNodes.item(0);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Broken project.xml file");
                }
            }
            String explicitSourceAttrValue = explicitPlatform.getAttribute("explicit-source-supported");
            if (jdk13.compareTo(platform.getSpecification().getVersion()) >= 0 && !"false".equals(explicitSourceAttrValue)) {
                explicitPlatform.setAttribute("explicit-source-supported", "false");
                changed = true;
            } else if (jdk13.compareTo(platform.getSpecification().getVersion()) < 0 && !"true".equals(explicitSourceAttrValue)) {
                explicitPlatform.setAttribute("explicit-source-supported", "true");
                changed = true;
            }
        }
        SpecificationVersion sourceLevel = sourceLevelKey == null ? platform.getSpecification().getVersion() : ((SourceLevelKey)sourceLevelKey).getSourceLevel();
        String javacTarget = javacSource = sourceLevel.toString();
        if (jdk13.compareTo(sourceLevel) >= 0) {
            javacTarget = "1.1";
        }
        if (!javacSource.equals(props.getProperty("javac.source"))) {
            props.setProperty("javac.source", javacSource);
        }
        if (!javacTarget.equals(props.getProperty("javac.target"))) {
            props.setProperty("javac.target", javacTarget);
        }
        String javacProfile = null;
        if (profileKey != null) {
            Union2 tv = (Union2)profileKey;
            if (tv.hasFirst()) {
                SourceLevelQuery.Profile profile = (SourceLevelQuery.Profile)tv.first();
                if (profile != SourceLevelQuery.Profile.DEFAULT) {
                    javacProfile = profile.getName();
                }
            } else {
                javacProfile = (String)tv.second();
            }
        }
        if (javacProfile != null) {
            if (!javacProfile.equals(props.getProperty("javac.profile"))) {
                props.setProperty("javac.profile", javacProfile);
            }
        } else {
            props.remove((Object)"javac.profile");
        }
        if (changed) {
            helper.putPrimaryConfigurationData(root, true);
        }
    }

    public static SpecificationVersion getSourceLevel(@NonNull Object sourceLevelKey) {
        Parameters.notNull((CharSequence)"sourceLevelKey", (Object)sourceLevelKey);
        if (!(sourceLevelKey instanceof SourceLevelKey)) {
            throw new IllegalArgumentException(String.format("Unsupported source level key: %s of type: %s", sourceLevelKey, sourceLevelKey.getClass()));
        }
        return ((SourceLevelKey)sourceLevelKey).getSourceLevel();
    }

    public static JavaPlatform getPlatform(Object platformKey) {
        Parameters.notNull((CharSequence)"platformKey", (Object)platformKey);
        if (platformKey instanceof PlatformKey) {
            return PlatformUiSupport.getPlatform((PlatformKey)platformKey);
        }
        throw new IllegalArgumentException();
    }

    @CheckForNull
    public static SourceLevelQuery.Profile getProfile(@NonNull Object profileKey) {
        Parameters.notNull((CharSequence)"profileKey", (Object)profileKey);
        if (profileKey instanceof Union2) {
            Union2 u2 = (Union2)profileKey;
            if (u2.hasFirst()) {
                Object profile = u2.first();
                if (profile instanceof SourceLevelQuery.Profile) {
                    return (SourceLevelQuery.Profile)profile;
                }
                throw new IllegalArgumentException(profile.getClass().getName());
            }
            return null;
        }
        throw new IllegalArgumentException(profileKey.getClass().getName());
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialSourceLevel, String initialTargetLevel, SpecificationVersion minimalSpecificationVersion) {
        Parameters.notNull((CharSequence)"platformComboBoxModel", (Object)platformComboBoxModel);
        return new SourceLevelComboBoxModel(platformComboBoxModel, initialSourceLevel, initialTargetLevel, minimalSpecificationVersion);
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialSourceLevel, String initialTargetLevel) {
        Parameters.notNull((CharSequence)"platformComboBoxModel", (Object)platformComboBoxModel);
        return new SourceLevelComboBoxModel(platformComboBoxModel, initialSourceLevel, initialTargetLevel, null);
    }

    public static ListCellRenderer createSourceLevelListCellRenderer() {
        return new SourceLevelListCellRenderer();
    }

    public static ComboBoxModel createProfileComboBoxModel(@NonNull ComboBoxModel sourceLevelModel, @NullAllowed String initialProfileName, @NullAllowed SourceLevelQuery.Profile minimalProfile) {
        return new ProfileComboBoxModel(sourceLevelModel, initialProfileName, minimalProfile);
    }

    public static ListCellRenderer createProfileListCellRenderer() {
        return new ProfileListCellRenderer();
    }

    private static JavaPlatform getPlatform(PlatformKey platformKey) {
        return platformKey == null ? null : platformKey.platform;
    }

    private static JavaPlatform findPlatform(String displayName) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(displayName, new Specification("j2se", null));
        if (platforms.length == 0) {
            return null;
        }
        return platforms[0];
    }

    private static boolean isProjectLocalPlatform(@NonNull JavaPlatform jp) {
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!p.equals(jp)) continue;
            return false;
        }
        return true;
    }

    private static final class PlatformKey
    implements Comparable {
        private String name;
        private boolean equalsDefaultPlatformName;
        private JavaPlatform platform;

        public PlatformKey(String name) {
            assert (name != null);
            this.name = name;
        }

        public PlatformKey(String name, boolean equalsDefaultPlatformName) {
            assert (name != null);
            this.name = name;
            this.equalsDefaultPlatformName = equalsDefaultPlatformName;
        }

        public PlatformKey(JavaPlatform platform) {
            this(platform, null);
        }

        public PlatformKey(@NonNull JavaPlatform platform, @NullAllowed String name) {
            assert (platform != null);
            this.platform = platform;
            this.name = name;
        }

        public int compareTo(Object o) {
            return this.getDisplayName().compareTo(((PlatformKey)o).getDisplayName());
        }

        public boolean equals(Object other) {
            if (other instanceof PlatformKey) {
                PlatformKey otherKey = (PlatformKey)other;
                boolean equals = this.platform == null ? otherKey.platform == null : this.platform.equals(otherKey.platform);
                return equals && otherKey.getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public int hashCode() {
            return this.getDisplayName().hashCode();
        }

        public String toString() {
            return this.getDisplayName();
        }

        public synchronized String getDisplayName() {
            if (this.name == null) {
                this.name = this.platform.getDisplayName();
            }
            return this.name;
        }

        public boolean isDefaultPlatform() {
            if (this.platform == null) {
                return false;
            }
            return this.platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        }

        public boolean hasDefaultPlatformName() {
            return this.equalsDefaultPlatformName;
        }

        public boolean isBroken() {
            return this.platform == null;
        }
    }

    private static final class PlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final JavaPlatformManager pm;
        private final Project project;
        private final PropertyEvaluator eval;
        private PlatformKey[] platformNamesCache;
        private String initialPlatform;
        private PlatformKey selectedPlatform;
        private boolean inUpdate;
        private Collection<? extends PlatformFilter> filters;

        public PlatformComboBoxModel(@NullAllowed String initialPlatform, @NullAllowed Project owner, @NullAllowed PropertyEvaluator eval, @NullAllowed Collection<? extends PlatformFilter> filters) {
            assert (owner != null ? eval != null : eval == null);
            this.pm = JavaPlatformManager.getDefault();
            this.initialPlatform = initialPlatform;
            this.filters = filters;
            this.project = owner;
            this.eval = eval;
            this.pm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pm));
        }

        @Override
        public int getSize() {
            PlatformKey[] platformNames = this.getPlatformNames();
            return platformNames.length;
        }

        @Override
        public Object getElementAt(int index) {
            PlatformKey[] platformNames = this.getPlatformNames();
            assert (index >= 0 && index < platformNames.length);
            return platformNames[index];
        }

        @Override
        public Object getSelectedItem() {
            this.getPlatformNames();
            return this.selectedPlatform;
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (obj != null) {
                this.selectedPlatform = (PlatformKey)obj;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("installedPlatforms".equals(event.getPropertyName())) {
                PlatformComboBoxModel platformComboBoxModel = this;
                synchronized (platformComboBoxModel) {
                    this.platformNamesCache = null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        inUpdate = true;
                        try {
                            this.fireContentsChanged(this, -1, -1);
                        }
                        finally {
                            inUpdate = false;
                        }
                    }
                });
            }
        }

        private synchronized PlatformKey[] getPlatformNames() {
            if (this.platformNamesCache == null) {
                String activeHomeKey;
                String active;
                ArrayList<JavaPlatform> platforms = new ArrayList<JavaPlatform>();
                Collections.addAll(platforms, this.pm.getPlatforms(null, new Specification("j2se", null)));
                JavaPlatform projectPlatform = null;
                EditableProperties globalProps = PropertyUtils.getGlobalProperties();
                if (this.project != null && (active = this.eval.getProperty("platform.active")) != null && this.eval.getProperty(activeHomeKey = String.format("platforms.%s.home", active)) != null && !globalProps.containsKey((Object)activeHomeKey)) {
                    JavaPlatform javaPlatform = projectPlatform = this.project != null ? ProjectPlatform.forProject((Project)this.project, (PropertyEvaluator)this.eval, (String)"j2se") : null;
                    if (projectPlatform != null) {
                        platforms.add(projectPlatform);
                    }
                }
                TreeSet<PlatformKey> orderedNames = new TreeSet<PlatformKey>();
                boolean activeFound = false;
                for (JavaPlatform platform : platforms) {
                    String string;
                    boolean accepted = true;
                    if (this.filters != null) {
                        for (PlatformFilter platformFilter : this.filters) {
                            if (platformFilter.accept(platform)) continue;
                            accepted = false;
                            break;
                        }
                    }
                    if (!accepted || !platform.isValid()) continue;
                    PlatformKey pk = platform == projectPlatform ? new PlatformKey(platform, NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ProjectPlatformName", (Object)platform.getDisplayName())) : new PlatformKey(platform);
                    orderedNames.add(pk);
                    if (activeFound || this.initialPlatform == null || !this.initialPlatform.equals(string = (String)platform.getProperties().get("platform.ant.name"))) continue;
                    if (this.selectedPlatform == null) {
                        this.selectedPlatform = pk;
                        this.initialPlatform = null;
                    }
                    activeFound = true;
                }
                if (!activeFound) {
                    if (orderedNames.isEmpty()) {
                        LOGGER.warning("PlatformComboBoxModel: All platforms filtered out. Adding default platform although it is not accepted by all PlatformFilters.");
                        this.selectedPlatform = new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
                        orderedNames.add(this.selectedPlatform);
                    } else if (this.initialPlatform == null) {
                        if (this.selectedPlatform == null || !orderedNames.contains(this.selectedPlatform)) {
                            this.selectedPlatform = new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
                        }
                    } else {
                        String defaultPlatformName = JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
                        if (defaultPlatformName != null && defaultPlatformName.endsWith(" " + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformDefault"))) {
                            defaultPlatformName = defaultPlatformName.substring(0, defaultPlatformName.length() - NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformDefault").length() - 1).replace(" ", "_");
                        }
                        PlatformKey pk = new PlatformKey(this.initialPlatform, defaultPlatformName != null && this.initialPlatform.equals(defaultPlatformName));
                        orderedNames.add(pk);
                        if (this.selectedPlatform == null) {
                            this.selectedPlatform = pk;
                        }
                    }
                }
                this.platformNamesCache = orderedNames.toArray(new PlatformKey[0]);
                assert (this.selectedPlatform != null) : "platformNamesCache: " + orderedNames + " initialPlatform: " + this.initialPlatform;
            }
            return this.platformNamesCache;
        }
    }

    private static final class PlatformListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name;
            if (value == null || " ".equals(value)) {
                name = " ";
            } else {
                assert (value instanceof PlatformKey) : "Wrong model";
                PlatformKey key = (PlatformKey)value;
                name = key.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformFmt", (Object)key.getDisplayName()) + (key.hasDefaultPlatformName() ? " " + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformCustom") : "") : key.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
        }
    }

    private static final class SourceLevelKey
    implements Comparable {
        private final SpecificationVersion sourceLevel;
        private final boolean broken;

        public SourceLevelKey(SpecificationVersion sourceLevel) {
            this(sourceLevel, false);
        }

        public SourceLevelKey(SpecificationVersion sourceLevel, boolean broken) {
            assert (sourceLevel != null) : "Source level cannot be null";
            this.sourceLevel = sourceLevel;
            this.broken = broken;
        }

        public SpecificationVersion getSourceLevel() {
            return this.sourceLevel;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public int compareTo(Object other) {
            assert (other instanceof SourceLevelKey) : "Illegal argument of SourceLevelKey.compareTo()";
            SourceLevelKey otherKey = (SourceLevelKey)other;
            return this.sourceLevel.compareTo(otherKey.sourceLevel);
        }

        public boolean equals(Object other) {
            return other instanceof SourceLevelKey && ((SourceLevelKey)other).sourceLevel.equals((Object)this.sourceLevel);
        }

        public int hashCode() {
            return this.sourceLevel.hashCode();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.broken) {
                buffer.append("Broken: ");
            }
            buffer.append(this.sourceLevel.toString());
            return buffer.toString();
        }

        public String getDisplayName() {
            String tmp = this.sourceLevel.toString();
            if (JDK_1_5.compareTo(this.sourceLevel) <= 0) {
                tmp = tmp.replaceFirst("^1\\.([5-9]|\\d\\d+)$", "$1");
            }
            return NbBundle.getMessage(PlatformUiSupport.class, (String)"LBL_JDK", (Object)tmp);
        }
    }

    private static final class SourceLevelComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private static final long serialVersionUID = 1L;
        private final ComboBoxModel platformComboBoxModel;
        private final SpecificationVersion minimalSpecificationVersion;
        private SpecificationVersion selectedSourceLevel;
        private SpecificationVersion originalSourceLevel;
        private SourceLevelKey[] sourceLevelCache;
        private PlatformKey activePlatform;

        public SourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialSourceLevel, String initialTargetLevel, SpecificationVersion minimalSpecificationVersion) {
            this.platformComboBoxModel = platformComboBoxModel;
            this.activePlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            this.platformComboBoxModel.addListDataListener(this);
            if (initialSourceLevel != null && initialSourceLevel.length() > 0) {
                try {
                    this.originalSourceLevel = new SpecificationVersion(initialSourceLevel);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Invalid javac.source: " + initialSourceLevel);
                }
            }
            if (initialTargetLevel != null && initialTargetLevel.length() > 0) {
                try {
                    SpecificationVersion originalTargetLevel = new SpecificationVersion(initialTargetLevel);
                    if (this.originalSourceLevel == null || this.originalSourceLevel.compareTo(originalTargetLevel) < 0) {
                        this.originalSourceLevel = originalTargetLevel;
                    }
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Invalid javac.target: " + initialTargetLevel);
                }
            }
            this.selectedSourceLevel = this.originalSourceLevel;
            this.minimalSpecificationVersion = minimalSpecificationVersion;
        }

        @Override
        public int getSize() {
            SourceLevelKey[] sLevels = this.getSourceLevels();
            return sLevels.length;
        }

        @Override
        public Object getElementAt(int index) {
            SourceLevelKey[] sLevels = this.getSourceLevels();
            assert (index >= 0 && index < sLevels.length);
            return sLevels[index];
        }

        @Override
        public Object getSelectedItem() {
            for (SourceLevelKey key : this.getSourceLevels()) {
                if (!key.getSourceLevel().equals((Object)this.selectedSourceLevel)) continue;
                return key;
            }
            return null;
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.selectedSourceLevel = obj == null ? null : ((SourceLevelKey)obj).getSourceLevel();
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            PlatformKey selectedPlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            JavaPlatform platform = PlatformUiSupport.getPlatform(selectedPlatform);
            if (!(platform == null || this.platformComboBoxModel instanceof PlatformComboBoxModel && ((PlatformComboBoxModel)this.platformComboBoxModel).inUpdate)) {
                SpecificationVersion version = platform.getSpecification().getVersion();
                if (this.selectedSourceLevel != null && this.selectedSourceLevel.compareTo(version) > 0 && !this.shouldChangePlatform(this.selectedSourceLevel, version) && !selectedPlatform.equals(this.activePlatform)) {
                    this.platformComboBoxModel.setSelectedItem(this.activePlatform);
                    return;
                }
                this.originalSourceLevel = null;
            }
            this.activePlatform = selectedPlatform;
            this.resetCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCache() {
            SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
            synchronized (sourceLevelComboBoxModel) {
                this.sourceLevelCache = null;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        private SourceLevelKey[] getSourceLevels() {
            if (this.sourceLevelCache == null) {
                PlatformKey selectedPlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
                JavaPlatform platform = PlatformUiSupport.getPlatform(selectedPlatform);
                ArrayList<SourceLevelKey> sLevels = new ArrayList<SourceLevelKey>();
                boolean selSourceLevelValid = false;
                if (platform != null) {
                    SpecificationVersion version = platform.getSpecification().getVersion();
                    SpecificationVersion current = this.getMinimalIndex(version);
                    boolean origSourceLevelValid = false;
                    while (current.compareTo(version) <= 0) {
                        if (current.equals((Object)this.originalSourceLevel)) {
                            origSourceLevelValid = true;
                        }
                        if (current.equals((Object)this.selectedSourceLevel)) {
                            selSourceLevelValid = true;
                        }
                        sLevels.add(new SourceLevelKey(current));
                        current = SourceLevelComboBoxModel.incJavaSpecVersion(current);
                    }
                    if (this.originalSourceLevel != null && !origSourceLevelValid) {
                        if (this.originalSourceLevel.equals((Object)this.selectedSourceLevel)) {
                            selSourceLevelValid = true;
                        }
                        sLevels.add(new SourceLevelKey(this.originalSourceLevel, true));
                    }
                }
                this.sourceLevelCache = sLevels.toArray(new SourceLevelKey[0]);
                if (!selSourceLevelValid) {
                    this.selectedSourceLevel = this.sourceLevelCache.length == 0 ? null : this.sourceLevelCache[this.sourceLevelCache.length - 1].getSourceLevel();
                }
            }
            return this.sourceLevelCache;
        }

        private SpecificationVersion getMinimalIndex(SpecificationVersion platformVersion) {
            SpecificationVersion min = SourceLevelQuery.MINIMAL_SOURCE_LEVEL;
            if (this.minimalSpecificationVersion != null) {
                while (min.compareTo(platformVersion) <= 0) {
                    if (min.compareTo(this.minimalSpecificationVersion) >= 0) {
                        return min;
                    }
                    min = SourceLevelComboBoxModel.incJavaSpecVersion(min);
                }
            }
            return min;
        }

        private boolean shouldChangePlatform(SpecificationVersion selectedSourceLevel, SpecificationVersion platformSourceLevel) {
            JButton changeOption = new JButton(NbBundle.getMessage(PlatformUiSupport.class, (String)"CTL_ChangePlatform"));
            changeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformUiSupport.class, (String)"AD_ChangePlatform"));
            String message = MessageFormat.format(NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatform"), selectedSourceLevel.toString(), platformSourceLevel.toString());
            return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatformTitle"), -1, 2, new Object[]{changeOption, NotifyDescriptor.CANCEL_OPTION}, (Object)changeOption)) == changeOption;
        }

        private static int minor(@NonNull SpecificationVersion specVer) {
            String s = specVer.toString();
            int split = s.indexOf(46);
            return split < 0 ? -1 : Integer.parseInt(s.substring(split + 1));
        }

        private static int major(@NonNull SpecificationVersion specVer) {
            String s = specVer.toString();
            int split = s.indexOf(46);
            return Integer.parseInt(split < 0 ? s : s.substring(0, split));
        }

        private static SpecificationVersion incJavaSpecVersion(@NonNull SpecificationVersion version) {
            int major = SourceLevelComboBoxModel.major(version);
            int minor = SourceLevelComboBoxModel.minor(version);
            if (major == 1) {
                if (minor == 8) {
                    major = minor + 1;
                    minor = -1;
                } else {
                    ++minor;
                }
            } else {
                ++major;
            }
            return minor == -1 ? new SpecificationVersion(Integer.toString(major)) : new SpecificationVersion(String.format("%d.%d", major, minor));
        }
    }

    private static final class SourceLevelListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String message;
            if (value == null || " ".equals(value)) {
                message = " ";
            } else {
                assert (value instanceof SourceLevelKey);
                SourceLevelKey key = (SourceLevelKey)value;
                message = key.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_InvalidSourceLevel", (Object)key.getDisplayName()) : key.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(list, message, index, isSelected, cellHasFocus);
        }
    }

    private static final class ProfileComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private final ComboBoxModel sourceLevelModel;
        private final String initialProfileName;
        private final SourceLevelQuery.Profile minimalProfile;
        private List<Union2<SourceLevelQuery.Profile, String>> profiles;
        private Union2<SourceLevelQuery.Profile, String> selectedItem;

        ProfileComboBoxModel(@NonNull ComboBoxModel sourceLevelModel, @NullAllowed String initialProfileName, @NullAllowed SourceLevelQuery.Profile minimalProfile) {
            this.sourceLevelModel = sourceLevelModel;
            this.initialProfileName = initialProfileName;
            this.minimalProfile = minimalProfile;
            this.sourceLevelModel.addListDataListener(this);
        }

        @Override
        public int getSize() {
            List<? extends Union2<SourceLevelQuery.Profile, String>> p = this.init();
            return p.size();
        }

        @Override
        @CheckForNull
        public Object getElementAt(int index) {
            List<? extends Union2<SourceLevelQuery.Profile, String>> p = this.init();
            if (index < 0 || index >= p.size()) {
                throw new IndexOutOfBoundsException(String.format("Index: %d, Profiles count: %d", index, p.size()));
            }
            return p.get(index);
        }

        @Override
        public void setSelectedItem(@NullAllowed Object anItem) {
            assert (anItem == null || anItem instanceof Union2) : anItem;
            this.init();
            this.selectedItem = (Union2)anItem;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        @CheckForNull
        public Object getSelectedItem() {
            this.init();
            return this.selectedItem;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            int oldSize = this.getSize();
            this.profiles = null;
            this.fireContentsChanged(this, 0, oldSize);
        }

        private List<? extends Union2<SourceLevelQuery.Profile, String>> init() {
            if (this.profiles == null) {
                ArrayList<Object> pc = new ArrayList<Object>();
                Object slk = this.sourceLevelModel.getSelectedItem();
                SpecificationVersion sl = slk instanceof SourceLevelKey ? ((SourceLevelKey)slk).getSourceLevel() : null;
                for (SourceLevelQuery.Profile p : SourceLevelQuery.Profile.values()) {
                    if (this.minimalProfile != null && this.minimalProfile.compareTo((Enum)p) > 0 || sl != null && !p.isSupportedIn(sl.toString())) continue;
                    pc.add(Union2.createFirst((Object)p));
                }
                if (this.selectedItem == null) {
                    if (this.initialProfileName != null) {
                        SourceLevelQuery.Profile initialProfile = SourceLevelQuery.Profile.forName((String)this.initialProfileName);
                        if (initialProfile != null) {
                            this.selectedItem = Union2.createFirst((Object)initialProfile);
                        } else {
                            this.selectedItem = Union2.createSecond((Object)this.initialProfileName);
                            pc.add(this.selectedItem);
                        }
                    } else {
                        this.selectedItem = Union2.createFirst((Object)SourceLevelQuery.Profile.DEFAULT);
                    }
                }
                this.profiles = Collections.unmodifiableList(pc);
            }
            return this.profiles;
        }
    }

    private static final class ProfileListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer delegate = HtmlRenderer.createRenderer();

        ProfileListCellRenderer() {
        }

        public Component getListCellRendererComponent(@NonNull JList list, @NullAllowed Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Union2) {
                Union2 tv = (Union2)value;
                value = tv.hasFirst() ? ((SourceLevelQuery.Profile)tv.first()).getDisplayName() : "<html><font color=\"#A40000\">" + (String)tv.second();
            }
            return this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

