/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.openide.NotifyDescriptor;

public final class DatabaseConnectionStep
extends AbstractStep<DatabaseItem> {
    private final Map<String, DatabaseItem> adbConnections = new HashMap<String, DatabaseItem>();
    private DatabaseItem selected = null;

    public DatabaseConnectionStep() {
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            String name = connections[i].getDisplayName();
            String ocid = connections[i].getConnectionProperties().getProperty("OCID");
            String compartmentId = connections[i].getConnectionProperties().getProperty("CompartmentOCID");
            String description = connections[i].getConnectionProperties().getProperty("Description");
            if (ocid == null || compartmentId == null) continue;
            OCIProfile session = OCIManager.getDefault().getActiveProfile();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            String regionCode = session.getRegion().getRegionCode();
            DatabaseItem dbItem = new DatabaseItem(OCID.of(ocid, "Database"), compartmentId, name, null, name, tenancyId, regionCode);
            dbItem.setDescription(description);
            this.adbConnections.put(name, dbItem);
        }
    }

    @Override
    public NotifyDescriptor createInput() {
        LinkedList<NotifyDescriptor.QuickPick.Item> items = new LinkedList<NotifyDescriptor.QuickPick.Item>();
        items.add(new NotifyDescriptor.QuickPick.Item(Bundle.AddNewConnection(), Bundle.AddNewConnection()));
        for (Map.Entry<String, DatabaseItem> adbConnection : this.adbConnections.entrySet()) {
            items.add(new NotifyDescriptor.QuickPick.Item(adbConnection.getKey(), Bundle.OADB()));
        }
        return new NotifyDescriptor.QuickPick(Bundle.SelectDBConnection(), Bundle.SelectDBConnection(), items, false);
    }

    @Override
    public void setValue(String selected) {
        if (!selected.equals(Bundle.AddNewConnection())) {
            this.selected = this.adbConnections.get(selected);
        }
    }

    @Override
    public DatabaseItem getValue() {
        return this.selected;
    }

    @Override
    public boolean onlyOneChoice() {
        return this.adbConnections.isEmpty();
    }
}

