/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.api.DataView;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;
import org.netbeans.modules.db.sql.history.SQLHistoryManager;

public final class SQLExecuteHelper {
    private static final Logger LOGGER = Logger.getLogger(SQLExecuteHelper.class.getName());

    public static SQLExecutionResults execute(String sqlScript, int startOffset, int endOffset, DatabaseConnection conn, SQLExecutionLogger executionLogger) {
        return SQLExecuteHelper.execute(sqlScript, startOffset, endOffset, conn, executionLogger, 100);
    }

    public static SQLExecutionResults execute(String sqlScript, int startOffset, int endOffset, DatabaseConnection conn, SQLExecutionLogger executionLogger, int pageSize) {
        boolean cancelled = false;
        List<StatementInfo> statements = SQLExecuteHelper.getStatements(sqlScript, startOffset, endOffset, SQLExecuteHelper.getCompatibility(conn));
        ArrayList<SQLExecutionResult> results = new ArrayList<SQLExecutionResult>();
        long start = System.currentTimeMillis();
        String url = conn.getDatabaseURL();
        for (StatementInfo info : statements) {
            cancelled = Thread.currentThread().isInterrupted();
            if (cancelled) break;
            String sql = info.getSQL();
            LOGGER.log(Level.FINE, "Executing: {0}", sql);
            DataView view = DataView.create((DatabaseConnection)conn, (String)sql, (int)pageSize);
            SQLHistoryManager.getInstance().saveSQL(new SQLHistoryEntry(url, sql, new Date()));
            SQLExecutionResult result = new SQLExecutionResult(info, view);
            boolean isIllegal = false;
            for (Throwable th : view.getExceptions()) {
                if (!(th instanceof IllegalStateException)) continue;
                LOGGER.log(Level.INFO, th.getLocalizedMessage(), th);
                isIllegal = true;
                break;
            }
            if (isIllegal) break;
            executionLogger.log(result);
            results.add(result);
        }
        long end = System.currentTimeMillis();
        if (!cancelled) {
            executionLogger.finish(end - start);
        } else {
            LOGGER.log(Level.FINE, "Execution cancelled");
            executionLogger.cancel();
        }
        SQLHistoryManager.getInstance().save();
        if (!cancelled) {
            return new SQLExecutionResults(results);
        }
        return null;
    }

    static Compatibility getCompatibility(DatabaseConnection conn) {
        String driverClass = conn.getDriverClass();
        if (driverClass.contains("mysql")) {
            return Compatibility.COMPAT_MYSQL;
        }
        if (driverClass.contains("postgresql")) {
            return Compatibility.COMPAT_POSTGERSQL;
        }
        return Compatibility.COMPAT_GENERIC;
    }

    private static List<StatementInfo> getStatements(String script, int startOffset, int endOffset, Compatibility compat) {
        if (startOffset == 0 && endOffset == script.length() || startOffset == endOffset) {
            List<StatementInfo> allStatements = SQLExecuteHelper.split(script, compat);
            if (startOffset == 0 && endOffset == script.length()) {
                return allStatements;
            }
            StatementInfo foundStatement = SQLExecuteHelper.findStatementAtOffset(allStatements, startOffset, script);
            return foundStatement == null ? Collections.emptyList() : Collections.singletonList(foundStatement);
        }
        return SQLExecuteHelper.split(script.substring(startOffset, endOffset), compat);
    }

    static StatementInfo findStatementAtOffset(List<StatementInfo> statements, int offset, String script) {
        StatementInfo prev = null;
        for (StatementInfo stmt : statements) {
            if (offset <= stmt.getRawEndOffset()) {
                if (offset >= stmt.getStartOffset()) {
                    return stmt;
                }
                if (offset >= stmt.getRawStartOffset()) {
                    if (prev == null) {
                        return stmt;
                    }
                    String between = script.substring(prev.getRawEndOffset(), offset);
                    return between.contains("\n") ? stmt : prev;
                }
            }
            prev = stmt;
        }
        return prev;
    }

    public static List<StatementInfo> split(String script) {
        return SQLExecuteHelper.split(script, Compatibility.COMPAT_MYSQL);
    }

    static List<StatementInfo> split(String script, Compatibility compat) {
        return new SQLSplitter(script, compat).getStatements();
    }

    static class Compatibility {
        public static final Compatibility COMPAT_GENERIC = new Compatibility(false, false);
        public static final Compatibility COMPAT_MYSQL = new Compatibility(true, false);
        public static final Compatibility COMPAT_POSTGERSQL = new Compatibility(false, true);
        private final boolean useHashComments;
        private final boolean useDollarQuotes;

        public Compatibility(boolean useHashComments, boolean useDollarQuotes) {
            this.useHashComments = useHashComments;
            this.useDollarQuotes = useDollarQuotes;
        }

        public boolean isUseHashComments() {
            return this.useHashComments;
        }

        public boolean isUseDollarQuotes() {
            return this.useDollarQuotes;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.useHashComments ? 1 : 0);
            hash = 29 * hash + (this.useDollarQuotes ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Compatibility other = (Compatibility)obj;
            if (this.useHashComments != other.useHashComments) {
                return false;
            }
            return this.useDollarQuotes == other.useDollarQuotes;
        }
    }

    private static final class SQLSplitter {
        private final String sql;
        private final List<Integer> newLineOffsets;
        private final Compatibility compat;
        private final StringBuilder statement = new StringBuilder();
        private final List<StatementInfo> statements = new ArrayList<StatementInfo>();
        private final Map<Integer, Integer> positionMap = new HashMap<Integer, Integer>();
        private int pos = 0;
        private int lastAddedEndPos = 0;
        private int rawStartOffset = 0;
        private int endOffset = 0;
        private int rawEndOffset = 0;
        private String delimiter = ";";
        private static final String DELIMITER_TOKEN = "delimiter";
        private static final String SQL99_STRING_QUOTE = "'";
        private static final String SQL99_IDENTIFIER_QUOTE = "\"";
        private static final String MYSQL_QUOTE = "`";
        private static final String MSSQL_END_QUOTE = "]";
        private static final String MSSQL_BEGIN_QUOTE = "[";

        public SQLSplitter(String sql, Compatibility compat) {
            assert (sql != null);
            this.sql = sql;
            this.newLineOffsets = this.extractNewLineOffsets();
            this.compat = compat;
            this.parse();
        }

        private void appendSQL(int startPos, int endPos) {
            int i;
            if (this.statement.length() == 0) {
                for (i = startPos; i <= endPos && i < this.sql.length() && Character.isWhitespace(this.sql.charAt(i)); ++i) {
                    ++startPos;
                }
                if (startPos >= endPos) {
                    return;
                }
                this.positionMap.put(0, startPos);
                this.lastAddedEndPos = 0;
            } else if (startPos != this.lastAddedEndPos) {
                this.positionMap.put(this.statement.length(), startPos);
            }
            this.statement.append(this.sql.substring(startPos, endPos));
            this.lastAddedEndPos = endPos;
            for (i = endPos - 1; i >= startPos; --i) {
                if (Character.isWhitespace(this.sql.charAt(i))) continue;
                this.endOffset = i;
                break;
            }
        }

        private List<Integer> extractNewLineOffsets() {
            ArrayList<Integer> newlines = new ArrayList<Integer>();
            int nextNewLine = this.sql.indexOf(10);
            while (nextNewLine >= 0) {
                newlines.add(nextNewLine);
                nextNewLine = this.sql.indexOf(10, nextNewLine + 1);
            }
            return newlines;
        }

        private void parse() {
            if (this.sql.contains("\r")) {
                LOGGER.log(Level.FINE, "The SQL string contained non-supported \\r characters.");
            }
            this.rawStartOffset = 0;
            while (this.pos < this.sql.length()) {
                if (this.isDelimiter()) {
                    this.rawEndOffset = this.pos;
                    this.addStatement();
                    this.pos += this.delimiter.length();
                    this.rawStartOffset = this.pos;
                    continue;
                }
                if (this.consumeDelimiterStatement() || this.consumeCommentString() || this.consumeQuotedString()) continue;
                this.appendSQL(this.pos, this.pos + 1);
                ++this.pos;
            }
            this.rawEndOffset = this.pos;
            this.addStatement();
        }

        private boolean consumeCommentString() {
            String first = null;
            String firstTwo = null;
            if (this.pos + 1 <= this.sql.length()) {
                first = this.sql.substring(this.pos, this.pos + 1);
            }
            if (this.pos + 2 <= this.sql.length()) {
                firstTwo = this.sql.substring(this.pos, this.pos + 2);
            }
            int startPos = this.pos;
            int startLength = 0;
            String endString = null;
            if (firstTwo != null && "/*".equals(firstTwo)) {
                startLength = 2;
                endString = "*/";
            } else if (firstTwo != null && "--".equals(firstTwo)) {
                startLength = 2;
                endString = "\n";
            } else if (first != null && "#".equals(first)) {
                startLength = 1;
                if (this.compat.isUseHashComments()) {
                    endString = "\n";
                }
            }
            if (endString == null) {
                return false;
            }
            int endCandidate = this.sql.indexOf(endString, this.pos + startLength);
            this.pos = endCandidate == -1 ? this.sql.length() : endCandidate + endString.length();
            this.checkForDelimiterStmt(startPos + startLength, this.pos - endString.length() - 1);
            return true;
        }

        private boolean consumeQuotedString() {
            String ch = this.sql.substring(this.pos, this.pos + 1);
            int startPos = this.pos;
            String endString = null;
            int quoteLength = 0;
            boolean doubleEscapePossible = false;
            switch (ch) {
                case "'": {
                    quoteLength = SQL99_STRING_QUOTE.length();
                    endString = SQL99_STRING_QUOTE;
                    doubleEscapePossible = true;
                    break;
                }
                case "\"": {
                    quoteLength = SQL99_IDENTIFIER_QUOTE.length();
                    endString = SQL99_IDENTIFIER_QUOTE;
                    doubleEscapePossible = true;
                    break;
                }
                case "`": {
                    quoteLength = MYSQL_QUOTE.length();
                    endString = MYSQL_QUOTE;
                    doubleEscapePossible = true;
                    break;
                }
                case "[": {
                    quoteLength = MSSQL_BEGIN_QUOTE.length();
                    endString = MSSQL_END_QUOTE;
                    doubleEscapePossible = true;
                    break;
                }
                case "$": {
                    int nextDollar;
                    if (this.compat.isUseDollarQuotes() && (nextDollar = this.sql.indexOf(36, this.pos + 1)) >= 0) {
                        String tagWithDollar = this.sql.substring(this.pos, nextDollar + 1);
                        if (tagWithDollar.matches("\\$\\S*?\\$")) {
                            quoteLength = tagWithDollar.length();
                            endString = tagWithDollar;
                        } else {
                            return false;
                        }
                    }
                    doubleEscapePossible = false;
                }
            }
            if (endString == null) {
                return false;
            }
            do {
                int endCandidate;
                this.pos = (endCandidate = this.sql.indexOf(endString, this.pos + quoteLength)) == -1 ? this.sql.length() : endCandidate + endString.length();
            } while (doubleEscapePossible && this.pos < this.sql.length() && this.sql.startsWith(endString, this.pos));
            this.appendSQL(startPos, this.pos);
            return true;
        }

        private boolean consumeDelimiterStatement() {
            int endPos;
            if (this.pos == this.sql.length()) {
                return false;
            }
            if (!this.isToken(DELIMITER_TOKEN)) {
                return false;
            }
            if (this.statement.length() > 0) {
                return false;
            }
            int startPos = this.pos;
            int tokenLength = DELIMITER_TOKEN.length();
            this.pos += tokenLength;
            while (this.pos < this.sql.length() && Character.isWhitespace(this.sql.charAt(this.pos))) {
                ++this.pos;
            }
            for (endPos = this.pos; endPos < this.sql.length() && !Character.isWhitespace(this.sql.charAt(endPos)); ++endPos) {
            }
            if (startPos == endPos) {
                return false;
            }
            this.delimiter = this.sql.substring(this.pos, endPos);
            return true;
        }

        private void checkForDelimiterStmt(int initialOffset, int lastPosToScan) {
            int start;
            for (start = initialOffset; start < lastPosToScan && Character.isWhitespace(this.sql.charAt(start)); ++start) {
            }
            if (start >= lastPosToScan && lastPosToScan - start + 1 <= DELIMITER_TOKEN.length()) {
                return;
            }
            boolean delimiterMatched = true;
            for (int i = 0; i < DELIMITER_TOKEN.length(); ++i) {
                if (Character.toUpperCase(this.sql.charAt(start)) != Character.toUpperCase(DELIMITER_TOKEN.charAt(i))) {
                    delimiterMatched = false;
                    break;
                }
                ++start;
            }
            if (!delimiterMatched) {
                return;
            }
            while (Character.isWhitespace(this.sql.charAt(start)) && start < lastPosToScan) {
                ++start;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = start; i <= lastPosToScan && !Character.isWhitespace(this.sql.charAt(i)); ++i) {
                sb.append(this.sql.charAt(i));
            }
            if (sb.length() > 0) {
                this.delimiter = sb.toString();
            }
        }

        private boolean isDelimiter() {
            int length = this.delimiter.length();
            if (this.pos + length > this.sql.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this.delimiter.charAt(i) != this.sql.charAt(this.pos + i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean isToken(String token) {
            String substr;
            char ch = this.sql.charAt(this.pos);
            if (Character.toUpperCase(ch) != Character.toUpperCase(token.charAt(0))) {
                return false;
            }
            if (this.pos > 0 && !Character.isWhitespace(this.sql.charAt(this.pos - 1))) {
                return false;
            }
            if (this.sql.length() > this.pos + token.length() && Character.isLetterOrDigit(this.sql.charAt(this.pos + token.length()))) {
                return false;
            }
            try {
                substr = this.sql.substring(this.pos, this.pos + token.length());
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return substr.equalsIgnoreCase(token);
        }

        private void addStatement() {
            String sqlTrimmed = this.statement.toString().trim();
            this.statement.setLength(0);
            if (sqlTrimmed.length() <= 0) {
                return;
            }
            int line = 0;
            int newLinePos = -1;
            for (Integer offset : this.newLineOffsets) {
                if (offset >= this.positionMap.get(0)) break;
                ++line;
                newLinePos = offset;
            }
            StatementInfo info = new StatementInfo(sqlTrimmed, this.rawStartOffset, this.positionMap.get(0), line, this.positionMap.get(0) - newLinePos - 1, this.endOffset + 1, this.rawEndOffset, this.positionMap, this.newLineOffsets);
            this.statements.add(info);
            this.positionMap.clear();
        }

        public List<StatementInfo> getStatements() {
            return Collections.unmodifiableList(this.statements);
        }
    }
}

