/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddParameterOrLocalFix
extends JavaFix {
    private FileObject file;
    private TypeMirrorHandle type;
    private String name;
    private ElementKind kind;
    private static final Set<Tree.Kind> CAN_HOLD_VARIABLE = EnumSet.of(Tree.Kind.BLOCK, Tree.Kind.CASE);

    public AddParameterOrLocalFix(CompilationInfo info, TypeMirror type, String name, ElementKind kind, int unresolvedVariable) {
        super(info, info.getTreeUtilities().pathFor(unresolvedVariable + 1), AddParameterOrLocalFix.getSortText(kind, name));
        this.file = info.getFileObject();
        if (type.getKind() == TypeKind.NULL || type.getKind() == TypeKind.NONE) {
            TypeElement te = info.getElements().getTypeElement("java.lang.Object");
            if (te != null) {
                type = te.asType();
                this.type = TypeMirrorHandle.create((TypeMirror)type);
            } else {
                this.type = null;
            }
        } else {
            this.type = TypeMirrorHandle.create((TypeMirror)type);
        }
        this.name = name;
        this.kind = kind;
    }

    public String getText() {
        switch (this.kind) {
            case LOCAL_VARIABLE: {
                return NbBundle.getMessage(AddParameterOrLocalFix.class, (String)"LBL_FIX_Create_Local_Variable", (Object)this.name);
            }
            case PARAMETER: {
                return NbBundle.getMessage(AddParameterOrLocalFix.class, (String)"LBL_FIX_Create_Parameter", (Object)this.name);
            }
            case RESOURCE_VARIABLE: {
                return NbBundle.getMessage(AddParameterOrLocalFix.class, (String)"LBL_FIX_Create_Resource", (Object)this.name);
            }
        }
        throw new IllegalStateException(this.kind.name());
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        WorkingCopy working = ctx.getWorkingCopy();
        TypeMirror proposedType = this.type.resolve((CompilationInfo)working);
        if (proposedType == null) {
            ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
            return;
        }
        TreeMaker make = working.getTreeMaker();
        TreePath tp = ctx.getPath();
        if (tp == null || tp.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
            return;
        }
        switch (this.kind) {
            case PARAMETER: {
                ExecutableElement ee;
                TreePath targetPath = this.findMethod(tp);
                if (targetPath == null) {
                    Logger.getLogger("global").log(Level.WARNING, "Add parameter - cannot find the method.");
                    return;
                }
                MethodTree targetTree = (MethodTree)targetPath.getLeaf();
                Element el = working.getTrees().getElement(targetPath);
                if (el == null) {
                    return;
                }
                int index = targetTree.getParameters().size();
                if (el != null && (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR) && (ee = (ExecutableElement)el).isVarArgs()) {
                    index = ee.getParameters().size() - 1;
                }
                MethodTree result = make.insertMethodParameter(targetTree, index, make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)this.name, make.Type(proposedType), null));
                working.rewrite((Tree)targetTree, (Tree)result);
                break;
            }
            case LOCAL_VARIABLE: {
                if (ErrorFixesFakeHint.isCreateLocalVariableInPlace(ErrorFixesFakeHint.getPreferences(working.getFileObject(), ErrorFixesFakeHint.FixKind.CREATE_LOCAL_VARIABLE)) || Utilities.isEnhancedForLoopIdentifier(tp)) {
                    this.resolveLocalVariable(working, tp, make, proposedType);
                    break;
                }
                this.resolveLocalVariable55(working, tp, make, proposedType);
                break;
            }
            case RESOURCE_VARIABLE: {
                this.resolveResourceVariable(working, tp, make, proposedType);
                break;
            }
            default: {
                throw new IllegalStateException(this.kind.name());
            }
        }
    }

    private boolean initExpression(StatementTree statement, TreeMaker make, String name, TypeMirror proposedType, WorkingCopy wc, TreePath tp) {
        AssignmentTree at;
        ExpressionTree exp = ((ExpressionStatementTree)statement).getExpression();
        if (exp.getKind() == Tree.Kind.ASSIGNMENT && (at = (AssignmentTree)exp).getVariable().getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)at.getVariable()).getName().contentEquals(name)) {
            VariableTree vt = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(proposedType), at.getExpression());
            vt = Utilities.copyComments(wc, statement, vt);
            wc.rewrite((Tree)statement, (Tree)vt);
            return true;
        }
        return false;
    }

    private static boolean isError(CompilationInfo info, Element el) {
        if (el == null) {
            return true;
        }
        if (!el.getKind().isClass()) {
            return false;
        }
        return el.asType() == null || el.asType().getKind() == TypeKind.ERROR;
    }

    private static boolean isEnhancedForLoopVariable(TreePath tp) {
        if (tp.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        TreePath context = tp.getParentPath();
        return context != null && context.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP;
    }

    private void resolveLocalVariable55(WorkingCopy wc, TreePath tp, TreeMaker make, TypeMirror proposedType) {
        StatementTree stat;
        String name = ((IdentifierTree)tp.getLeaf()).getName().toString();
        TreePath blockPath = this.findOutmostBlock(tp);
        if (blockPath == null) {
            return;
        }
        int index = 0;
        BlockTree block = (BlockTree)blockPath.getLeaf();
        TreePath method = this.findMethod(tp);
        if (method != null && ((MethodTree)method.getLeaf()).getReturnType() == null && !block.getStatements().isEmpty() && (stat = block.getStatements().get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            Element thisMethodEl = wc.getTrees().getElement(method);
            TreePath pathToFirst = new TreePath(new TreePath(new TreePath(method, block), stat), ((ExpressionStatementTree)stat).getExpression());
            Element superCall = wc.getTrees().getElement(pathToFirst);
            if (thisMethodEl != null && superCall != null && thisMethodEl.getKind() == ElementKind.CONSTRUCTOR && superCall.getKind() == ElementKind.CONSTRUCTOR) {
                index = 1;
            }
        }
        VariableTree vt = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(proposedType), null);
        wc.rewrite((Tree)block, (Tree)wc.getTreeMaker().insertBlockStatement(block, index, (StatementTree)vt));
    }

    private void resolveLocalVariable(final WorkingCopy wc, TreePath tp, TreeMaker make, TypeMirror proposedType) {
        String name = ((IdentifierTree)tp.getLeaf()).getName().toString();
        final Element el = wc.getTrees().getElement(tp);
        if (el == null) {
            return;
        }
        TreePath blockPath = this.findOutmostBlock(tp);
        if (blockPath == null) {
            return;
        }
        class FirstUsage
        extends ErrorAwareTreePathScanner<TreePath, Void> {
            final /* synthetic */ AddParameterOrLocalFix this$0;

            FirstUsage() {
                this.this$0 = this$0;
            }

            public TreePath visitIdentifier(IdentifierTree tree, Void v) {
                if (tree.getName().contentEquals(el.getSimpleName()) && AddParameterOrLocalFix.isError((CompilationInfo)wc, wc.getTrees().getElement(this.getCurrentPath()))) {
                    return this.this$0.findStatement(this.getCurrentPath());
                }
                return null;
            }

            public TreePath visitBlock(BlockTree tree, Void v) {
                TreePath result = null;
                TreePath firstBranchStatementWithUsage = null;
                for (StatementTree statementTree : tree.getStatements()) {
                    TreePath currentResult = (TreePath)this.scan(statementTree, null);
                    if (currentResult == null) continue;
                    if (result == null) {
                        result = currentResult;
                        firstBranchStatementWithUsage = new TreePath(this.getCurrentPath(), statementTree);
                        continue;
                    }
                    result = firstBranchStatementWithUsage;
                }
                super.visitBlock(tree, (Object)v);
                return result;
            }

            public TreePath reduce(TreePath tp1, TreePath tp2) {
                if (tp2 == null) {
                    return tp1;
                }
                return tp2;
            }
        }
        FirstUsage firstUsage = new FirstUsage();
        TreePath firstUse = (TreePath)firstUsage.scan(blockPath, null);
        if (firstUse == null || !this.isStatement(firstUse.getLeaf())) {
            Logger.getLogger("global").log(Level.WARNING, "Add local variable - cannot find a statement.");
            return;
        }
        while (firstUse.getParentPath() != null && !CAN_HOLD_VARIABLE.contains((Object)firstUse.getParentPath().getLeaf().getKind())) {
            firstUse = firstUse.getParentPath();
        }
        if (firstUse.getParentPath() == null) {
            Logger.getLogger("global").log(Level.WARNING, "Add local variable - cannot find a statement.");
            return;
        }
        StatementTree statement = (StatementTree)firstUse.getLeaf();
        if (statement.getKind() == Tree.Kind.EXPRESSION_STATEMENT && this.initExpression(statement, make, name, proposedType, wc, tp)) {
            return;
        }
        Tree statementParent = firstUse.getParentPath().getLeaf();
        VariableTree vt = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(proposedType), null);
        if (Utilities.isEnhancedForLoopIdentifier(tp)) {
            wc.rewrite(tp.getParentPath().getLeaf(), (Tree)vt);
        } else if (AddParameterOrLocalFix.isEnhancedForLoopVariable(firstUse)) {
            wc.rewrite(firstUse.getLeaf(), (Tree)vt);
        } else if (statementParent.getKind() == Tree.Kind.BLOCK) {
            BlockTree block = (BlockTree)statementParent;
            FirstUsage fu = new FirstUsage();
            TreePath result = (TreePath)fu.scan(firstUse, null);
            if (result == null || !this.isStatement(result.getLeaf())) {
                Logger.getLogger("global").log(Level.WARNING, "Add local variable - cannot find a statement inside nested block");
                return;
            }
            Tree resultLeaf = result.getLeaf();
            if (resultLeaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && result.getParentPath().getLeaf().getKind() == Tree.Kind.BLOCK) {
                if (this.findBlock(result).getLeaf().equals(this.findBlock(tp).getLeaf()) && this.initExpression((StatementTree)result.getLeaf(), make, name, proposedType, wc, tp)) {
                    return;
                }
                if (!this.isParent(result, tp) && !this.isParent(tp, result) && this.initExpression((StatementTree)tp.getParentPath().getParentPath().getLeaf(), make, name, proposedType, wc, tp)) {
                    return;
                }
            }
            if (result.getParentPath().getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP && resultLeaf.getKind() == Tree.Kind.VARIABLE) {
                wc.rewrite(resultLeaf, (Tree)vt);
                return;
            }
            BlockTree nueBlock = make.insertBlockStatement(block, block.getStatements().indexOf(statement), (StatementTree)vt);
            wc.rewrite((Tree)block, (Tree)nueBlock);
        } else {
            BlockTree block = make.Block(Arrays.asList(vt, statement), false);
            wc.rewrite((Tree)statement, (Tree)block);
        }
    }

    private void resolveResourceVariable(WorkingCopy wc, TreePath tp, TreeMaker make, TypeMirror proposedType) {
        String name = ((IdentifierTree)tp.getLeaf()).getName().toString();
        Element el = wc.getTrees().getElement(tp);
        if (el == null) {
            return;
        }
        if (tp.getParentPath().getLeaf().getKind() != Tree.Kind.ASSIGNMENT) {
            return;
        }
        AssignmentTree at = (AssignmentTree)tp.getParentPath().getLeaf();
        VariableTree vt = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(proposedType), at.getExpression());
        wc.rewrite((Tree)at, (Tree)vt);
    }

    private TreePath findStatement(TreePath tp) {
        TreePath statement = tp;
        while (statement.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (this.isStatement(statement.getLeaf())) {
                return statement;
            }
            statement = statement.getParentPath();
        }
        return null;
    }

    private TreePath findMethod(TreePath tp) {
        for (TreePath method = tp; method != null; method = method.getParentPath()) {
            if (method.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            return method;
        }
        return null;
    }

    private TreePath findOutmostBlock(TreePath tp) {
        TreePath block = null;
        while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            if (tp.getLeaf().getKind() == Tree.Kind.BLOCK) {
                block = tp;
            }
            tp = tp.getParentPath();
        }
        return block;
    }

    private boolean isParent(TreePath parent, TreePath son) {
        TreePath parentBlock = this.findBlock(parent);
        for (TreePath block = son; block != null; block = block.getParentPath()) {
            if (block.getLeaf().getKind() != Tree.Kind.BLOCK || !block.getLeaf().equals(parentBlock.getLeaf())) continue;
            return true;
        }
        return false;
    }

    private TreePath findBlock(TreePath tp) {
        for (TreePath block = tp; block != null; block = block.getParentPath()) {
            if (block.getLeaf().getKind() != Tree.Kind.BLOCK) continue;
            return block;
        }
        return null;
    }

    private boolean isStatement(Tree t) {
        Class<? extends Tree> intClass = t.getKind().asInterface();
        return StatementTree.class.isAssignableFrom(intClass);
    }

    String toDebugString(CompilationInfo info) {
        return "AddParameterOrLocalFix:" + this.name + ":" + this.type.resolve(info).toString() + ":" + this.kind.name();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AddParameterOrLocalFix other = (AddParameterOrLocalFix)((Object)obj);
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        return this.kind == other.kind;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + (this.kind != null ? this.kind.hashCode() : 0);
        return hash;
    }

    private static String getSortText(ElementKind kind, String name) {
        switch (kind) {
            case PARAMETER: {
                return "Create 7000 " + name;
            }
            case LOCAL_VARIABLE: {
                return "Create 5000 " + name;
            }
            case RESOURCE_VARIABLE: {
                return "Create 3000 " + name;
            }
        }
        throw new IllegalStateException();
    }
}

