/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.table;

import java.util.LinkedList;
import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import nu.validator.checker.table.Table;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class TableChecker
extends Checker {
    private static final int MAX_COLSPAN = 1000;
    private Table current;
    private final LinkedList<Table> stack = new LinkedList();

    private void push() {
        if (this.current != null) {
            this.stack.addLast(this.current);
        }
        this.current = new Table(this);
    }

    private void pop() throws SAXException {
        if (this.current == null) {
            throw new IllegalStateException("Bug!");
        }
        this.current.end();
        this.current = this.stack.isEmpty() ? null : this.stack.removeLast();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml".equals(uri)) {
            if ("table".equals(localName)) {
                this.push();
            } else if (this.current != null) {
                if ("td".equals(localName)) {
                    this.current.startCell(false, atts);
                } else if ("th".equals(localName)) {
                    this.current.startCell(true, atts);
                } else if ("tr".equals(localName)) {
                    this.current.startRow();
                } else if ("tbody".equals(localName) || "thead".equals(localName) || "tfoot".equals(localName)) {
                    this.current.startRowGroup(localName);
                } else if ("col".equals(localName)) {
                    this.current.startCol(this.clampSpan(atts));
                } else if ("colgroup".equals(localName)) {
                    this.current.startColGroup(this.clampSpan(atts));
                }
            }
        }
    }

    public int clampSpan(Attributes atts) throws SAXException {
        int span = AttributeUtil.parseNonNegativeInteger(atts.getValue("", "span"));
        if (span > 1000) {
            this.err("The value of the \u201cspan\u201d attribute must be less than or equal to 1000.");
            span = 1000;
        }
        return span;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/1999/xhtml".equals(uri)) {
            if ("table".equals(localName)) {
                this.pop();
            } else if (this.current != null) {
                if ("td".equals(localName)) {
                    this.current.endCell();
                } else if ("th".equals(localName)) {
                    this.current.endCell();
                } else if ("tr".equals(localName)) {
                    this.current.endRow();
                } else if ("tbody".equals(localName) || "thead".equals(localName) || "tfoot".equals(localName)) {
                    this.current.endRowGroup();
                } else if ("col".equals(localName)) {
                    this.current.endCol();
                } else if ("colgroup".equals(localName)) {
                    this.current.endColGroup();
                }
            }
        }
    }

    @Override
    public void reset() {
        this.stack.clear();
        this.current = null;
    }
}

