/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.TestURL;
import io.mola.galimatias.URL;
import io.mola.galimatias.canonicalize.RFC2396Canonicalizer;
import io.mola.galimatias.canonicalize.RFC3986Canonicalizer;
import org.fest.assertions.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class RFC3986CanonicalizerTest {
    @Test
    public void test() throws GalimatiasParseException {
        RFC3986Canonicalizer canon = new RFC3986Canonicalizer();
        for (String[] pair : new String[][]{{"http://example.com/^{}|[]`~", "http://example.com/%5E%7B%7D%7C%5B%5D%60~"}, {"http://example.com/?^{}|[]`~", "http://example.com/?%5E%7B%7D%7C%5B%5D%60~"}, {"http://example.com/#^{}|[]`~", "http://example.com/#%5E%7B%7D%7C%5B%5D%60~"}}) {
            Assertions.assertThat((String)canon.canonicalize(URL.parse(pair[0])).toString()).isEqualTo((Object)URL.parse(pair[1]).toString());
        }
    }

    @Theory
    public void idempotence(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        RFC2396Canonicalizer canon = new RFC2396Canonicalizer();
        URL roundOne = canon.canonicalize(testURL.parsedURL);
        URL roundTwo = canon.canonicalize(roundOne);
        Assertions.assertThat((Object)roundOne).isEqualTo((Object)roundTwo);
        URL reparse = URL.parse(roundTwo.toString());
        Assertions.assertThat((Object)reparse).isEqualTo((Object)roundTwo);
    }
}

