/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.options;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.Annotator;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.options.Bundle;
import org.netbeans.modules.git.options.GitOptionsPanel;
import org.netbeans.modules.git.options.LabelsPanel;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

final class GitOptionsPanelController
extends OptionsPanelController
implements VCSOptionsKeywordsProvider,
ActionListener,
DocumentListener {
    private GitOptionsPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean changed;

    public void update() {
        this.load();
        this.changed = false;
    }

    public void applyChanges() {
        if (!this.validateFields().booleanValue()) {
            return;
        }
        this.store();
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.git.options.GitOptionsPanelController");
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public boolean acceptKeywords(List<String> keywords) {
        HashSet<String> allKeywords = new HashSet<String>(this.panel.getKeywords());
        allKeywords.retainAll(keywords);
        return !allKeywords.isEmpty();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.btnAddVariable) {
            this.onAddClick();
        } else {
            this.changed();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private Boolean validateFields() {
        return true;
    }

    private GitOptionsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new GitOptionsPanel();
            this.panel.btnAddVariable.addActionListener(this);
            this.panel.cbIgnoreNotSharableFiles.addActionListener(this);
            this.panel.cbOpenOutputWindow.addActionListener(this);
            this.panel.excludeNewFiles.addActionListener(this);
            this.panel.signOffCheckBox.addActionListener(this);
            this.panel.cbReplaceInvalidBranchNameCharacters.addActionListener(this);
            this.panel.txtProjectAnnotation.setText(GitModuleConfig.getDefault().getProjectAnnotationFormat());
            this.panel.txtProjectAnnotation.getDocument().addDocumentListener(this);
        }
        return this.panel;
    }

    private void changed() {
        this.fireChanged();
        if (!this.changed) {
            this.pcs.firePropertyChange("changed", false, true);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }

    private void load() {
        this.getPanel();
        this.panel.cbOpenOutputWindow.setSelected(GitModuleConfig.getDefault().getAutoOpenOutput());
        this.panel.cbReplaceInvalidBranchNameCharacters.setSelected(GitModuleConfig.getDefault().getAutoReplaceInvalidBranchNameCharacters());
        this.panel.excludeNewFiles.setSelected(GitModuleConfig.getDefault().getExludeNewFiles());
        this.panel.signOffCheckBox.setSelected(GitModuleConfig.getDefault().getSignOff());
        this.panel.cbIgnoreNotSharableFiles.setSelected(GitModuleConfig.getDefault().getAutoIgnoreFiles());
        this.panel.txtProjectAnnotation.setText(GitModuleConfig.getDefault().getProjectAnnotationFormat());
    }

    private void store() {
        this.getPanel();
        GitModuleConfig.getDefault().setAutoOpenOutput(this.panel.cbOpenOutputWindow.isSelected());
        GitModuleConfig.getDefault().setAutoReplaceInvalidBranchNameCharacters(this.panel.cbReplaceInvalidBranchNameCharacters.isSelected());
        GitModuleConfig.getDefault().setExcludeNewFiles(this.panel.excludeNewFiles.isSelected());
        GitModuleConfig.getDefault().setSignOff(this.panel.signOffCheckBox.isSelected());
        GitModuleConfig.getDefault().setAutoIgnoreFiles(this.panel.cbIgnoreNotSharableFiles.isSelected());
        GitModuleConfig.getDefault().setProjectAnnotationFormat(this.panel.txtProjectAnnotation.getText());
        Git.getInstance().getVCSAnnotator().refreshFormat();
    }

    private void fireChanged() {
        this.changed = GitModuleConfig.getDefault().getAutoOpenOutput() != this.panel.cbOpenOutputWindow.isSelected() || GitModuleConfig.getDefault().getAutoReplaceInvalidBranchNameCharacters() != this.panel.cbReplaceInvalidBranchNameCharacters.isSelected() || GitModuleConfig.getDefault().getExludeNewFiles() != this.panel.excludeNewFiles.isSelected() || GitModuleConfig.getDefault().getSignOff() != this.panel.signOffCheckBox.isSelected() || GitModuleConfig.getDefault().getAutoIgnoreFiles() != this.panel.cbIgnoreNotSharableFiles.isSelected() || !GitModuleConfig.getDefault().getProjectAnnotationFormat().equals(this.panel.txtProjectAnnotation.getText());
    }

    private void onAddClick() {
        this.getPanel();
        LabelsPanel labelsPanel = new LabelsPanel();
        Annotator.LabelVariable[] variables = Git.getInstance().getVCSAnnotator().getProjectVariables();
        labelsPanel.labelsList.setListData(variables);
        String title = Bundle.GitOptionsPanel_labelVariables_title();
        String acsd = Bundle.GitOptionsPanel_labelVariables_acsd();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, title, true, 2, DialogDescriptor.OK_OPTION, null);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ GitOptionsPanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION == dialogDescriptor.getValue()) {
            Object[] selection = labelsPanel.labelsList.getSelectedValues();
            Object variable = "";
            for (Object o : selection) {
                variable = (String)variable + ((Annotator.LabelVariable)o).getPattern();
            }
            String annotation = this.panel.txtProjectAnnotation.getText();
            int pos = this.panel.txtProjectAnnotation.getCaretPosition();
            if (pos < 0) {
                pos = annotation.length();
            }
            StringBuilder sb = new StringBuilder(annotation.length() + ((String)variable).length());
            sb.append(annotation.substring(0, pos));
            sb.append((String)variable);
            if (pos < annotation.length()) {
                sb.append(annotation.substring(pos));
            }
            this.panel.txtProjectAnnotation.setText(sb.toString());
            this.panel.txtProjectAnnotation.requestFocus();
            this.panel.txtProjectAnnotation.setCaretPosition(pos + ((String)variable).length());
        }
    }
}

