/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ExportUncommittedChangesAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.exportDiff(repository, roots, GitClient.DiffMode.HEAD_VS_WORKINGTREE);
    }

    void exportDiff(final Node[] selectedNodes, final GitClient.DiffMode diffMode) {
        Utils.postParallel((Runnable)new Runnable(){
            final /* synthetic */ ExportUncommittedChangesAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                VCSContext context = this.this$0.getCurrentContext(selectedNodes);
                Map.Entry actionRoots = ExportUncommittedChangesAction.getActionRoots(context);
                if (actionRoots != null) {
                    this.this$0.exportDiff((File)actionRoots.getKey(), (File[])actionRoots.getValue(), diffMode);
                }
            }
        }, (int)0);
    }

    private void exportDiff(final File repository, final File[] roots, final GitClient.DiffMode diffMode) {
        File[] files;
        if (roots.length == 0 || (files = Git.getInstance().getFileStatusCache().listFiles(new HashSet<File>(Arrays.asList(roots)), this.diffModeToStatusSet(diffMode))).length == 0) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportUncommittedChangesAction.emptyContext"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ ExportUncommittedChangesAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                new ExportDiffSupport(this, roots, GitModuleConfig.getDefault().getPreferences()){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(files2, preferences);
                    }

                    public void writeDiffFile(final File toFile) {
                        ExportUncommittedChangesAction.saveFolderToPrefs(toFile);
                        GitProgressSupport ps = new GitProgressSupport(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void perform() {
                                boolean success = false;
                                OutputStream out = null;
                                OutputLogger logger = this.getLogger();
                                try {
                                    GitClient client = this.getClient();
                                    ExportUncommittedChangesAction.ensureParentExists(toFile);
                                    out = new BufferedOutputStream(new FileOutputStream(toFile));
                                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(roots));
                                    this.setProgress(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportUncommittedChangesAction.preparingDiff"));
                                    client.exportDiff(files, diffMode, out, this.getProgressMonitor());
                                    if (!this.isCanceled()) {
                                        success = true;
                                    }
                                }
                                catch (Exception ex) {
                                    logger.outputInRed(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportUncommittedChangesAction.failed"));
                                    GitClientExceptionHandler.notifyException(ex, true);
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.flush();
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (success && toFile.length() > 0L) {
                                        Utils.openFile((File)toFile);
                                    } else {
                                        toFile.delete();
                                    }
                                }
                            }
                        };
                        ps.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"LBL_ExportUncommittedChangesAction_Progress")).waitFinished();
                    }
                }.export();
            }
        });
    }

    static void saveFolderToPrefs(File file) {
        if (file.getParent() != null) {
            GitModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file.getParent());
        }
    }

    private static void ensureParentExists(File destination) {
        File parent = destination.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    private EnumSet<FileInformation.Status> diffModeToStatusSet(GitClient.DiffMode diffMode) {
        switch (diffMode) {
            case HEAD_VS_WORKINGTREE: {
                return FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING;
            }
            case HEAD_VS_INDEX: {
                return FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX;
            }
            case INDEX_VS_WORKINGTREE: {
                return FileInformation.STATUS_MODIFIED_INDEX_VS_WORKING;
            }
        }
        throw new IllegalArgumentException("Unknown diff mode " + String.valueOf(diffMode));
    }
}

