/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.status.GitVersioningTopComponent;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class StatusAction
extends GitAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/show_changes.png";

    public StatusAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected final void performContextAction(Node[] nodes) {
        VCSContext context = this.getCurrentContext(nodes);
        this.performContextAction(context);
    }

    public void performContextAction(VCSContext context) {
        GitVersioningTopComponent stc = GitVersioningTopComponent.findInstance();
        stc.setContentTitle(Utils.getContextDisplayName((VCSContext)context));
        stc.setContext(context);
        stc.open();
        stc.requestActive();
    }

    public final GitProgressSupport scanStatus(VCSContext context) {
        Set<File> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            return null;
        }
        final HashMap<File, List<File>> toRefresh = new HashMap<File, List<File>>(repositories.size());
        for (File repository : repositories) {
            GitUtils.logRemoteRepositoryAccess(repository);
            toRefresh.put(repository, Arrays.asList(GitUtils.filterForRepository(context, repository)));
        }
        GitProgressSupport supp = new GitProgressSupport(this){
            final /* synthetic */ StatusAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void perform() {
                long t = 0L;
                if (Git.STATUS_LOG.isLoggable(Level.FINE)) {
                    t = System.currentTimeMillis();
                    Git.STATUS_LOG.log(Level.FINE, "StatusAction.scanStatus(): started for {0}", toRefresh.keySet());
                }
                Git.getInstance().getFileStatusCache().refreshAllRoots(toRefresh, this.getProgressMonitor());
                if (Git.STATUS_LOG.isLoggable(Level.FINE)) {
                    Git.STATUS_LOG.log(Level.FINE, "StatusAction.scanStatus(): lasted {0}", System.currentTimeMillis() - t);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(), null, NbBundle.getMessage(StatusAction.class, (String)"LBL_ScanningStatuses"));
        return supp;
    }
}

