/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public class ResultSetTableCellEditor
extends DefaultCellEditor {
    protected Object val;
    protected JTable table;
    protected static final boolean suppressEditorBorder;

    public ResultSetTableCellEditor(final JTextField textField) {
        super(textField);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            final /* synthetic */ ResultSetTableCellEditor this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public void setValue(Object value) {
                this.this$0.val = value;
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                String txtVal = textField.getText();
                if (this.this$0.val == null && txtVal.equals("")) {
                    return null;
                }
                return txtVal;
            }
        };
        textField.addActionListener(this.delegate);
        textField.setCaret(new DefaultCaret());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (DataViewUtils.isSQLConstantString(value, null)) {
            value = "";
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public ResultSetTableCellEditor(final JCheckBox checkBox) {
        super(checkBox);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            final /* synthetic */ ResultSetTableCellEditor this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public void setValue(Object value) {
                this.this$0.val = value;
                checkBox.setSelected(value instanceof Boolean ? (Boolean)value : false);
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                Boolean bolVal = checkBox.isSelected();
                if (this.this$0.val == null && !checkBox.isSelected()) {
                    return null;
                }
                return bolVal;
            }
        };
        checkBox.addActionListener(this.delegate);
    }

    static {
        boolean suppressBorder = false;
        suppressBorder |= "GTK".equals(UIManager.getLookAndFeel().getID());
        suppressEditorBorder = suppressBorder |= "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }
}

