/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.InvalidFormatException;
import oracle.security.pki.util.Utils;

public class ASN1ObjectID
implements ASN1TaggedObject {
    private ASN1Header a;
    private int[] b;
    private byte[] c;
    private int d;

    public ASN1ObjectID(int[] nArray) {
        this.b(nArray);
    }

    public ASN1ObjectID(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1ObjectID(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        this.b(nArray3);
    }

    public ASN1ObjectID(ASN1ObjectID aSN1ObjectID, int[] nArray) {
        this(aSN1ObjectID.b(), nArray);
    }

    public ASN1ObjectID(ASN1ObjectID aSN1ObjectID, int n) {
        this(aSN1ObjectID.b(), n);
    }

    public ASN1ObjectID(int[] nArray, int n) {
        this(nArray, new int[]{n});
    }

    public ASN1ObjectID(int[] nArray, int n, int n2) {
        this(nArray, new int[]{n, n2});
    }

    public ASN1ObjectID(int[] nArray, int n, int n2, int n3) {
        this(nArray, new int[]{n, n2, n3});
    }

    public ASN1ObjectID(int[] nArray, int n, int n2, int n3, int n4) {
        this(nArray, new int[]{n, n2, n3, n4});
    }

    public ASN1ObjectID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        try {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException(numberFormatException.toString());
        }
        this.b(nArray);
    }

    private void b(int[] nArray) {
        this.b = nArray;
        this.c = ASN1ObjectID.c(nArray);
        this.a = new ASN1Header(6, 0, 0, this.c.length);
        this.d = -1;
    }

    @Override
    public ASN1Header a() {
        return this.a;
    }

    public int[] b() {
        return this.b;
    }

    public byte[] c() {
        return this.c;
    }

    public int[] a(int[] nArray) {
        int[] nArray2 = this.b();
        if (ASN1Utils.a(nArray, nArray2)) {
            int[] nArray3 = new int[nArray2.length - nArray.length];
            System.arraycopy(nArray2, nArray.length, nArray3, 0, nArray3.length);
            return nArray3;
        }
        return null;
    }

    public boolean a(ASN1ObjectID aSN1ObjectID) {
        if (this == aSN1ObjectID) {
            return true;
        }
        if (aSN1ObjectID == null) {
            return false;
        }
        return Utils.areEqual(this.c, aSN1ObjectID.c());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return Utils.areEqual(this.c, ((ASN1ObjectID)object).c());
    }

    public boolean a(int[] nArray, int[] nArray2) {
        return this.equals(new ASN1ObjectID(nArray, nArray2));
    }

    public boolean a(int[] nArray, int n) {
        return this.a(nArray, new int[]{n});
    }

    public boolean a(int[] nArray, int n, int n2) {
        return this.a(nArray, new int[]{n, n2});
    }

    public boolean a(int[] nArray, int n, int n2, int n3) {
        return this.a(nArray, new int[]{n, n2, n3});
    }

    public boolean a(int[] nArray, int n, int n2, int n3, int n4) {
        return this.a(nArray, new int[]{n, n2, n3, n4});
    }

    public int hashCode() {
        if (this.d == -1) {
            this.d = new String(this.c).hashCode();
        }
        return this.d;
    }

    public String toString() {
        int[] nArray = this.b();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OBJECT IDENTIFIER {");
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= n - 1) continue;
            stringBuffer.append(".");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String d() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.b.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(this.b[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.b(ASN1ObjectID.a(inputStream));
    }

    public static int[] a(InputStream inputStream) throws IOException {
        return ASN1ObjectID.a(ASN1ObjectID.b(inputStream));
    }

    private static byte[] b(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.d(0);
        aSN1Header.e(6);
        aSN1Header.f(0);
        return aSN1Header.d(inputStream);
    }

    public static int[] a(byte[] byArray) throws IOException {
        int[] nArray;
        int[] nArray2 = new int[10];
        int n = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n2 = Utils.inputByte(byteArrayInputStream) & 0xFF;
        if (n2 < 80) {
            nArray2[n++] = n2 / 40;
            nArray2[n++] = n2 % 40;
        } else {
            nArray2[n++] = 2;
            nArray2[n++] = n2 - 80;
        }
        while (byteArrayInputStream.available() > 0) {
            if (n >= nArray2.length) {
                nArray = new int[2 * nArray2.length];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray2 = nArray;
            }
            nArray2[n++] = ASN1Utils.b(byteArrayInputStream);
        }
        if (n < nArray2.length) {
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
            nArray2 = nArray;
        }
        return nArray2;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        ASN1ObjectID.b(outputStream, this.b());
    }

    @Override
    public int length() {
        return this.a.g();
    }

    private static byte[] c(int[] nArray) {
        byte[] byArray = new byte[ASN1ObjectID.d(nArray)];
        byArray[0] = (byte)(40 * nArray[0] + nArray[1]);
        int n = 1;
        int n2 = nArray.length;
        for (int i = 2; i < n2; ++i) {
            byte[] byArray2 = ASN1Utils.a(nArray[i]);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray;
    }

    public static void a(OutputStream outputStream, int[] nArray) throws IOException {
        ASN1ObjectID.a(outputStream, nArray, 6, 0);
    }

    public static void a(OutputStream outputStream, int[] nArray, int n) throws IOException {
        ASN1ObjectID.a(outputStream, nArray, n, 128);
    }

    private static int d(int[] nArray) {
        int n = 1;
        int n2 = nArray.length;
        for (int i = 2; i < n2; ++i) {
            n += ASN1Utils.b(nArray[i]);
        }
        return n;
    }

    private static void a(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.a(outputStream, ASN1ObjectID.d(nArray));
        ASN1ObjectID.b(outputStream, nArray);
    }

    private static void b(OutputStream outputStream, int[] nArray) throws IOException {
        outputStream.write(40 * nArray[0] + nArray[1]);
        int n = nArray.length;
        for (int i = 2; i < n; ++i) {
            ASN1Utils.a(nArray[i], outputStream);
        }
    }
}

