/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;

public abstract class TimeConfiguration
implements Writeable,
ToXContentObject {
    public static final String PERIOD_FIELD = "period";
    public static final String INTERVAL_FIELD = "interval";
    public static final String UNIT_FIELD = "unit";

    public static TimeConfiguration parse(XContentParser parser) throws IOException {
        long interval = 0L;
        ChronoUnit unit = null;
        String scheduleType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            scheduleType = parser.currentName();
            parser.nextToken();
            switch (scheduleType) {
                case "period": {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String periodFieldName = parser.currentName();
                        parser.nextToken();
                        switch (periodFieldName) {
                            case "interval": {
                                interval = parser.longValue();
                                break;
                            }
                            case "unit": {
                                unit = ChronoUnit.valueOf(parser.text().toUpperCase(Locale.ROOT));
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        if (PERIOD_FIELD.equals(scheduleType)) {
            return new IntervalTimeConfiguration(interval, unit);
        }
        throw new IllegalArgumentException("Find no schedule definition");
    }
}

