"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    commentsService
  } = services;
  router.post({
    path: '/api/alerting/comments/_search',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.searchComments);
  router.post({
    path: '/api/alerting/comments/{alertId}',
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        alertId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.createComment);
  router.put({
    path: '/api/alerting/comments/{commentId}',
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        commentId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.updateComment);
  router.delete({
    path: '/api/alerting/comments/{commentId}',
    validate: {
      params: _configSchema.schema.object({
        commentId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, commentsService.deleteComment);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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