"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TITLES = exports.TRACE_TABLE_OPTIONS = exports.TRACE_SERVICE_MAP_MAX_NODES = exports.TRACE_SERVICE_MAP_MAX_EDGES = exports.TRACE_LOGS_FIELD_MAPPNIGS_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CORRELATED_LOGS_INDEX_SETTING = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACES_MAX_NUM = exports.JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_INDEX_NAME = exports.DEFAULT_SS4O_LOGS_INDEX = exports.DEFAULT_SERVICE_MAP_MAX_NODES = exports.DEFAULT_SERVICE_MAP_MAX_EDGES = exports.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = exports.DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const JAEGER_INDEX_NAME = exports.JAEGER_INDEX_NAME = '*jaeger-span-*';
const JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_SERVICE_INDEX_NAME = '*jaeger-service*';
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'otel-v1-apm-span-*';
const DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = 'otel-v1-apm-service-map*';
const TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATE_FORMAT = 'MM/DD/YYYY HH:mm:ss.SSS';
const TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = 'MMM D, YYYY HH:mm:ss.SSS';
const TRACES_MAX_NUM = exports.TRACES_MAX_NUM = 500;
const TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = 'https://opensearch.org/docs/latest/observability-plugin/trace/index/';
const TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = '/api/observability/trace_analytics/jaeger_indices';
const TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/trace_analytics/data_prepper_indices';
const TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = '/api/observability/trace_analytics/query';
const TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = 'observability:traceAnalyticsSpanIndices';
const TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = 'observability:traceAnalyticsServiceIndices';
const TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = 'observability:traceAnalyticsCustomModeDefault';
const TRACE_CORRELATED_LOGS_INDEX_SETTING = exports.TRACE_CORRELATED_LOGS_INDEX_SETTING = 'observability:traceAnalyticsCorrelatedLogsIndices';
const TRACE_LOGS_FIELD_MAPPNIGS_SETTING = exports.TRACE_LOGS_FIELD_MAPPNIGS_SETTING = 'observability:traceAnalyticsCorrelatedLogsFieldMappings';
const TRACE_SERVICE_MAP_MAX_NODES = exports.TRACE_SERVICE_MAP_MAX_NODES = 'observability:traceAnalyticsServiceMapMaxNodes';
const TRACE_SERVICE_MAP_MAX_EDGES = exports.TRACE_SERVICE_MAP_MAX_EDGES = 'observability:traceAnalyticsServiceMapMaxEdges';
const DEFAULT_SS4O_LOGS_INDEX = exports.DEFAULT_SS4O_LOGS_INDEX = 'ss4o_logs-*';
const DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = exports.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = `
{
  "serviceName": "serviceName",
  "spanId": "spanId",
  "timestamp": "time",
  "traceId": "traceId"
}`;
const DEFAULT_SERVICE_MAP_MAX_NODES = exports.DEFAULT_SERVICE_MAP_MAX_NODES = 500;
const DEFAULT_SERVICE_MAP_MAX_EDGES = exports.DEFAULT_SERVICE_MAP_MAX_EDGES = 1000;
let TRACE_TABLE_TITLES = exports.TRACE_TABLE_TITLES = /*#__PURE__*/function (TRACE_TABLE_TITLES) {
  TRACE_TABLE_TITLES["all_spans"] = "All Spans";
  TRACE_TABLE_TITLES["root_spans"] = "Root Spans";
  TRACE_TABLE_TITLES["entry_spans"] = "Service Entry Spans";
  TRACE_TABLE_TITLES["traces"] = "Traces";
  return TRACE_TABLE_TITLES;
}({});
const getDescription = key => {
  const descriptions = {
    all_spans: 'Spans representing all activities in all traces across the system',
    root_spans: 'Spans marking the root or starting point of each trace',
    entry_spans: 'Spans that indicate the entry point of service-side processing',
    traces: 'Spans grouped by traceId to show a complete trace lifecycle'
  };
  return descriptions[key];
};
const TRACE_TABLE_OPTIONS = exports.TRACE_TABLE_OPTIONS = Object.entries(TRACE_TABLE_TITLES).map(([key, label]) => ({
  label,
  key,
  'aria-describedby': getDescription(key)
}));
const TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TYPE_KEY = 'TraceAnalyticsTraceTableType';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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