/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xypoint;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MapXContentParser;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentSubParser;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geospatial.index.mapper.xypoint.XYPoint;

public class XYPointParser {
    private static final String ERR_MSG_INVALID_TOKEN = "token [{}] not allowed";
    private static final String ERR_MSG_INVALID_FIELDS = "field must be either [x|y], or [type|coordinates]";
    private static final String X_PARAMETER = "x";
    private static final String Y_PARAMETER = "y";
    public static final String GEOJSON_TYPE = "type";
    public static final String GEOJSON_COORDS = "coordinates";
    private static final String NULL_VALUE_PARAMETER = "null_value";
    private static final Boolean TRUE = true;

    public static XYPoint parseXYPoint(Object value, boolean ignoreZValue) throws OpenSearchParseException {
        XYPoint xYPoint;
        Objects.requireNonNull(value, "input value which needs to be parsed should not be null");
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap(NULL_VALUE_PARAMETER, value), null);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            xYPoint = XYPointParser.parseXYPoint((XContentParser)parser, ignoreZValue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new OpenSearchParseException("error parsing xy_point", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return xYPoint;
    }

    public static XYPoint parseXYPoint(XContentParser parser, boolean ignoreZValue) throws IOException, OpenSearchParseException {
        Objects.requireNonNull(parser, "parser should not be null");
        XYPoint point = new XYPoint();
        switch (parser.currentToken()) {
            case START_OBJECT: {
                XYPointParser.parseXYPointObject(parser, point, ignoreZValue);
                break;
            }
            case START_ARRAY: {
                XYPointParser.parseXYPointArray(parser, point, ignoreZValue);
                break;
            }
            case VALUE_STRING: {
                String val = parser.text();
                point.resetFromString(val, ignoreZValue);
                break;
            }
            default: {
                throw new OpenSearchParseException("expecting xy_point as an array, a string, or an object format", new Object[0]);
            }
        }
        return point;
    }

    private static XYPoint parseXYPointObject(XContentParser parser, XYPoint point, boolean ignoreZValue) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            if (subParser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new OpenSearchParseException(ERR_MSG_INVALID_TOKEN, new Object[]{subParser.currentToken()});
            }
            String field = subParser.currentName();
            if (X_PARAMETER.equals(field) || Y_PARAMETER.equals(field)) {
                XYPointParser.parseXYPointObjectBasicFields((XContentParser)subParser, point);
            } else if (GEOJSON_TYPE.equals(field) || GEOJSON_COORDS.equals(field)) {
                XYPointParser.parseGeoJsonFields((XContentParser)subParser, point, ignoreZValue);
            } else {
                throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            if (subParser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            XYPoint xYPoint = point;
            return xYPoint;
        }
    }

    private static XYPoint parseXYPointObjectBasicFields(XContentParser parser, XYPoint point) throws IOException {
        int numberOfFields = 2;
        HashMap<String, Double> data = new HashMap<String, Double>();
        block5: for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) break;
            String field = parser.currentName();
            if (!X_PARAMETER.equals(field) && !Y_PARAMETER.equals(field)) {
                throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            switch (parser.nextToken()) {
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    try {
                        data.put(field, parser.doubleValue(true));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                        throw new OpenSearchParseException("[{}] and [{}] must be valid double values", (Throwable)e, new Object[]{X_PARAMETER, Y_PARAMETER});
                    }
                }
                default: {
                    throw new OpenSearchParseException("{} must be a number", new Object[]{field});
                }
            }
        }
        if (data.get(X_PARAMETER) == null) {
            throw new OpenSearchParseException("field [{}] missing", new Object[]{X_PARAMETER});
        }
        if (data.get(Y_PARAMETER) == null) {
            throw new OpenSearchParseException("field [{}] missing", new Object[]{Y_PARAMETER});
        }
        return point.reset((Double)data.get(X_PARAMETER), (Double)data.get(Y_PARAMETER));
    }

    private static XYPoint parseGeoJsonFields(XContentParser parser, XYPoint point, boolean ignoreZValue) throws IOException {
        int numberOfFields = 2;
        boolean hasTypePoint = false;
        boolean hasCoordinates = false;
        for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                if (!hasTypePoint) {
                    throw new OpenSearchParseException("field [{}] missing", new Object[]{GEOJSON_TYPE});
                }
                if (!hasCoordinates) {
                    throw new OpenSearchParseException("field [{}] missing", new Object[]{GEOJSON_COORDS});
                }
            }
            if (GEOJSON_TYPE.equals(parser.currentName())) {
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new OpenSearchParseException("{} must be a string", new Object[]{GEOJSON_TYPE});
                }
                if (!ShapeType.POINT.name().equalsIgnoreCase(parser.text())) {
                    throw new OpenSearchParseException("{} must be Point", new Object[]{GEOJSON_TYPE});
                }
                hasTypePoint = true;
                continue;
            }
            if (GEOJSON_COORDS.equals(parser.currentName())) {
                if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                    throw new OpenSearchParseException("{} must be an array", new Object[]{GEOJSON_COORDS});
                }
                XYPointParser.parseXYPointArray(parser, point, ignoreZValue);
                hasCoordinates = true;
                continue;
            }
            throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
        }
        return point;
    }

    private static XYPoint parseXYPointArray(XContentParser parser, XYPoint point, boolean ignoreZValue) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            double x = Double.NaN;
            double y = Double.NaN;
            int element = 0;
            while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                    throw new OpenSearchParseException("numeric value expected", new Object[0]);
                }
                if (++element == 1) {
                    x = parser.doubleValue();
                    continue;
                }
                if (element == 2) {
                    y = parser.doubleValue();
                    continue;
                }
                if (element == 3) {
                    XYPoint.assertZValue(ignoreZValue, parser.doubleValue());
                    continue;
                }
                throw new OpenSearchParseException("[xy_point] field type does not accept more than 3 values", new Object[0]);
            }
            if (element < 2) {
                throw new OpenSearchParseException("[xy_point] field type should have at least two dimensions", new Object[0]);
            }
            XYPoint xYPoint = point.reset(x, y);
            return xYPoint;
        }
    }
}

