/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.batch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLBatchIngestionInput
implements ToXContentObject,
Writeable {
    public static final String INDEX_NAME_FIELD = "index_name";
    public static final String FIELD_MAP_FIELD = "field_map";
    public static final String INGEST_FIELDS = "ingest_fields";
    public static final String CONNECTOR_CREDENTIAL_FIELD = "credential";
    public static final String DATA_SOURCE_FIELD = "data_source";
    public static final String CONNECTOR_ID_FIELD = "connector_id";
    private String indexName;
    private Map<String, Object> fieldMapping;
    private String[] ingestFields;
    private Map<String, Object> dataSources;
    private Map<String, String> credential;
    private String connectorId;

    public MLBatchIngestionInput(String indexName, Map<String, Object> fieldMapping, String[] ingestFields, Map<String, Object> dataSources, Map<String, String> credential, String connectorId) {
        if (indexName == null) {
            throw new IllegalArgumentException("The index name for data ingestion is missing. Please provide a valid index name to proceed.");
        }
        if (dataSources == null) {
            throw new IllegalArgumentException("No data sources were provided for ingestion. Please specify at least one valid data source to proceed.");
        }
        this.indexName = indexName;
        this.fieldMapping = fieldMapping;
        this.ingestFields = ingestFields;
        this.dataSources = dataSources;
        this.credential = credential;
        this.connectorId = connectorId;
    }

    public static MLBatchIngestionInput parse(XContentParser parser) throws IOException {
        String indexName = null;
        Map fieldMapping = null;
        String[] ingestFields = null;
        Map dataSources = null;
        Map<String, String> credential = new HashMap<String, String>();
        String connectorId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = parser.text();
                    continue block16;
                }
                case "field_map": {
                    fieldMapping = parser.map();
                    continue block16;
                }
                case "ingest_fields": {
                    ingestFields = parser.list().toArray(new String[0]);
                    continue block16;
                }
                case "credential": {
                    credential = parser.mapStrings();
                    continue block16;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block16;
                }
                case "data_source": {
                    dataSources = parser.map();
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new MLBatchIngestionInput(indexName, fieldMapping, ingestFields, dataSources, credential, connectorId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indexName != null) {
            builder.field(INDEX_NAME_FIELD, this.indexName);
        }
        if (this.fieldMapping != null) {
            builder.field(FIELD_MAP_FIELD, this.fieldMapping);
        }
        if (this.ingestFields != null) {
            builder.field(INGEST_FIELDS, (Object)this.ingestFields);
        }
        if (this.credential != null) {
            builder.field(CONNECTOR_CREDENTIAL_FIELD, this.credential);
        }
        if (this.connectorId != null) {
            builder.field(CONNECTOR_ID_FIELD, this.connectorId);
        }
        if (this.dataSources != null) {
            builder.field(DATA_SOURCE_FIELD, this.dataSources);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeOptionalString(this.indexName);
        if (this.fieldMapping != null) {
            output.writeBoolean(true);
            output.writeMap(this.fieldMapping, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            output.writeBoolean(false);
        }
        if (this.ingestFields != null) {
            output.writeBoolean(true);
            output.writeStringArray(this.ingestFields);
        } else {
            output.writeBoolean(false);
        }
        if (this.credential != null) {
            output.writeBoolean(true);
            output.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.connectorId);
        if (this.dataSources != null) {
            output.writeBoolean(true);
            output.writeMap(this.dataSources, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            output.writeBoolean(false);
        }
    }

    public MLBatchIngestionInput(StreamInput input) throws IOException {
        this.indexName = input.readOptionalString();
        if (input.readBoolean()) {
            this.fieldMapping = input.readMap(s -> s.readString(), s -> s.readGenericValue());
        }
        if (input.readBoolean()) {
            this.ingestFields = input.readStringArray();
        }
        if (input.readBoolean()) {
            this.credential = input.readMap(s -> s.readString(), s -> s.readString());
        }
        this.connectorId = input.readOptionalString();
        if (input.readBoolean()) {
            this.dataSources = input.readMap(s -> s.readString(), s -> s.readGenericValue());
        }
    }

    @Generated
    public static MLBatchIngestionInputBuilder builder() {
        return new MLBatchIngestionInputBuilder();
    }

    @Generated
    public MLBatchIngestionInputBuilder toBuilder() {
        return new MLBatchIngestionInputBuilder().indexName(this.indexName).fieldMapping(this.fieldMapping).ingestFields(this.ingestFields).dataSources(this.dataSources).credential(this.credential).connectorId(this.connectorId);
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public Map<String, Object> getFieldMapping() {
        return this.fieldMapping;
    }

    @Generated
    public String[] getIngestFields() {
        return this.ingestFields;
    }

    @Generated
    public Map<String, Object> getDataSources() {
        return this.dataSources;
    }

    @Generated
    public Map<String, String> getCredential() {
        return this.credential;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public void setCredential(Map<String, String> credential) {
        this.credential = credential;
    }

    @Generated
    public static class MLBatchIngestionInputBuilder {
        @Generated
        private String indexName;
        @Generated
        private Map<String, Object> fieldMapping;
        @Generated
        private String[] ingestFields;
        @Generated
        private Map<String, Object> dataSources;
        @Generated
        private Map<String, String> credential;
        @Generated
        private String connectorId;

        @Generated
        MLBatchIngestionInputBuilder() {
        }

        @Generated
        public MLBatchIngestionInputBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Generated
        public MLBatchIngestionInputBuilder fieldMapping(Map<String, Object> fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        @Generated
        public MLBatchIngestionInputBuilder ingestFields(String[] ingestFields) {
            this.ingestFields = ingestFields;
            return this;
        }

        @Generated
        public MLBatchIngestionInputBuilder dataSources(Map<String, Object> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        @Generated
        public MLBatchIngestionInputBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public MLBatchIngestionInputBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MLBatchIngestionInput build() {
            return new MLBatchIngestionInput(this.indexName, this.fieldMapping, this.ingestFields, this.dataSources, this.credential, this.connectorId);
        }

        @Generated
        public String toString() {
            return "MLBatchIngestionInput.MLBatchIngestionInputBuilder(indexName=" + this.indexName + ", fieldMapping=" + String.valueOf(this.fieldMapping) + ", ingestFields=" + Arrays.deepToString(this.ingestFields) + ", dataSources=" + String.valueOf(this.dataSources) + ", credential=" + String.valueOf(this.credential) + ", connectorId=" + this.connectorId + ")";
        }
    }
}

