/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.internal.HmacKeyDerivationFunction;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.management.openmbean.InvalidKeyException;

public final class CommittedKey {
    private final SecretKey key_;
    private final byte[] commitment_;
    private static byte[] DERIVE_KEY_LABEL_TEMPLATE = "__DERIVEKEY".getBytes(StandardCharsets.UTF_8);
    private static byte[] COMMITKEY_LABEL = "COMMITKEY".getBytes(StandardCharsets.UTF_8);
    private static final String RAW_DATA_FORMAT = "RAW";
    private static final String HKDF_SHA_512 = "HkdfSHA512";
    private static final String HMAC_SHA_512 = "HmacSHA512";

    CommittedKey(SecretKey key, byte[] commitment) {
        this.key_ = key;
        this.commitment_ = commitment;
    }

    public SecretKey getKey() {
        return this.key_;
    }

    public byte[] getCommitment() {
        return (byte[])this.commitment_.clone();
    }

    public static CommittedKey generate(CryptoAlgorithm alg, SecretKey dataKey, byte[] nonce) throws InvalidKeyException {
        String macAlgorithm;
        if (!alg.isCommitting()) {
            throw new IllegalArgumentException("Algorithm does not support key commitment.");
        }
        if (nonce.length != alg.getCommitmentNonceLength()) {
            throw new IllegalArgumentException("Invalid nonce size");
        }
        if (dataKey.getFormat() == null || !dataKey.getFormat().equalsIgnoreCase(RAW_DATA_FORMAT)) {
            throw new IllegalArgumentException("Currently only RAW format keys are supported for HKDF algorithms. Actual format was " + dataKey.getFormat());
        }
        if (dataKey.getAlgorithm() == null || !dataKey.getAlgorithm().equalsIgnoreCase(alg.getDataKeyAlgo())) {
            throw new IllegalArgumentException("DataKey of incorrect algorithm. Expected " + alg.getDataKeyAlgo() + " but was " + dataKey.getAlgorithm());
        }
        byte[] rawDataKey = dataKey.getEncoded();
        if (rawDataKey.length != alg.getDataKeyLength()) {
            throw new IllegalArgumentException("DataKey of incorrect length. Expected " + alg.getDataKeyLength() + " but was " + rawDataKey.length);
        }
        switch (alg.getKeyCommitmentAlgo_()) {
            case "HkdfSHA512": {
                macAlgorithm = HMAC_SHA_512;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Support for commitment with " + alg.getKeyCommitmentAlgo_() + " not yet built.");
            }
        }
        HmacKeyDerivationFunction kdf = null;
        try {
            kdf = HmacKeyDerivationFunction.getInstance(macAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        kdf.init(rawDataKey, nonce);
        byte[] commitment = kdf.deriveKey(COMMITKEY_LABEL, alg.getCommitmentLength());
        byte[] deriveKeyLabel = (byte[])DERIVE_KEY_LABEL_TEMPLATE.clone();
        short algId = alg.getValue();
        deriveKeyLabel[0] = (byte)(algId >> 8 & 0xFF);
        deriveKeyLabel[1] = (byte)(algId & 0xFF);
        SecretKeySpec ek = new SecretKeySpec(kdf.deriveKey(deriveKeyLabel, alg.getKeyLength()), alg.getKeyAlgo());
        return new CommittedKey(ek, commitment);
    }
}

