/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.events;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.Version;
import org.opensearch.neuralsearch.stats.common.StatName;
import org.opensearch.neuralsearch.stats.events.EventStat;
import org.opensearch.neuralsearch.stats.events.EventStatType;
import org.opensearch.neuralsearch.stats.events.TimestampedEventStat;

public enum EventStatName implements StatName
{
    TEXT_EMBEDDING_PROCESSOR_EXECUTIONS("text_embedding_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_0_0),
    SKIP_EXISTING_EXECUTIONS("skip_existing_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_PROCESSOR_EXECUTIONS("text_chunking_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_FIXED_TOKEN_LENGTH_EXECUTIONS("text_chunking_fixed_token_length_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_DELIMITER_EXECUTIONS("text_chunking_delimiter_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_FIXED_CHAR_LENGTH_EXECUTIONS("text_chunking_fixed_char_length_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    SEMANTIC_FIELD_PROCESSOR_EXECUTIONS("semantic_field_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    SEMANTIC_FIELD_PROCESSOR_CHUNKING_EXECUTIONS("semantic_field_chunking_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    SEMANTIC_HIGHLIGHTING_REQUEST_COUNT("semantic_highlighting_request_count", "semantic_highlighting", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    SEMANTIC_HIGHLIGHTING_BATCH_REQUEST_COUNT("semantic_highlighting_batch_request_count", "semantic_highlighting", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_3_0),
    NORMALIZATION_PROCESSOR_EXECUTIONS("normalization_processor_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    AGENTIC_QUERY_TRANSLATOR_PROCESSOR_EXECUTIONS("agentic_query_translator_executions", "processors.search.agentic", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_2_0),
    AGENTIC_CONTEXT_PROCESSOR_EXECUTIONS("agentic_context_executions", "processors.search.agentic", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_3_0),
    NORM_TECHNIQUE_L2_EXECUTIONS("norm_l2_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NORM_TECHNIQUE_MINMAX_EXECUTIONS("norm_minmax_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NORM_TECHNIQUE_NORM_ZSCORE_EXECUTIONS("norm_zscore_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_ARITHMETIC_EXECUTIONS("comb_arithmetic_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_GEOMETRIC_EXECUTIONS("comb_geometric_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_HARMONIC_EXECUTIONS("comb_harmonic_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    RRF_PROCESSOR_EXECUTIONS("rank_based_normalization_processor_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_RRF_EXECUTIONS("comb_rrf_executions", "processors.search.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    HYBRID_QUERY_REQUESTS("hybrid_query_requests", "query.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    HYBRID_QUERY_INNER_HITS_REQUESTS("hybrid_query_with_inner_hits_requests", "query.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    HYBRID_QUERY_FILTER_REQUESTS("hybrid_query_with_filter_requests", "query.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    HYBRID_QUERY_PAGINATION_REQUESTS("hybrid_query_with_pagination_requests", "query.hybrid", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_QUERY_REQUESTS("neural_query_requests", "query.neural", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_QUERY_AGAINST_KNN_REQUESTS("neural_query_against_knn_requests", "query.neural", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_QUERY_AGAINST_SEMANTIC_DENSE_REQUESTS("neural_query_against_semantic_dense_requests", "query.neural", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_QUERY_AGAINST_SEMANTIC_SPARSE_REQUESTS("neural_query_against_semantic_sparse_requests", "query.neural", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_SPARSE_QUERY_REQUESTS("neural_sparse_query_requests", "query.neural_sparse", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    TEXT_IMAGE_EMBEDDING_PROCESSOR_EXECUTIONS("text_image_embedding_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    SPARSE_ENCODING_PROCESSOR_EXECUTIONS("sparse_encoding_executions", "processors.ingest", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_QUERY_ENRICHER_PROCESSOR_EXECUTIONS("neural_query_enricher_executions", "processors.search", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    NEURAL_SPARSE_TWO_PHASE_PROCESSOR_EXECUTIONS("neural_sparse_two_phase_executions", "processors.search", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    RERANK_BY_FIELD_PROCESSOR_EXECUTIONS("rerank_by_field_executions", "processors.search", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    RERANK_ML_PROCESSOR_EXECUTIONS("rerank_ml_executions", "processors.search", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    AGENTIC_QUERY_REQUESTS("agentic_query_requests", "query.agentic", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_2_0),
    SEISMIC_QUERY_REQUESTS("seismic_query_requests", "query.neural_sparse", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_3_0),
    MMR_NEURAL_QUERY_TRANSFORMER("mmr_neural_query_transformer_executions", "processors.search", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_3_0);

    private final String nameString;
    private final String path;
    private final EventStatType statType;
    private EventStat eventStat;
    private Version version;
    private static final Map<String, EventStatName> BY_NAME;

    private EventStatName(String nameString, String path, EventStatType statType, Version version) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
        this.version = version;
        switch (statType) {
            case TIMESTAMPED_EVENT_COUNTER: {
                this.eventStat = new TimestampedEventStat(this);
            }
        }
        if (this.eventStat == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to initialize event stat [%s]. Unrecognized event stat type: [%s]", nameString, statType));
        }
    }

    public static EventStatName from(String name) {
        if (!EventStatName.isValidName(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Event stat not found: %s", name));
        }
        return BY_NAME.get(name);
    }

    public static boolean isValidName(String name) {
        return BY_NAME.containsKey(name);
    }

    @Override
    public String getFullPath() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    @Override
    public Version version() {
        return this.version;
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public EventStatType getStatType() {
        return this.statType;
    }

    @Generated
    public EventStat getEventStat() {
        return this.eventStat;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    static {
        BY_NAME = Arrays.stream(EventStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

