/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeRole;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class BaseNode
implements PlainJsonSerializable {
    @Nonnull
    private final Map<String, String> attributes;
    @Nullable
    private final String host;
    @Nullable
    private final String ip;
    @Nonnull
    private final String name;
    @Nonnull
    private final List<NodeRole> roles;
    @Nullable
    private final String transportAddress;

    protected BaseNode(AbstractBuilder<?> builder) {
        this.attributes = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).attributes);
        this.host = ((AbstractBuilder)builder).host;
        this.ip = ((AbstractBuilder)builder).ip;
        this.name = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).name, this, "name");
        this.roles = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).roles);
        this.transportAddress = ((AbstractBuilder)builder).transportAddress;
    }

    @Nonnull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final String ip() {
        return this.ip;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public final String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.transportAddress != null) {
            generator.writeKey("transport_address");
            generator.write(this.transportAddress);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBaseNodeDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(AbstractBuilder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(AbstractBuilder::ip, JsonpDeserializer.stringDeserializer(), "ip");
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(AbstractBuilder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(AbstractBuilder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.host);
        result = 31 * result + Objects.hashCode(this.ip);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.roles);
        result = 31 * result + Objects.hashCode(this.transportAddress);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseNode other = (BaseNode)o;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.host, other.host) && Objects.equals(this.ip, other.ip) && this.name.equals(other.name) && Objects.equals(this.roles, other.roles) && Objects.equals(this.transportAddress, other.transportAddress);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private Map<String, String> attributes;
        @Nullable
        private String host;
        @Nullable
        private String ip;
        private String name;
        @Nullable
        private List<NodeRole> roles;
        @Nullable
        private String transportAddress;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(BaseNode o) {
            this.attributes = AbstractBuilder._mapCopy(o.attributes);
            this.host = o.host;
            this.ip = o.ip;
            this.name = o.name;
            this.roles = AbstractBuilder._listCopy(o.roles);
            this.transportAddress = o.transportAddress;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.attributes = AbstractBuilder._mapCopy(o.attributes);
            this.host = o.host;
            this.ip = o.ip;
            this.name = o.name;
            this.roles = AbstractBuilder._listCopy(o.roles);
            this.transportAddress = o.transportAddress;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT attributes(Map<String, String> map) {
            this.attributes = AbstractBuilder._mapPutAll(this.attributes, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT attributes(String key, String value) {
            this.attributes = AbstractBuilder._mapPut(this.attributes, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT host(@Nullable String value) {
            this.host = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT ip(@Nullable String value) {
            this.ip = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT name(String value) {
            this.name = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT roles(List<NodeRole> list) {
            this.roles = AbstractBuilder._listAddAll(this.roles, list);
            return this.self();
        }

        @Nonnull
        public final BuilderT roles(NodeRole value, NodeRole ... values) {
            this.roles = AbstractBuilder._listAdd(this.roles, value, values);
            return this.self();
        }

        @Nonnull
        public final BuilderT transportAddress(@Nullable String value) {
            this.transportAddress = value;
            return this.self();
        }
    }
}

