/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TaskFailure
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TaskFailure> {
    @Nonnull
    private final String nodeId;
    @Nonnull
    private final ErrorCause reason;
    @Nonnull
    private final String status;
    private final int taskId;
    public static final JsonpDeserializer<TaskFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskFailure::setupTaskFailureDeserializer);

    private TaskFailure(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.taskId = ApiTypeHelper.requireNonNull(builder.taskId, this, "taskId");
    }

    public static TaskFailure of(Function<Builder, ObjectBuilder<TaskFailure>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String nodeId() {
        return this.nodeId;
    }

    @Nonnull
    public final ErrorCause reason() {
        return this.reason;
    }

    @Nonnull
    public final String status() {
        return this.status;
    }

    public final int taskId() {
        return this.taskId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        generator.writeKey("status");
        generator.write(this.status);
        generator.writeKey("task_id");
        generator.write(this.taskId);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTaskFailureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::reason, ErrorCause._DESERIALIZER, "reason");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
        op.add(Builder::taskId, JsonpDeserializer.integerDeserializer(), "task_id");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.nodeId.hashCode();
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + this.status.hashCode();
        result = 31 * result + Integer.hashCode(this.taskId);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskFailure other = (TaskFailure)o;
        return this.nodeId.equals(other.nodeId) && this.reason.equals(other.reason) && this.status.equals(other.status) && this.taskId == other.taskId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TaskFailure> {
        private String nodeId;
        private ErrorCause reason;
        private String status;
        private Integer taskId;

        public Builder() {
        }

        private Builder(TaskFailure o) {
            this.nodeId = o.nodeId;
            this.reason = o.reason;
            this.status = o.status;
            this.taskId = o.taskId;
        }

        private Builder(Builder o) {
            this.nodeId = o.nodeId;
            this.reason = o.reason;
            this.status = o.status;
            this.taskId = o.taskId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Nonnull
        public final Builder reason(ErrorCause value) {
            this.reason = value;
            return this;
        }

        @Nonnull
        public final Builder reason(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reason(fn.apply(new ErrorCause.Builder()).build());
        }

        @Nonnull
        public final Builder status(String value) {
            this.status = value;
            return this;
        }

        @Nonnull
        public final Builder taskId(int value) {
            this.taskId = value;
            return this;
        }

        @Override
        @Nonnull
        public TaskFailure build() {
            this._checkSingleUse();
            return new TaskFailure(this);
        }
    }
}

