/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.profile.FormatSpecificNameIdentifierGenerator;
import org.opensaml.saml.common.profile.NameIdentifierGenerator;
import org.slf4j.Logger;

public class ChainingNameIdentifierGenerator<NameIdType extends SAMLObject>
implements NameIdentifierGenerator<NameIdType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingNameIdentifierGenerator.class);
    @Nonnull
    private ListMultimap<String, NameIdentifierGenerator<NameIdType>> nameIdGeneratorMap = ArrayListMultimap.create();
    @Nullable
    private NameIdentifierGenerator<NameIdType> defaultNameIdGenerator;

    public void setGenerators(@Nonnull List<NameIdentifierGenerator<NameIdType>> generators) {
        Constraint.isNotNull(generators, "NameIdentifierGenerator list cannot be null");
        this.nameIdGeneratorMap.clear();
        for (NameIdentifierGenerator<NameIdType> generator : generators) {
            if (generator instanceof FormatSpecificNameIdentifierGenerator) {
                this.nameIdGeneratorMap.put((Object)((FormatSpecificNameIdentifierGenerator)generator).getFormat(), generator);
                continue;
            }
            this.log.warn("Unable to install NameIdentifierGenerator of type {}, not format-specific", (Object)(generator != null ? generator.getClass().getName() : "null"));
        }
    }

    public void setDefaultGenerator(@Nullable NameIdentifierGenerator<NameIdType> generator) {
        this.defaultNameIdGenerator = generator;
    }

    @Override
    @Nullable
    public NameIdType generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String format) throws SAMLException {
        this.log.debug("Trying to generate identifier with Format {}", (Object)format);
        List<NameIdentifierGenerator<NameIdType>> generators = this.nameIdGeneratorMap.get((Object)format);
        if (generators.isEmpty() && this.defaultNameIdGenerator != null) {
            this.log.debug("No generators installed for Format {}, trying default/fallback method", (Object)format);
            assert (this.defaultNameIdGenerator != null);
            generators = CollectionSupport.singletonList(this.defaultNameIdGenerator);
        }
        for (NameIdentifierGenerator nameIdentifierGenerator : generators) {
            try {
                Object nameIdentifier = nameIdentifierGenerator.generate(profileRequestContext, format);
                if (nameIdentifier == null) continue;
                this.log.debug("Successfully generated identifier with Format {}", (Object)format);
                return nameIdentifier;
            }
            catch (SAMLException e) {
                this.log.error("Error while generating identifier", (Throwable)e);
            }
        }
        return null;
    }
}

