/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.common.profile.logic.AbstractRegistrationInfoPredicate;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationInfo;

public class RegistrationAuthorityPredicate
extends AbstractRegistrationInfoPredicate {
    @Nonnull
    private final Set<String> authorities;

    public RegistrationAuthorityPredicate(@Nullable @ParameterName(name="names") Collection<String> names) {
        this.authorities = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(names));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    protected boolean doApply(@Nonnull RegistrationInfo info) {
        return this.authorities.contains(info.getRegistrationAuthority());
    }
}

