/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class NameIDFormatFilter
extends AbstractMetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NameIDFormatFilter.class);
    private boolean removeExistingFormats;
    @Nonnull
    private Multimap<Predicate<EntityDescriptor>, String> applyMap = ArrayListMultimap.create();
    @Nonnull
    private final SAMLObjectBuilder<NameIDFormat> formatBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(NameIDFormat.DEFAULT_ELEMENT_NAME);

    public void setRemoveExistingFormats(boolean flag) {
        this.checkSetterPreconditions();
        this.removeExistingFormats = flag;
    }

    public void setRules(@Nonnull Map<Predicate<EntityDescriptor>, Collection<String>> rules) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(rules, "Rules map cannot be null");
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<String>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), StringSupport.normalizeStringCollection(entry.getValue()));
        }
    }

    @Override
    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty() || !((Predicate)entry.getKey()).test(descriptor)) continue;
            for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
                assert (role != null);
                this.filterRoleDescriptor(role, (Collection)entry.getValue());
            }
        }
    }

    protected void filterRoleDescriptor(@Nonnull RoleDescriptor role, @Nonnull Collection<String> formats) {
        String entityID;
        List<NameIDFormat> roleFormats;
        if (role instanceof SPSSODescriptor) {
            SPSSODescriptor sp = (SPSSODescriptor)role;
            roleFormats = sp.getNameIDFormats();
        } else if (role instanceof AttributeAuthorityDescriptor) {
            AttributeAuthorityDescriptor aa = (AttributeAuthorityDescriptor)role;
            roleFormats = aa.getNameIDFormats();
        } else if (role instanceof PDPDescriptor) {
            PDPDescriptor pdp = (PDPDescriptor)role;
            roleFormats = pdp.getNameIDFormats();
        } else {
            return;
        }
        XMLObject xMLObject = role.getParent();
        if (xMLObject instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)xMLObject;
            entityID = entity.getEntityID();
        } else {
            entityID = null;
        }
        if (this.removeExistingFormats && !roleFormats.isEmpty()) {
            this.log.debug("Removing existing NameIDFormats from {} role in EntityDescriptor '{}'", (Object)role.getElementQName(), (Object)entityID);
            roleFormats.clear();
        }
        Set existingFormats = roleFormats.stream().map(XSURI::getURI).collect(Collectors.toUnmodifiableSet());
        for (String format : formats) {
            if (existingFormats.contains(format)) {
                this.log.debug("Ignoring add of existing NameIDFormat '{}' on EntityDescriptor '{}'", (Object)format, (Object)entityID);
                continue;
            }
            NameIDFormat nif = this.formatBuilder.buildObject();
            nif.setURI(format);
            this.log.info("Adding NameIDFormat '{}' to EntityDescriptor '{}'", (Object)format, (Object)entityID);
            roleFormats.add(nif);
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            assert (group != null);
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            assert (entity != null);
            this.filterEntityDescriptor(entity);
        }
    }
}

