/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;
import org.apache.commons.codec.binary.Hex;

public final class X509DigestCriterion
implements Criterion {
    @Nonnull
    private String algorithm;
    @Nonnull
    private byte[] x509digest;

    public X509DigestCriterion(@Nonnull String alg, @Nonnull byte[] digest) {
        this.algorithm = Constraint.isNotNull(StringSupport.trimOrNull(alg), "Certificate digest algorithm cannot be null or empty");
        this.x509digest = Constraint.isNotEmpty(digest, "Certificate digest criteria value cannot be null or empty");
    }

    @Nonnull
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(@Nonnull String alg) {
        this.algorithm = Constraint.isNotNull(StringSupport.trimOrNull(alg), "Certificate digest algorithm cannot be null or empty");
    }

    @Nonnull
    public byte[] getDigest() {
        return this.x509digest;
    }

    public void setDigest(@Nonnull byte[] digest) {
        this.x509digest = Constraint.isNotEmpty(digest, "Certificate digest criteria value cannot be null or empty");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("X509DigestCriterion [algorithm=");
        builder.append(this.algorithm);
        builder.append(", digest=");
        builder.append(Hex.encodeHexString((byte[])this.x509digest));
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.algorithm.hashCode();
        result = 37 * result + this.x509digest.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof X509DigestCriterion) {
            X509DigestCriterion other = (X509DigestCriterion)obj;
            return this.algorithm.equals(other.algorithm) && Arrays.equals(this.x509digest, other.x509digest);
        }
        return false;
    }
}

