/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineContext;
import org.slf4j.Logger;

public final class ThreadLocalX509TrustEngineSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLocalX509TrustEngineSupport.class);

    private ThreadLocalX509TrustEngineSupport() {
    }

    public static void evaluate(@Nonnull SSLSocket sslSocket) throws SSLPeerUnverifiedException {
        Certificate[] chain = sslSocket.getSession().getPeerCertificates();
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Certificate chain was null or empty");
        }
        X509Certificate[] x509Chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!X509Certificate.class.isInstance(chain[i])) {
                throw new SSLPeerUnverifiedException("Certificate chain contained non-X509Certificate");
            }
            x509Chain[i] = (X509Certificate)X509Certificate.class.cast(chain[i]);
        }
        try {
            ThreadLocalX509TrustEngineSupport.evaluate(x509Chain);
        }
        catch (CertificateException e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
    }

    public static void evaluate(@Nonnull X509Certificate[] chain) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Certificate chain was null or empty");
        }
        if (!ThreadLocalX509TrustEngineContext.haveCurrent()) {
            throw new CertificateException("Trust of X509Certificate could not be established, ThreadLocalX509TrustEngineContext is not populated");
        }
        LOG.trace("Evaluating X509Certificate[] chain against ThreadLocalX509TrustEngineContext");
        TrustEngine<? super X509Credential> trustEngine = ThreadLocalX509TrustEngineContext.getTrustEngine();
        CriteriaSet criteria = ThreadLocalX509TrustEngineContext.getCriteria();
        assert (trustEngine != null);
        assert (criteria != null);
        if (ThreadLocalX509TrustEngineSupport.performTrustEval(chain, trustEngine, criteria)) {
            ThreadLocalX509TrustEngineContext.setTrusted(true);
        } else {
            ThreadLocalX509TrustEngineContext.setTrusted(false);
            if (ThreadLocalX509TrustEngineContext.isFailureFatal().booleanValue()) {
                LOG.debug("Credential evaluated as untrusted, failure indicated as fatal");
                throw new CertificateException("Trust engine could not establish trust of presented TLS credential");
            }
            LOG.debug("Credential evaluated as untrusted, failure indicated as non-fatal");
        }
    }

    private static boolean performTrustEval(@Nonnull X509Certificate[] chain, @Nonnull TrustEngine<? super X509Credential> trustEngine, @Nonnull CriteriaSet criteriaSet) throws CertificateException {
        LOG.debug("Attempting to evaluate server TLS credential against supplied TrustEngine and CriteriaSet");
        X509Credential credential = ThreadLocalX509TrustEngineSupport.extractCredential(chain);
        LOG.trace("Saw trust engine of type: {}", (Object)trustEngine.getClass().getName());
        try {
            if (trustEngine.validate(credential, criteriaSet)) {
                LOG.debug("Credential evaluated as trusted");
                return true;
            }
            LOG.debug("Credential evaluated as untrusted");
            return false;
        }
        catch (Throwable t) {
            LOG.error("Fatal trust engine error evaluating credential", t);
            return false;
        }
    }

    @Nonnull
    private static X509Credential extractCredential(@Nonnull @NotEmpty X509Certificate[] chain) throws CertificateException {
        List<X509Certificate> certChain = Arrays.asList(chain);
        X509Certificate entityCert = certChain.get(0);
        BasicX509Credential credential = new BasicX509Credential(entityCert);
        credential.setEntityCertificateChain(certChain);
        return credential;
    }
}

