/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.xml.security.Init;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.opensaml.xmlsec.impl.provider.ApacheSantuarioXMLParser;
import org.slf4j.Logger;

public class ApacheXMLSecurityInitializer
implements Initializer {
    @Nonnull
    @NotEmpty
    public static final String CONFIG_PROPERTY_XML_PARSER_ENABLE = "opensaml.config.xmlsec.ApacheSantuarioXMLParser.enable";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ApacheXMLSecurityInitializer.class);

    @Override
    public void init() throws InitializationException {
        ConfigurationProperties props;
        boolean enableXMLParser;
        String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
        if (System.getProperty("org.apache.xml.security.ignoreLineBreaks") == null) {
            System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        }
        if (enableXMLParser = Boolean.parseBoolean((props = ConfigurationService.getConfigurationProperties()).getProperty(CONFIG_PROPERTY_XML_PARSER_ENABLE, "true"))) {
            String xmlParserPropName = "org.apache.xml.security.XMLParser";
            if (System.getProperty("org.apache.xml.security.XMLParser") == null) {
                this.log.trace("Enabling use of ApacheSantuarioXMLParser");
                System.setProperty("org.apache.xml.security.XMLParser", ApacheSantuarioXMLParser.class.getName());
            }
        }
        if (!Init.isInitialized()) {
            this.log.debug("Initializing Apache XMLSecurity library");
            Init.init();
        } else {
            this.log.debug("Apache XMLSecurity library was already initialized, skipping...");
        }
    }
}

