/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.Utils;

public abstract class AbstractHashingFunction
implements HashingFunction {
    protected static boolean slowEquals(CharSequence a, CharSequence b) {
        return AbstractHashingFunction.slowEquals(Utils.fromCharSequenceToBytes(a), Utils.fromCharSequenceToBytes(b));
    }

    protected static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt, CharSequence pepper) {
        CharSequence peppered = Utils.append(pepper, plainTextPassword);
        Hash result = salt == null ? this.hash(peppered) : this.hash(peppered, salt);
        result.setPepper(pepper);
        return result;
    }

    @Override
    public Hash hash(byte[] plainTextPassword, byte[] salt, CharSequence pepper) {
        byte[] pepperAsBytes = Utils.fromCharSequenceToBytes(pepper);
        byte[] peppered = Utils.append(pepperAsBytes, plainTextPassword);
        Hash result = salt == null ? this.hash(peppered) : this.hash(peppered, salt);
        result.setPepper(pepper);
        return result;
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt) {
        return this.check(plainTextPassword, hashed);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed, byte[] salt) {
        return this.check(plainTextPassword, hashed);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt, CharSequence pepper) {
        return this.check(Utils.append(pepper, plainTextPassword), hashed, salt);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed, byte[] salt, CharSequence pepper) {
        byte[] pepperAsBytes = Utils.fromCharSequenceToBytes(pepper);
        return this.check(Utils.append(pepperAsBytes, plainTextPassword), hashed, salt);
    }
}

