/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.DeleteActionBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.util.NlsSafe;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteRowsAction
extends DeleteActionBase {
    @Override
    protected boolean isEnabled(@NotNull DataGrid grid) {
        GridDataSupport support;
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(0);
        }
        return !(support = grid.getDataSupport()).isDeletedRows(grid.getSelectionModel().getSelectedRows()) && grid.isEditable() && grid.getDataHookup().isForSingleSource();
    }

    @Override
    protected void doDelete(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> contextColumn) {
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(1);
        }
        if (contextColumn == null) {
            DeleteRowsAction.$$$reportNull$$$0(2);
        }
        DeleteRowsAction.deleteRows(grid, (ModelIndexSet<GridRow>)grid.getSelectionModel().getSelectedRows());
    }

    private static void deleteRows(@NotNull DataGrid grid, @NotNull ModelIndexSet<GridRow> rows) {
        boolean canDelete;
        GridMutator.RowsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(3);
        }
        if (rows == null) {
            DeleteRowsAction.$$$reportNull$$$0(4);
        }
        if ((mutator = GridUtil.getRowsMutator(grid)) == null) {
            return;
        }
        boolean areRowsInserted = true;
        for (ModelIndex index : rows.asIterable()) {
            areRowsInserted &= mutator.isInsertedRow(index);
        }
        boolean bl = canDelete = !mutator.hasPendingChanges() || !mutator.isUpdateImmediately() || areRowsInserted || GridUtil.showIgnoreUnsubmittedChangesYesNoDialog(grid);
        if (!canDelete) {
            return;
        }
        GridSelection selection = grid.getSelectionModel().store();
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid, rows, ModelIndexSet.forColumns((CoreGrid)grid, (int[])new int[0])));
        mutator.deleteRows(source, rows);
        source.getActionCallback().doWhenDone(() -> grid.getAutoscrollLocker().runWithLock(() -> grid.getSelectionModel().restore(grid.getSelectionModel().fit(selection))));
    }

    @Override
    protected int itemsCount(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(5);
        }
        return grid.getSelectionModel().getSelectedRowCount();
    }

    @Override
    @NlsSafe
    @NotNull
    protected String getItemName(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(6);
        }
        GridRow row = (GridRow)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(grid.getSelectionModel().getSelectedRow());
        String string = "#" + Objects.requireNonNull(row).getRowNum();
        if (string == null) {
            DeleteRowsAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected DeleteActionBase.ActionText text(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteRowsAction.$$$reportNull$$$0(8);
        }
        return new DeleteActionBase.ActionText(DataGridBundle.message((String)"grid.delete.action.row.item", (Object[])new Object[0]), DataGridBundle.message((String)"grid.delete.action.row.items", (Object[])new Object[0]), DataGridBundle.message((String)"grid.delete.selected.row.action.text", (Object[])new Object[0]), DataGridBundle.message((String)"grid.delete.selected.rows.action.text", (Object[])new Object[0]), DataGridBundle.message((String)"grid.delete.selected.row.action.confirmation", (Object[])new Object[0]), DataGridBundle.message((String)"grid.delete.selected.rows.action.confirmation", (Object[])new Object[0]));
    }

    @Override
    protected boolean isVisible(@Nullable DataGrid grid) {
        return grid != null && grid.isEditable() && grid.isReady();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextColumn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DeleteRowsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DeleteRowsAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doDelete";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "itemsCount";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

