/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.toolWindow.ToolWindowHeadlessManagerImpl;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Function;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode<?> kid, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        VirtualFile[] result;
        if (kid instanceof BasePsiNode) {
            Object value2 = kid.getValue();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value2));
            return new VirtualFile[]{virtualFile};
        }
        if (converterFunction != null && (result = (VirtualFile[])converterFunction.fun(kid)) != null) {
            return result;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public static void collect(AbstractTreeNode node, MultiValuesMap<VirtualFile, AbstractTreeNode<?>> map, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        Object[] kids;
        for (Object kid1 : kids = structure.getChildElements((Object)node)) {
            VirtualFile[] files;
            ProjectViewNode kid = (ProjectViewNode)kid1;
            for (VirtualFile vFile : files = ProjectViewTestUtil.getFiles(kid, converterFunction)) {
                map.put((Object)vFile, (Object)kid);
                for (ProjectViewNode eachParent = (ProjectViewNode)kid.getParent(); eachParent != null; eachParent = (ProjectViewNode)eachParent.getParent()) {
                    map.put((Object)vFile, (Object)eachParent);
                }
            }
            ProjectViewTestUtil.collect((AbstractTreeNode)kid, map, structure, converterFunction);
        }
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        MultiValuesMap map = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)rootElement, map, structure, converterFunction);
        for (VirtualFile eachFile : map.keySet()) {
            Collection nodes = map.values();
            for (AbstractTreeNode node : nodes) {
                boolean expected;
                ProjectViewNode eachNode = (ProjectViewNode)node;
                boolean actual = eachNode.contains(eachFile);
                if (actual == (expected = map.get((Object)eachFile).contains(eachNode))) continue;
                Assert.fail((String)("file=" + String.valueOf(eachFile) + "\n node=" + eachNode.getTestPresentation() + " expected:" + expected));
            }
        }
    }

    public static void checkGetParentConsistency(AbstractTreeStructure structure, Object from) {
        Object[] childElements;
        for (Object childElement : childElements = structure.getChildElements(from)) {
            Assert.assertSame((Object)from, (Object)structure.getParentElement(childElement));
            ProjectViewTestUtil.checkGetParentConsistency(structure, childElement);
        }
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.assertStructureEqual(structure, expected, 27, null, structure.getRootElement(), printInfo);
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, int maxRowCount, @Nullable Comparator comparator, Object rootNode, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.checkGetParentConsistency(structure, rootNode);
        String actual = PlatformTestUtil.print(structure, rootNode, 0, comparator, maxRowCount, ' ', printInfo).toString();
        Assert.assertEquals((Object)expected.trim(), (Object)actual.trim());
    }

    public static boolean isExpanded(PsiElement element, AbstractProjectViewPane pane) {
        return null != ProjectViewTestUtil.getVisiblePath(element, pane);
    }

    @Nullable
    public static TreePath getVisiblePath(@NotNull PsiElement element, @NotNull AbstractProjectViewPane pane) {
        if (element == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(0);
        }
        if (pane == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(1);
        }
        PlatformTestUtil.waitWhileBusy(pane.getTree());
        return TreeUtil.visitVisibleRows((JTree)pane.getTree(), path -> {
            AbstractTreeNode node = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path);
            return node != null && element.equals(node.getValue()) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
        });
    }

    public static void setupImpl(@NotNull Project project, boolean loadPaneExtensions) {
        ToolWindowHeadlessManagerImpl toolWindowManager;
        ToolWindow toolWindow;
        if (project == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(2);
        }
        if ((toolWindow = (toolWindowManager = (ToolWindowHeadlessManagerImpl)ToolWindowManager.getInstance((Project)project)).getToolWindow("Project")) == null) {
            for (ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!bean.id.equals("Project")) continue;
                toolWindow = toolWindowManager.doRegisterToolWindow(bean.id);
                break;
            }
        }
        assert (toolWindow != null);
        LafManager.getInstance();
        ((ProjectViewImpl)ProjectView.getInstance((Project)project)).setupImpl(toolWindow, loadPaneExtensions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/ProjectViewTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisiblePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

