/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.io.InputStream;
import org.apache.solr.client.api.model.CloneConfigsetRequestBody;
import org.apache.solr.client.api.model.ListConfigsetsResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;

public interface ConfigsetsApi {

    @Path(value="/configsets/{configSetName}")
    public static interface Upload {
        @PUT
        @Operation(summary="Create a new configset.", tags={"configsets"})
        public SolrJerseyResponse uploadConfigSet(@PathParam(value="configSetName") String var1, @QueryParam(value="overwrite") Boolean var2, @QueryParam(value="cleanup") Boolean var3, @RequestBody(required=true) InputStream var4) throws IOException;

        @PUT
        @Path(value="{filePath:.+}")
        @Operation(summary="Create a new configset.", tags={"configsets"})
        public SolrJerseyResponse uploadConfigSetFile(@PathParam(value="configSetName") String var1, @PathParam(value="filePath") String var2, @QueryParam(value="overwrite") Boolean var3, @QueryParam(value="cleanup") Boolean var4, @RequestBody(required=true) InputStream var5) throws IOException;
    }

    @Path(value="/configsets/{configSetName}")
    public static interface Delete {
        @DELETE
        @Operation(summary="Delete an existing configset.", tags={"configsets"})
        public SolrJerseyResponse deleteConfigSet(@PathParam(value="configSetName") String var1) throws Exception;
    }

    @Path(value="/configsets")
    public static interface Clone {
        @POST
        @Operation(summary="Create a new configset modeled on an existing one.", tags={"configsets"})
        public SolrJerseyResponse cloneExistingConfigSet(CloneConfigsetRequestBody var1) throws Exception;
    }

    @Path(value="/configsets")
    public static interface List {
        @GET
        @Operation(summary="List the configsets available to Solr.", tags={"configsets"})
        public ListConfigsetsResponse listConfigSet() throws Exception;
    }
}

