/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.SchemaGetDynamicFieldInfoResponse;
import org.apache.solr.client.api.model.SchemaGetFieldInfoResponse;
import org.apache.solr.client.api.model.SchemaGetFieldTypeInfoResponse;
import org.apache.solr.client.api.model.SchemaInfoResponse;
import org.apache.solr.client.api.model.SchemaListCopyFieldsResponse;
import org.apache.solr.client.api.model.SchemaListDynamicFieldsResponse;
import org.apache.solr.client.api.model.SchemaListFieldTypesResponse;
import org.apache.solr.client.api.model.SchemaListFieldsResponse;
import org.apache.solr.client.api.model.SchemaNameResponse;
import org.apache.solr.client.api.model.SchemaSimilarityResponse;
import org.apache.solr.client.api.model.SchemaUniqueKeyResponse;
import org.apache.solr.client.api.model.SchemaVersionResponse;
import org.apache.solr.client.api.model.SchemaZkVersionResponse;
import org.apache.solr.client.api.util.StoreApiParameters;

@Path(value="/{indexType:cores|collections}/{indexName}/schema")
public interface GetSchemaApi {
    @GET
    @StoreApiParameters
    @Operation(summary="Fetch the entire schema of the specified core or collection", tags={"schema"})
    public SchemaInfoResponse getSchemaInfo();

    @GET
    @Path(value="/name")
    @StoreApiParameters
    @Operation(summary="Get the name of the schema used by the specified core or collection", tags={"schema"})
    public SchemaNameResponse getSchemaName() throws Exception;

    @GET
    @Path(value="/similarity")
    @StoreApiParameters
    @Operation(summary="Get the default similarity configuration used by the specified core or collection", tags={"schema"})
    public SchemaSimilarityResponse getSchemaSimilarity();

    @GET
    @Path(value="/uniquekey")
    @StoreApiParameters
    @Operation(summary="Fetch the uniquekey of the specified core or collection", tags={"schema"})
    public SchemaUniqueKeyResponse getSchemaUniqueKey();

    @GET
    @Path(value="/version")
    @StoreApiParameters
    @Operation(summary="Fetch the schema version currently used by the specified core or collection", tags={"schema"})
    public SchemaVersionResponse getSchemaVersion();

    @GET
    @Path(value="/zkversion")
    @StoreApiParameters
    @Operation(summary="Fetch the schema version currently used by the specified core or collection", tags={"schema"})
    public SchemaZkVersionResponse getSchemaZkVersion(@DefaultValue(value="-1") @QueryParam(value="refreshIfBelowVersion") Integer var1) throws Exception;

    @Path(value="/{indexType:cores|collections}/{indexName}/schema")
    public static interface Fields {
        @GET
        @Path(value="/fields")
        @StoreApiParameters
        @Operation(summary="List all non-dynamic fields in the schema of the specified core or collection", tags={"schema"})
        public SchemaListFieldsResponse listSchemaFields();

        @GET
        @Path(value="/fields/{fieldName}")
        @StoreApiParameters
        @Operation(summary="Get detailed info about a single non-dynamic field", tags={"schema"})
        public SchemaGetFieldInfoResponse getFieldInfo(@PathParam(value="fieldName") String var1);

        @GET
        @Path(value="/copyfields")
        @StoreApiParameters
        @Operation(summary="List all copy-fields in the schema of the specified core or collection", tags={"schema"})
        public SchemaListCopyFieldsResponse listCopyFields();

        @GET
        @Path(value="/dynamicfields")
        @StoreApiParameters
        @Operation(summary="List all dynamic-fields in the schema of the specified core or collection", tags={"schema"})
        public SchemaListDynamicFieldsResponse listDynamicFields();

        @GET
        @Path(value="/dynamicfields/{fieldName}")
        @StoreApiParameters
        @Operation(summary="Get detailed info about a single dynamic field", tags={"schema"})
        public SchemaGetDynamicFieldInfoResponse getDynamicFieldInfo(@PathParam(value="fieldName") String var1);

        @GET
        @Path(value="/fieldtypes")
        @StoreApiParameters
        @Operation(summary="List all field types in the schema used by the specified core or collection", tags={"schema"})
        public SchemaListFieldTypesResponse listSchemaFieldTypes();

        @GET
        @Path(value="/fieldtypes/{fieldTypeName}")
        @StoreApiParameters
        @Operation(summary="Get detailed info about a single field type", tags={"schema"})
        public SchemaGetFieldTypeInfoResponse getFieldTypeInfo(@PathParam(value="fieldTypeName") String var1);
    }
}

