/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class TransverseCylindricalEqualArea
extends Projection {
    private double rk0;

    public TransverseCylindricalEqualArea() {
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = this.rk0 * Math.cos(lpphi) * Math.sin(lplam);
        out.y = this.scaleFactor * (Math.atan2(Math.tan(lpphi), Math.cos(lplam)) - this.projectionLatitude);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = xyy * this.rk0 + this.projectionLatitude;
        out.x *= this.scaleFactor;
        double t = Math.sqrt(1.0 - xyx * xyx);
        out.y = Math.asin(t * Math.sin(xyy));
        out.x = Math.atan2(xyx, t * Math.cos(xyy));
        return out;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.rk0 = 1.0 / this.scaleFactor;
    }

    @Override
    public boolean isRectilinear() {
        return false;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Transverse Cylindrical Equal Area";
    }
}

