/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.sql.SolrAggregate;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrRules;
import org.apache.solr.handler.sql.functions.ArrayContainsAll;
import org.apache.solr.handler.sql.functions.ArrayContainsAny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrFilter
extends Filter
implements SolrRel {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern CALCITE_TIMESTAMP_REGEX = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(\\.\\d{3})?$");
    private static final Pattern CALCITE_DATE_ONLY_REGEX = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private final RexBuilder builder;

    SolrFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == SolrRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
        this.builder = child.getCluster().getRexBuilder();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public SolrFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new SolrFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(SolrRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (this.getInput() instanceof SolrAggregate) {
            HavingTranslator translator = new HavingTranslator(this.getRowType(), implementor.reverseAggMappings, this.builder);
            String havingPredicate = translator.translateMatch(this.condition);
            implementor.setHavingPredicate(havingPredicate);
        } else {
            Translator translator = new Translator(this.getRowType(), this.builder);
            String query = translator.translateMatch(this.condition);
            implementor.addQuery(query);
            implementor.setNegativeQuery(query.startsWith("-"));
        }
    }

    private static class HavingTranslator
    extends Translator {
        private final Map<String, String> reverseAggMappings;

        HavingTranslator(RelDataType rowType, Map<String, String> reverseAggMappings, RexBuilder builder) {
            super(rowType, builder);
            this.reverseAggMappings = reverseAggMappings;
        }

        @Override
        protected String translateMatch(RexNode condition) {
            if (condition.getKind().belongsTo((Collection)SqlKind.COMPARISON)) {
                return this.translateComparison(condition);
            }
            if (condition.isA(SqlKind.AND)) {
                return this.translateAnd(condition);
            }
            if (condition.isA(SqlKind.OR)) {
                return this.translateOr(condition);
            }
            return null;
        }

        @Override
        protected String translateOr(RexNode condition) {
            ArrayList<String> ors = new ArrayList<String>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                ors.add(this.translateMatch(node));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("or(");
            for (int i = 0; i < ors.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)ors.get(i));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String translateAnd(RexNode node0) {
            ArrayList<String> andStrings = new ArrayList<String>();
            ArrayList<String> notStrings = new ArrayList<String>();
            ArrayList ands = new ArrayList();
            ArrayList nots = new ArrayList();
            RelOptUtil.decomposeConjunction((RexNode)node0, ands, nots);
            for (RexNode node : ands) {
                andStrings.add(this.translateMatch(node));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("and(");
            for (int i = 0; i < andStrings.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)andStrings.get(i));
            }
            builder.append(")");
            if (!nots.isEmpty()) {
                for (RexNode node : nots) {
                    notStrings.add(this.translateMatch(node));
                }
                StringBuilder notBuilder = new StringBuilder();
                for (int i = 0; i < notStrings.size(); ++i) {
                    if (i > 0) {
                        notBuilder.append(",");
                    }
                    notBuilder.append("not(");
                    notBuilder.append((String)notStrings.get(i));
                    notBuilder.append(")");
                }
                return "and(" + builder.toString() + "," + notBuilder.toString() + ")";
            }
            return builder.toString();
        }

        @Override
        protected Pair<String, RexLiteral> translateBinary(RexCall call) {
            Pair<String, RexLiteral> b;
            RexNode right;
            List operands = call.getOperands();
            if (operands.size() != 2) {
                throw new AssertionError((Object)("Invalid number of arguments - " + operands.size()));
            }
            RexNode left = (RexNode)operands.get(0);
            Pair<String, RexLiteral> a = this.translateBinary2(left, right = (RexNode)operands.get(1));
            if (a != null) {
                if (this.reverseAggMappings.containsKey(a.getKey())) {
                    return new Pair((Object)this.reverseAggMappings.get(a.getKey()), (Object)((RexLiteral)a.getValue()));
                }
                return a;
            }
            if ((call.op.kind == SqlKind.EQUALS || call.op.kind == SqlKind.NOT_EQUALS) && (b = this.translateBinary2(right, left)) != null) {
                return b;
            }
            throw new AssertionError((Object)("cannot translate call " + String.valueOf(call)));
        }

        @Override
        protected String translateComparison(RexNode node) {
            Pair<String, RexLiteral> binaryTranslated = this.getFieldValuePair(node);
            switch (node.getKind()) {
                case EQUALS: {
                    String terms = ((RexLiteral)binaryTranslated.getValue()).getValue2().toString().trim();
                    return "eq(" + (String)binaryTranslated.getKey() + "," + terms + ")";
                }
                case NOT_EQUALS: {
                    return "not(eq(" + (String)binaryTranslated.getKey() + "," + String.valueOf(binaryTranslated.getValue()) + "))";
                }
                case LESS_THAN: {
                    return "lt(" + (String)binaryTranslated.getKey() + "," + String.valueOf(binaryTranslated.getValue()) + ")";
                }
                case LESS_THAN_OR_EQUAL: {
                    return "lteq(" + (String)binaryTranslated.getKey() + "," + String.valueOf(binaryTranslated.getValue()) + ")";
                }
                case GREATER_THAN: {
                    return "gt(" + (String)binaryTranslated.getKey() + "," + String.valueOf(binaryTranslated.getValue()) + ")";
                }
                case GREATER_THAN_OR_EQUAL: {
                    return "gteq(" + (String)binaryTranslated.getKey() + "," + String.valueOf(binaryTranslated.getValue()) + ")";
                }
            }
            throw new AssertionError((Object)("cannot translate " + String.valueOf(node)));
        }
    }

    private static class Translator {
        protected final RelDataType rowType;
        protected final List<String> fieldNames;
        private final RexBuilder builder;

        Translator(RelDataType rowType, RexBuilder builder) {
            this.rowType = rowType;
            this.fieldNames = SolrRules.solrFieldNames(rowType);
            this.builder = builder;
        }

        protected RelDataType getFieldType(String field) {
            RelDataTypeField f = this.rowType.getField(field, true, false);
            return f != null ? f.getType() : null;
        }

        protected String translateMatch(RexNode condition) {
            if (log.isDebugEnabled()) {
                log.debug("translateMatch condition={} {}", (Object)condition.getKind(), (Object)condition.getClass().getName());
            }
            SqlKind kind = condition.getKind();
            if (condition.isA(SqlKind.SEARCH)) {
                return this.translateSearch(condition);
            }
            if (kind.belongsTo((Collection)SqlKind.COMPARISON) || kind == SqlKind.NOT) {
                return this.translateComparison(condition);
            }
            if (condition.isA(SqlKind.AND)) {
                return this.translateAndOrBetween(condition, false).toQuery();
            }
            if (condition.isA(SqlKind.OR)) {
                return "(" + this.translateOr(condition) + ")";
            }
            if (kind == SqlKind.LIKE) {
                return this.translateLike(condition);
            }
            if (kind == SqlKind.IS_NOT_NULL || kind == SqlKind.IS_NULL) {
                return this.translateIsNullOrIsNotNull(condition);
            }
            if (kind == SqlKind.OTHER_FUNCTION) {
                return this.translateCustomFunction(condition);
            }
            return null;
        }

        protected String translateCustomFunction(RexNode condition) {
            RexCall call = (RexCall)condition;
            if (call.op instanceof ArrayContainsAll) {
                return this.translateArrayContainsUDF(call, "AND");
            }
            if (call.op instanceof ArrayContainsAny) {
                return this.translateArrayContainsUDF(call, "OR");
            }
            throw new RuntimeException("Custom function '" + String.valueOf(call.op) + "' not supported");
        }

        private String translateArrayContainsUDF(RexCall call, String booleanOperator) {
            List operands = call.getOperands();
            RexInputRef fieldOperand = (RexInputRef)operands.get(0);
            String fieldName = this.fieldNames.get(fieldOperand.getIndex());
            RexNode valuesNode = (RexNode)operands.get(1);
            if (valuesNode instanceof RexLiteral) {
                String literal = this.toSolrLiteral(fieldName, (RexLiteral)valuesNode);
                if (StrUtils.isNotNullOrEmpty((String)literal)) {
                    return fieldName + ":\"" + ClientUtils.escapeQueryChars((String)literal.trim()) + "\"";
                }
                return null;
            }
            if (valuesNode instanceof RexCall) {
                RexCall valuesRexCall = (RexCall)operands.get(1);
                String valuesString = valuesRexCall.getOperands().stream().map(op -> this.toSolrLiteral(fieldName, (RexLiteral)op)).filter(StrUtils::isNotNullOrEmpty).map(value -> "\"" + ClientUtils.escapeQueryChars((String)value.trim()) + "\"").collect(Collectors.joining(" " + booleanOperator + " "));
                return fieldName + ":(" + valuesString + ")";
            }
            return null;
        }

        protected AndClause translateAndOrBetween(RexNode condition, boolean isNegated) {
            RexCall call = (RexCall)condition;
            List operands = call.getOperands();
            String query = null;
            boolean isBetween = false;
            if (operands.size() == 2) {
                RexNode lhs = (RexNode)operands.get(0);
                RexNode rhs = (RexNode)operands.get(1);
                if (lhs.getKind() == SqlKind.GREATER_THAN_OR_EQUAL && rhs.getKind() == SqlKind.LESS_THAN_OR_EQUAL) {
                    query = this.translateBetween(lhs, rhs, isNegated);
                    isBetween = true;
                } else if (lhs.getKind() == SqlKind.LESS_THAN_OR_EQUAL && rhs.getKind() == SqlKind.GREATER_THAN_OR_EQUAL) {
                    query = this.translateBetween(rhs, lhs, isNegated);
                    isBetween = true;
                }
            }
            if (query == null) {
                query = this.translateAnd(condition);
            }
            if (log.isDebugEnabled()) {
                log.debug("translated query match={}", (Object)query);
            }
            return new AndClause(query, isBetween);
        }

        protected String translateBetween(RexNode gteNode, RexNode lteNode, boolean isNegated) {
            Pair<String, RexLiteral> gte = this.getFieldValuePair(gteNode);
            Pair<String, RexLiteral> lte = this.getFieldValuePair(lteNode);
            String fieldName = (String)gte.getKey();
            String query = null;
            if (fieldName.equals(lte.getKey()) && this.compareRexLiteral((RexLiteral)gte.right, (RexLiteral)lte.right) < 0) {
                query = isNegated ? fieldName + ":[* TO " + this.toSolrLiteral(fieldName, (RexLiteral)gte.getValue()) + "} OR " + fieldName + ":{" + this.toSolrLiteral(fieldName, (RexLiteral)lte.getValue()) + " TO *]" : fieldName + ":[" + this.toSolrLiteral(fieldName, (RexLiteral)gte.getValue()) + " TO " + this.toSolrLiteral(fieldName, (RexLiteral)lte.getValue()) + "]";
            }
            return query;
        }

        private int compareRexLiteral(RexLiteral gte, RexLiteral lte) {
            return gte.getValue().compareTo(lte.getValue());
        }

        protected String translateIsNullOrIsNotNull(RexNode node) {
            if (!(node instanceof RexCall)) {
                throw new AssertionError((Object)("expected RexCall for predicate but found: " + String.valueOf(node)));
            }
            RexCall call = (RexCall)node;
            List operands = call.getOperands();
            if (operands.size() != 1) {
                throw new AssertionError((Object)("expected 1 operand for " + String.valueOf(node)));
            }
            RexNode left = (RexNode)operands.get(0);
            if (left instanceof RexInputRef) {
                String name = this.fieldNames.get(((RexInputRef)left).getIndex());
                SqlKind kind = node.getKind();
                return kind == SqlKind.IS_NOT_NULL ? "+" + name + ":*" : "(*:* -" + name + ":*)";
            }
            throw new AssertionError((Object)("expected field ref but found " + String.valueOf(left)));
        }

        protected String translateOr(RexNode condition) {
            ArrayList<String> ors = new ArrayList<String>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                Object orQuery = this.translateMatch(node);
                if (((String)orQuery).startsWith("-")) {
                    orQuery = "(*:* " + (String)orQuery + ")";
                }
                ors.add((String)orQuery);
            }
            return String.join((CharSequence)" OR ", ors);
        }

        protected String translateAnd(RexNode node0) {
            ArrayList<String> andStrings = new ArrayList<String>();
            ArrayList<String> notStrings = new ArrayList<String>();
            ArrayList ands = new ArrayList();
            ArrayList nots = new ArrayList();
            RelOptUtil.decomposeConjunction((RexNode)node0, ands, nots);
            for (RexNode node : ands) {
                Object andQuery = this.translateMatch(node);
                if (((String)andQuery).startsWith("-")) {
                    andQuery = "(*:* " + (String)andQuery + ")";
                }
                andStrings.add((String)andQuery);
            }
            if (!nots.isEmpty()) {
                for (RexNode node : nots) {
                    if (node.isA(SqlKind.AND)) {
                        AndClause andClause = this.translateAndOrBetween(node, true);
                        if (andClause.isBetween) {
                            andStrings.add(andClause.toQuery());
                            continue;
                        }
                        notStrings.add(andClause.toQuery());
                        continue;
                    }
                    notStrings.add(this.translateMatch(node));
                }
                Object query = "";
                if (!andStrings.isEmpty()) {
                    String andString = String.join((CharSequence)" AND ", andStrings);
                    query = (String)query + "(" + andString + ")";
                }
                if (!notStrings.isEmpty()) {
                    if (!((String)query).isEmpty()) {
                        query = (String)query + " AND ";
                    }
                    for (int i = 0; i < notStrings.size(); ++i) {
                        if (i > 0) {
                            query = (String)query + " AND ";
                        }
                        query = (String)query + " (*:* -" + (String)notStrings.get(i) + ")";
                    }
                }
                return ((String)query).trim();
            }
            return String.join((CharSequence)" AND ", andStrings);
        }

        protected String translateLike(RexNode like) {
            Pair<Pair<String, RexLiteral>, Character> pairWithEscapeCharacter = this.getFieldValuePairWithEscapeCharacter(like);
            Pair pair = (Pair)pairWithEscapeCharacter.getKey();
            Character escapeChar = (Character)pairWithEscapeCharacter.getValue();
            String terms = ((RexLiteral)pair.getValue()).toString().trim();
            if (!((terms = this.translateLikeTermToSolrSyntax(terms, escapeChar)).startsWith("(") || terms.startsWith("[") || terms.startsWith("{"))) {
                boolean hasMultipleTerms;
                boolean bl = hasMultipleTerms = (terms = this.escapeWithWildcard(terms)).split("\\s+").length > 1;
                if (hasMultipleTerms && (terms.contains("*") || terms.contains("?"))) {
                    String quotedTerms = "\"" + terms.substring(1, terms.length() - 1) + "\"";
                    String query = ClientUtils.encodeLocalParamVal((String)((String)pair.getKey() + ":" + quotedTerms));
                    return String.format(Locale.ROOT, "{!complexphrase v=%s}", query);
                }
            }
            return (String)pair.getKey() + ":" + terms;
        }

        private String translateLikeTermToSolrSyntax(String term, Character escapeChar) {
            boolean isEscaped = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < term.length(); ++i) {
                char c = term.charAt(i);
                if (!isEscaped && escapeChar != null && escapeChar.charValue() == c) {
                    isEscaped = true;
                    continue;
                }
                if (c == '%' && !isEscaped) {
                    sb.append('*');
                    continue;
                }
                if (c == '_' && !isEscaped) {
                    sb.append("?");
                    continue;
                }
                if (c == '\'') {
                    if (i <= 0 || term.charAt(i - 1) != '\'') continue;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
                if (!isEscaped) continue;
                isEscaped = false;
            }
            return sb.toString();
        }

        protected String translateComparison(RexNode node) {
            SqlKind kind = node.getKind();
            if (kind == SqlKind.NOT) {
                RexNode negated = (RexNode)((RexCall)node).getOperands().get(0);
                if (negated.isA(SqlKind.AND)) {
                    AndClause andClause = this.translateAndOrBetween(negated, true);
                    return andClause.isBetween ? andClause.toQuery() : "-" + andClause.toQuery();
                }
                return "-" + (negated.getKind() == SqlKind.LIKE ? this.translateLike(negated) : this.translateMatch(negated));
            }
            Pair<String, RexLiteral> binaryTranslated = this.getFieldValuePair(node);
            String key = (String)binaryTranslated.getKey();
            RexLiteral value = (RexLiteral)binaryTranslated.getValue();
            switch (kind) {
                case EQUALS: {
                    return this.toEqualsClause(key, value);
                }
                case NOT_EQUALS: {
                    return "-" + this.toEqualsClause(key, value);
                }
                case LESS_THAN: {
                    return "(" + key + ": [ * TO " + this.toSolrLiteral(key, value) + " })";
                }
                case LESS_THAN_OR_EQUAL: {
                    return "(" + key + ": [ * TO " + this.toSolrLiteral(key, value) + " ])";
                }
                case GREATER_THAN: {
                    return "(" + key + ": { " + this.toSolrLiteral(key, value) + " TO * ])";
                }
                case GREATER_THAN_OR_EQUAL: {
                    return "(" + key + ": [ " + this.toSolrLiteral(key, value) + " TO * ])";
                }
                case LIKE: {
                    return this.translateLike(node);
                }
                case IS_NOT_NULL: 
                case IS_NULL: {
                    return this.translateIsNullOrIsNotNull(node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + String.valueOf(node)));
        }

        private String toEqualsClause(String key, RexLiteral value) {
            if (key != null && key.isEmpty()) {
                return "-*:*";
            }
            Object terms = this.toSolrLiteral(key, value).trim();
            if (!(((String)terms).startsWith("(") || ((String)terms).startsWith("[") || ((String)terms).startsWith("{"))) {
                terms = ((String)terms).contains("*") || ((String)terms).contains("?") ? this.escapeWithWildcard((String)terms) : "\"" + ClientUtils.escapeQueryChars((String)terms) + "\"";
            }
            return key + ":" + (String)terms;
        }

        private String escapeWithWildcard(String terms) {
            Object escaped = ClientUtils.escapeQueryChars((String)terms).replace("\\*", "*").replace("\\?", "?").replace("\\ ", " ");
            if (((String)escaped).split("\\s+").length > 1) {
                escaped = "(" + (String)escaped + ")";
            }
            return escaped;
        }

        private String toSolrLiteral(String solrField, RexLiteral literal) {
            Object value2;
            Object object = value2 = literal != null ? literal.getValue2() : null;
            if (value2 == null) {
                return "";
            }
            SqlTypeName typeName = literal.getTypeName();
            String solrLiteral = null;
            if (value2 instanceof Long && (typeName == SqlTypeName.TIMESTAMP || typeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
                solrLiteral = Instant.ofEpochMilli((Long)value2).toString();
            } else if (typeName == SqlTypeName.TIMESTAMP && value2 instanceof String && CALCITE_TIMESTAMP_REGEX.matcher((String)value2).matches()) {
                solrLiteral = this.toSolrTimestamp((String)value2);
            } else if (typeName == SqlTypeName.CHAR && value2 instanceof String && (CALCITE_TIMESTAMP_REGEX.matcher((String)value2).matches() || CALCITE_DATE_ONLY_REGEX.matcher((String)value2).matches())) {
                RelDataType fieldType = this.getFieldType(solrField);
                if (fieldType != null && fieldType.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
                    solrLiteral = this.toSolrTimestamp((String)value2);
                }
            } else if (typeName == SqlTypeName.DECIMAL) {
                BigDecimal bigDecimal = (BigDecimal)literal.getValueAs(BigDecimal.class);
                solrLiteral = bigDecimal != null ? bigDecimal.toString() : "";
            }
            return solrLiteral != null ? solrLiteral : value2.toString();
        }

        private String toSolrTimestamp(String ts) {
            Object timestamp = ts;
            if (ts.indexOf(32) != -1) {
                timestamp = ts.replace(' ', 'T').replace("'", "");
            } else if (ts.length() == 10) {
                timestamp = ts + "T00:00:00Z";
            }
            if (Character.isDigit(((String)timestamp).charAt(((String)timestamp).length() - 1))) {
                timestamp = (String)timestamp + "Z";
            }
            return timestamp;
        }

        protected Pair<Pair<String, RexLiteral>, Character> getFieldValuePairWithEscapeCharacter(RexNode node) {
            if (!(node instanceof RexCall)) {
                throw new AssertionError((Object)("expected RexCall for predicate but found: " + String.valueOf(node)));
            }
            RexCall call = (RexCall)node;
            if (call.getOperands().size() == 3) {
                RexLiteral literal;
                RexNode escapeNode = (RexNode)call.getOperands().get(2);
                Character escapeChar = null;
                if (escapeNode.getKind() == SqlKind.LITERAL && (literal = (RexLiteral)escapeNode).getTypeName() == SqlTypeName.CHAR) {
                    escapeChar = (Character)literal.getValueAs(Character.class);
                }
                return Pair.of(this.translateBinary2((RexNode)call.getOperands().get(0), (RexNode)call.getOperands().get(1)), (Object)escapeChar);
            }
            return Pair.of(this.getFieldValuePair(node), null);
        }

        protected Pair<String, RexLiteral> getFieldValuePair(RexNode node) {
            Pair<String, RexLiteral> binaryTranslated;
            if (!(node instanceof RexCall)) {
                throw new AssertionError((Object)("expected RexCall for predicate but found: " + String.valueOf(node)));
            }
            RexCall call = (RexCall)node;
            Pair<String, RexLiteral> pair = binaryTranslated = call.getOperands().size() == 2 ? this.translateBinary(call) : null;
            if (binaryTranslated == null) {
                throw new AssertionError((Object)("unsupported predicate expression: " + String.valueOf(node)));
            }
            return binaryTranslated;
        }

        protected Pair<String, RexLiteral> translateBinary(RexCall call) {
            String rightLit;
            String leftLit;
            RexCall cast;
            Pair<String, RexLiteral> b;
            RexNode right;
            List operands = call.getOperands();
            if (operands.size() != 2) {
                throw new AssertionError((Object)("Invalid number of arguments - " + operands.size()));
            }
            RexNode left = (RexNode)operands.get(0);
            Pair<String, RexLiteral> a = this.translateBinary2(left, right = (RexNode)operands.get(1));
            if (a != null) {
                return a;
            }
            if ((call.op.kind == SqlKind.EQUALS || call.op.kind == SqlKind.NOT_EQUALS) && (b = this.translateBinary2(right, left)) != null) {
                return b;
            }
            if (left.getKind() == SqlKind.CAST && right.getKind() == SqlKind.CAST) {
                return this.translateBinary2((RexNode)((RexCall)left).getOperands().get(0), (RexNode)((RexCall)right).getOperands().get(0));
            }
            if (left.getKind() == SqlKind.INPUT_REF && right.getKind() == SqlKind.CAST && (cast = (RexCall)right).getOperands().size() == 1 && ((RexNode)cast.getOperands().get(0)).getKind() == SqlKind.LITERAL) {
                return this.translateBinary2(left, (RexNode)cast.getOperands().get(0));
            }
            if (left.getKind() == SqlKind.LITERAL && right.getKind() == SqlKind.LITERAL && !(leftLit = this.toSolrLiteral("", (RexLiteral)left)).equals(rightLit = this.toSolrLiteral("", (RexLiteral)right))) {
                return new Pair((Object)"", (Object)((RexLiteral)right));
            }
            throw new AssertionError((Object)("cannot translate call " + String.valueOf(call)));
        }

        protected Pair<String, RexLiteral> translateBinary2(RexNode left, RexNode right) {
            if (log.isDebugEnabled()) {
                log.debug("translateBinary2 left={} right={}", (Object)left, (Object)right);
            }
            if (right.getKind() != SqlKind.LITERAL) {
                if (log.isDebugEnabled()) {
                    log.debug("right != SqlKind.LITERAL, return null");
                }
                return null;
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    return new Pair((Object)name, (Object)rightLiteral);
                }
                case CAST: {
                    return this.translateBinary2((RexNode)((RexCall)left).getOperands().get(0), right);
                }
            }
            return null;
        }

        protected String translateSearch(RexNode condition) {
            RexNode peekAt0;
            String fieldName = this.getSolrFieldName(condition);
            RexCall expanded = (RexCall)RexUtil.expandSearch((RexBuilder)this.builder, null, (RexNode)condition);
            RexNode rexNode = peekAt0 = !expanded.getOperands().isEmpty() ? (RexNode)expanded.getOperands().get(0) : null;
            if (expanded.op.kind == SqlKind.AND) {
                if (peekAt0 instanceof RexCall) {
                    RexCall op0 = (RexCall)peekAt0;
                    if (op0.op.kind == SqlKind.NOT_EQUALS) {
                        return "*:* -" + fieldName + ":" + this.toOrSetOnSameField(fieldName, expanded);
                    }
                }
            } else if (expanded.op.kind == SqlKind.OR && peekAt0 instanceof RexCall) {
                RexCall op0 = (RexCall)peekAt0;
                if (op0.op.kind == SqlKind.EQUALS) {
                    return fieldName + ":" + this.toOrSetOnSameField(fieldName, expanded);
                }
            }
            if (expanded.getKind() != SqlKind.SEARCH) {
                return this.translateMatch((RexNode)expanded);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported search filter: " + String.valueOf(condition));
        }

        protected String toOrSetOnSameField(String solrField, RexCall search) {
            String orClause = search.getOperands().stream().map(n -> {
                RexCall next = (RexCall)n;
                RexLiteral lit = (RexLiteral)next.getOperands().get(1);
                return "\"" + this.toSolrLiteral(solrField, lit) + "\"";
            }).collect(Collectors.joining(" OR "));
            return "(" + orClause + ")";
        }

        protected String getSolrFieldName(RexNode node) {
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.getOperands().get(0);
            if (left instanceof RexInputRef) {
                return this.fieldNames.get(((RexInputRef)left).getIndex());
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Expected Solr field name for " + String.valueOf(call.getKind()) + " but found " + String.valueOf(left));
        }
    }

    private static final class AndClause {
        boolean isBetween;
        String query;

        AndClause(String query, boolean isBetween) {
            this.query = query;
            this.isBetween = isBetween;
        }

        String toQuery() {
            return "(" + this.query + ")";
        }
    }
}

