/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiSupport;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.ApiMapping;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public abstract class BaseHandlerApiSupport
implements ApiSupport {
    protected final Map<SolrRequest.METHOD, Map<ApiMapping.V2EndPoint, List<ApiCommand>>> commandsMapping = new HashMap<SolrRequest.METHOD, Map<ApiMapping.V2EndPoint, List<ApiCommand>>>();

    protected BaseHandlerApiSupport() {
        for (ApiCommand cmd : this.getCommands()) {
            List<ApiCommand> list;
            Map<ApiMapping.V2EndPoint, List<ApiCommand>> m = this.commandsMapping.get(cmd.meta().getHttpMethod());
            if (m == null) {
                m = new HashMap<ApiMapping.V2EndPoint, List<ApiCommand>>();
                this.commandsMapping.put(cmd.meta().getHttpMethod(), m);
            }
            if ((list = m.get(cmd.meta().getEndPoint())) == null) {
                list = new ArrayList<ApiCommand>();
                m.put(cmd.meta().getEndPoint(), list);
            }
            list.add(cmd);
        }
    }

    @Override
    public synchronized Collection<Api> getApis() {
        return this.getEndPoints().stream().map(this::getApi).collect(Collectors.toUnmodifiableList());
    }

    private Api getApi(final ApiMapping.V2EndPoint op) {
        final BaseHandlerApiSupport apiHandler = this;
        return new Api(Utils.getSpec((String)op.getSpecName())){

            @Override
            public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                SolrParams params = req.getParams();
                SolrRequest.METHOD method = SolrRequest.METHOD.valueOf((String)req.getHttpMethod());
                List<ApiCommand> commands = BaseHandlerApiSupport.this.commandsMapping.get(method).get(op);
                try {
                    if (method == SolrRequest.METHOD.POST) {
                        List<CommandOperation> cmds = req.getCommands(true);
                        if (cmds.size() > 1) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one command is allowed");
                        }
                        CommandOperation c = cmds.size() == 0 ? null : cmds.get(0);
                        ApiCommand command = null;
                        String commandName = c == null ? null : c.name;
                        for (ApiCommand cmd : commands) {
                            if (!Objects.equals(cmd.meta().getName(), commandName)) continue;
                            command = cmd;
                            break;
                        }
                        if (command == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " no such command " + String.valueOf(c));
                        }
                        BaseHandlerApiSupport.wrapParams(req, c, command, false);
                        command.invoke(req, rsp, apiHandler);
                    } else {
                        if (commands == null || commands.isEmpty()) {
                            rsp.add("error", "No support for : " + String.valueOf(method) + " at :" + req.getPath());
                            return;
                        }
                        if (commands.size() > 1) {
                            for (ApiCommand command : commands) {
                                if (!command.meta().getName().equals(req.getPath())) continue;
                                commands = Collections.singletonList(command);
                                break;
                            }
                        }
                        BaseHandlerApiSupport.wrapParams(req, new CommandOperation("", Collections.emptyMap()), commands.get(0), true);
                        commands.get(0).invoke(req, rsp, apiHandler);
                    }
                }
                catch (SolrException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
                finally {
                    req.setParams(params);
                }
            }
        };
    }

    private static void wrapParams(SolrQueryRequest req, final CommandOperation co, final ApiCommand cmd, final boolean useRequestParams) {
        final Map<String, String> pathValues = req.getPathTemplateValues();
        final Map map = co == null || !(co.getCommandData() instanceof Map) ? Collections.singletonMap("", co.getCommandData()) : co.getDataMap();
        final SolrParams origParams = req.getParams();
        req.setParams(new SolrParams(){

            public String get(String param) {
                Object vals = this.getParams0(param);
                if (vals == null) {
                    return null;
                }
                if (vals instanceof String) {
                    return (String)vals;
                }
                if (vals instanceof Boolean || vals instanceof Number) {
                    return String.valueOf(vals);
                }
                if (vals instanceof String[] && ((String[])vals).length > 0) {
                    return ((String[])vals)[0];
                }
                return null;
            }

            private Object getParams0(String param) {
                Object o;
                param = cmd.meta().getParamSubstitute(param);
                Object object = o = param.indexOf(46) > 0 ? Utils.getObjectByPath((Object)map, (boolean)true, (List)StrUtils.splitSmart((String)param, (char)'.')) : map.get(param);
                if (o == null) {
                    o = pathValues.get(param);
                }
                if (o == null && useRequestParams) {
                    o = origParams.getParams(param);
                }
                if (o instanceof List) {
                    List l = (List)o;
                    return l.toArray(new String[0]);
                }
                return o;
            }

            public String[] getParams(String param) {
                String[] stringArray;
                Object vals = this.getParams0(param);
                if (vals == null || vals instanceof String[]) {
                    stringArray = (String[])vals;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = vals.toString();
                }
                return stringArray;
            }

            public Iterator<String> getParameterNamesIterator() {
                return cmd.meta().getParamNamesIterator(co);
            }

            public Map<String, Object> toMap(Map<String, Object> suppliedMap) {
                Iterator<String> it = this.getParameterNamesIterator();
                while (it.hasNext()) {
                    Class<?> oClass;
                    Object o;
                    String param = it.next();
                    String key = cmd.meta().getParamSubstitute(param);
                    Object object = o = key.indexOf(46) > 0 ? Utils.getObjectByPath((Object)map, (boolean)true, (List)StrUtils.splitSmart((String)key, (char)'.')) : map.get(key);
                    if (o == null) {
                        o = pathValues.get(key);
                    }
                    if (o == null && useRequestParams) {
                        o = origParams.getParams(key);
                    }
                    if ((oClass = o.getClass()).isPrimitive() || Number.class.isAssignableFrom(oClass) || Character.class.isAssignableFrom(oClass) || Boolean.class.isAssignableFrom(oClass)) {
                        suppliedMap.put(param, String.valueOf(o));
                        continue;
                    }
                    if (List.class.isAssignableFrom(oClass) && ((List)o).get(0) instanceof String) {
                        List l = (List)o;
                        suppliedMap.put(param, l.toArray(new String[0]));
                        continue;
                    }
                    suppliedMap.put(param, o);
                }
                return suppliedMap;
            }
        });
    }

    protected abstract Collection<ApiCommand> getCommands();

    protected abstract Collection<ApiMapping.V2EndPoint> getEndPoints();

    public static interface ApiCommand {
        public ApiMapping.CommandMeta meta();

        public void invoke(SolrQueryRequest var1, SolrQueryResponse var2, BaseHandlerApiSupport var3) throws Exception;
    }
}

